/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GT_MetaTileEntity_IntegratedOreFactory
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_IntegratedOreFactory>
implements ISurvivalConstructable {
    private static final int CASING_INDEX1 = 183;
    private static final int CASING_INDEX2 = 49;
    private static final int MAX_PARA = 1024;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_IntegratedOreFactory> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"           ", "           ", "       WWW ", "       WWW ", "           ", "           "}, {"           ", "       sss ", "      sppps", "      sppps", "       sss ", "           "}, {"           ", "       sss ", "      s   s", "      s   s", "       sss ", "           "}, {"           ", "       sss ", "      sppps", "      sppps", "       sss ", "           "}, {"           ", "       sss ", "      s   s", "      s   s", "       sss ", "           "}, {"           ", "       sss ", "      sppps", "      sppps", "       sss ", "           "}, {"iiiiii     ", "iIIIIiisssi", "iIIIIis   s", "iIIIIis   s", "iIIIIiisssi", "iiiiii     "}, {"iggggi     ", "gt  t isssi", "g xx  sppps", "g xx  sppps", "gt  t isssi", "iggggi     "}, {"iggggi     ", "gt  t isssi", "g xx  s   s", "g xx  s   s", "gt  t isssi", "iggggi     "}, {"iggggi     ", "gt  t is~si", "g xx  spppO", "g xx  spppO", "gt  t isssi", "iggggi     "}, {"iggggi     ", "gt  t isssi", "g xx  s   O", "g xx  s   O", "gt  t isssi", "iggggi     "}, {"EEEEEE     ", "EEEEEEEEEEE", "EEEEEEEEEEE", "EEEEEEEEEEE", "EEEEEEEEEEE", "EEEEEE     "}})).addElement('i', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings8, (int)7)).addElement('s', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)).addElement('g', Glasses.chainAllGlasses()).addElement('x', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)3)).addElement('p', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings2, (int)15)).addElement('t', GT_StructureUtility.ofFrame(Materials.TungstenSteel)).addElement('E', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_IntegratedOreFactory.class).atLeast(GT_HatchElement.Energy, GT_HatchElement.Maintenance).casingIndex(183).dot(1).buildAndChain(GregTech_API.sBlockCasings8, 7)).addElement('I', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_IntegratedOreFactory.class).atLeast(GT_HatchElement.InputBus).casingIndex(183).dot(2).buildAndChain(GregTech_API.sBlockCasings8, 7)).addElement('W', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_IntegratedOreFactory.class).atLeast(GT_HatchElement.InputHatch, GT_HatchElement.Muffler).casingIndex(49).dot(3).buildAndChain(GregTech_API.sBlockCasings4, 1)).addElement('O', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_IntegratedOreFactory.class).atLeast(GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch).casingIndex(49).dot(4).buildAndChain(GregTech_API.sBlockCasings4, 1)).build();
    private static final HashSet<Integer> isCrushedOre = new HashSet();
    private static final HashSet<Integer> isCrushedPureOre = new HashSet();
    private static final HashSet<Integer> isPureDust = new HashSet();
    private static final HashSet<Integer> isImpureDust = new HashSet();
    private static final HashSet<Integer> isThermal = new HashSet();
    private static final HashSet<Integer> isOre = new HashSet();
    private static boolean isInit = false;
    private ItemStack[] sMidProduct;
    private int sMode = 0;
    private boolean sVoidStone = false;
    private int currentParallelism = 0;

    private static void initHash() {
        for (String name : OreDictionary.getOreNames()) {
            if (name == null || name.isEmpty()) continue;
            if (name.startsWith("crushedPurified")) {
                for (ItemStack stack : OreDictionary.getOres((String)name)) {
                    isCrushedPureOre.add(GT_Utility.stackToInt(stack));
                }
                continue;
            }
            if (name.startsWith("crushedCentrifuged")) {
                for (ItemStack stack : OreDictionary.getOres((String)name)) {
                    isThermal.add(GT_Utility.stackToInt(stack));
                }
                continue;
            }
            if (name.startsWith("crushed")) {
                for (ItemStack stack : OreDictionary.getOres((String)name)) {
                    isCrushedOre.add(GT_Utility.stackToInt(stack));
                }
                continue;
            }
            if (name.startsWith("dustImpure")) {
                for (ItemStack stack : OreDictionary.getOres((String)name)) {
                    isImpureDust.add(GT_Utility.stackToInt(stack));
                }
                continue;
            }
            if (name.startsWith("dustPure")) {
                for (ItemStack stack : OreDictionary.getOres((String)name)) {
                    isPureDust.add(GT_Utility.stackToInt(stack));
                }
                continue;
            }
            if (!name.startsWith("ore")) continue;
            for (ItemStack stack : OreDictionary.getOres((String)name)) {
                isOre.add(GT_Utility.stackToInt(stack));
            }
        }
    }

    public GT_MetaTileEntity_IntegratedOreFactory(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_IntegratedOreFactory(String aName) {
        super(aName);
    }

    public boolean addFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_IntegratedOreFactory> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Ore Processor").addInfo("Controller Block for the Integrated Ore Factory").addInfo("It is OP. I mean ore processor.").addInfo("Do all ore procession in one step.").addInfo("Can process up to 1024 ores per time.").addInfo("Every ore costs 30EU/t, 2L lubricant, 200L distilled water.").addInfo("Process time is depend on mode.").addInfo("Use a screwdriver to switch mode.").addInfo("Sneak click with screwdriver to void the stone dusts.").addSeparator().beginStructureBlock(6, 12, 11, false).addController("The third layer").addStructureInfo("128 advanced iridium plated machine casing").addStructureInfo("105 clean stainless steel machine casing").addStructureInfo("48 reinforced glass").addStructureInfo("30 tungstensteel pipe casing").addStructureInfo("16 tungstensteel frame box").addStructureInfo("16 steel gear box casing").addEnergyHatch("Button Casing", 1).addMaintenanceHatch("Button Casing", 1).addInputBus("Input ore/crushed ore", 2).addInputHatch("Input lubricant/distilled water/washing chemicals", 3).addMufflerHatch("Output Pollution", 3).addOutputBus("Output products", 4).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> !r.isUpsideDown() && !f.isVerticallyFliped();
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, itemStack, b, 8, 9, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 8, 9, 1, elementBudget, env, false, true);
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    private static int getTime(int mode) {
        int n;
        switch (mode) {
            case 0: {
                n = 600;
                break;
            }
            case 1: {
                n = 300;
                break;
            }
            case 2: {
                n = 200;
                break;
            }
            case 3: {
                n = 400;
                break;
            }
            case 4: {
                n = 340;
                break;
            }
            default: {
                n = 1000000000;
            }
        }
        return n;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (!isInit) {
            GT_MetaTileEntity_IntegratedOreFactory.initHash();
            isInit = true;
        }
        int tCharged = 1024;
        ArrayList<ItemStack> tInput = this.getStoredInputs();
        ArrayList<FluidStack> tInputFluid = this.getStoredFluids();
        int tLube = 0;
        int tWater = 0;
        for (FluidStack fluid : tInputFluid) {
            if (fluid != null && fluid.equals((Object)GT_ModHandler.getDistilledWater(1L))) {
                tWater += fluid.amount;
                continue;
            }
            if (fluid == null || !fluid.equals((Object)Materials.Lubricant.getFluid(1L))) continue;
            tLube += fluid.amount;
        }
        tCharged = Math.min(tCharged, tLube / 2);
        tCharged = Math.min(tCharged, tWater / 200);
        ArrayList<ItemStack> tOres = new ArrayList<ItemStack>();
        int tRealUsed = 0;
        for (ItemStack ore : tInput) {
            if (tCharged <= 0) break;
            int tID = GT_Utility.stackToInt(ore);
            if (tID == 0 || !isPureDust.contains(tID) && !isImpureDust.contains(tID) && !isCrushedPureOre.contains(tID) && !isThermal.contains(tID) && !isCrushedOre.contains(tID) && !isOre.contains(tID)) continue;
            if (ore.field_77994_a <= tCharged) {
                tRealUsed += ore.field_77994_a;
                tOres.add(GT_Utility.copy(ore));
                tCharged -= ore.field_77994_a;
                ore.field_77994_a = 0;
                continue;
            }
            tRealUsed = tCharged;
            tOres.add(GT_Utility.copyAmountUnsafe(tCharged, ore));
            ore.field_77994_a -= tCharged;
            tCharged = 0;
            break;
        }
        this.setCurrentParallelism(tRealUsed);
        if (tRealUsed == 0) {
            return false;
        }
        this.depleteInput(GT_ModHandler.getDistilledWater((long)tRealUsed * 200L));
        this.depleteInput(Materials.Lubricant.getFluid((long)tRealUsed * 2L));
        this.sMidProduct = tOres.toArray(new ItemStack[0]);
        switch (this.sMode) {
            case 0: {
                this.doMac(isOre);
                this.doWash(isCrushedOre);
                this.doThermal(isCrushedPureOre, isCrushedOre);
                this.doMac(isThermal, isOre, isCrushedOre, isCrushedPureOre);
                break;
            }
            case 1: {
                this.doMac(isOre);
                this.doWash(isCrushedOre);
                this.doMac(isOre, isCrushedOre, isCrushedPureOre);
                this.doCentrifuge(isImpureDust, isPureDust);
                break;
            }
            case 2: {
                this.doMac(isOre);
                this.doMac(isThermal, isOre, isCrushedOre, isCrushedPureOre);
                this.doCentrifuge(isImpureDust, isPureDust);
                break;
            }
            case 3: {
                this.doMac(isOre);
                this.doWash(isCrushedOre);
                this.doSift(isCrushedPureOre);
                break;
            }
            case 4: {
                this.doMac(isOre);
                this.doChemWash(isCrushedOre, isCrushedPureOre);
                this.doMac(isCrushedOre, isCrushedPureOre);
                this.doCentrifuge(isImpureDust, isPureDust);
                break;
            }
            default: {
                return false;
            }
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.mOutputItems = this.sMidProduct;
        this.calculateOverclockedNessMultiInternal(30L * (long)tRealUsed, GT_MetaTileEntity_IntegratedOreFactory.getTime(this.sMode), 1, this.getMaxInputVoltage(), false);
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.updateSlots();
        return true;
    }

    @SafeVarargs
    private boolean checkTypes(int aID, HashSet<Integer> ... aTables) {
        for (HashSet<Integer> set : aTables) {
            if (!set.contains(aID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aPlayer.func_70093_af()) {
            this.sVoidStone = !this.sVoidStone;
            GT_Utility.sendChatToPlayer(aPlayer, StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.void", (Object[])new Object[]{this.sVoidStone}));
            return;
        }
        this.sMode = (this.sMode + 1) % 5;
        List<String> des = GT_MetaTileEntity_IntegratedOreFactory.getDisplayMode(this.sMode);
        GT_Utility.sendChatToPlayer(aPlayer, String.join((CharSequence)"", des));
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.sMode = aNBT.func_74762_e("ssMode");
        this.sVoidStone = aNBT.func_74767_n("ssStone");
        this.currentParallelism = aNBT.func_74762_e("currentParallelism");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("ssMode", this.sMode);
        aNBT.func_74757_a("ssStone", this.sVoidStone);
        aNBT.func_74768_a("currentParallelism", this.currentParallelism);
        super.saveNBTData(aNBT);
    }

    @SafeVarargs
    private void doMac(HashSet<Integer> ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GT_Utility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[15], null, aStack);
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    @SafeVarargs
    private void doWash(HashSet<Integer> ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GT_Utility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sOreWasherRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[15], new FluidStack[]{GT_ModHandler.getDistilledWater(Integer.MAX_VALUE)}, aStack);
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    @SafeVarargs
    private void doThermal(HashSet<Integer> ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GT_Utility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[15], null, aStack);
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    @SafeVarargs
    private void doCentrifuge(HashSet<Integer> ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GT_Utility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[15], null, aStack);
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    @SafeVarargs
    private void doSift(HashSet<Integer> ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GT_Utility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sSifterRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[15], null, aStack);
                    if (tRecipe != null) {
                        tProduct.addAll(this.getOutputStack(tRecipe, aStack.field_77994_a));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    @SafeVarargs
    private void doChemWash(HashSet<Integer> ... aTables) {
        ArrayList<ItemStack> tProduct = new ArrayList<ItemStack>();
        if (this.sMidProduct != null) {
            for (ItemStack aStack : this.sMidProduct) {
                int tID = GT_Utility.stackToInt(aStack);
                if (this.checkTypes(tID, aTables)) {
                    GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sChemicalBathRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[15], this.getStoredFluids().toArray(new FluidStack[0]), aStack);
                    if (tRecipe != null && tRecipe.getRepresentativeFluidInput(0) != null) {
                        FluidStack tInputFluid = tRecipe.getRepresentativeFluidInput(0).copy();
                        int tStored = this.getFluidAmount(tInputFluid);
                        int tWashed = Math.min(tStored / tInputFluid.amount, aStack.field_77994_a);
                        this.depleteInput(new FluidStack(tInputFluid.getFluid(), tWashed * tInputFluid.amount));
                        tProduct.addAll(this.getOutputStack(tRecipe, tWashed));
                        if (tWashed >= aStack.field_77994_a) continue;
                        tProduct.add(GT_Utility.copyAmountUnsafe(aStack.field_77994_a - tWashed, aStack));
                        continue;
                    }
                    tProduct.add(aStack);
                    continue;
                }
                tProduct.add(aStack);
            }
        }
        this.doCompress(tProduct);
    }

    private int getFluidAmount(FluidStack aFluid) {
        int tAmt = 0;
        if (aFluid == null) {
            return 0;
        }
        for (FluidStack fluid : this.getStoredFluids()) {
            if (!aFluid.isFluidEqual(fluid)) continue;
            tAmt += fluid.amount;
        }
        return tAmt;
    }

    private List<ItemStack> getOutputStack(GT_Recipe aRecipe, int aTime) {
        ArrayList<ItemStack> tOutput = new ArrayList<ItemStack>();
        for (int i2 = 0; i2 < aRecipe.mOutputs.length; ++i2) {
            if (aRecipe.getOutput(i2) == null) continue;
            int tChance = aRecipe.getOutputChance(i2);
            if (tChance == 10000) {
                tOutput.add(GT_Utility.copyAmountUnsafe((long)aTime * (long)aRecipe.getOutput((int)i2).field_77994_a, aRecipe.getOutput(i2)));
                continue;
            }
            double u = (double)aTime * ((double)tChance / 10000.0);
            double e = (double)aTime * ((double)tChance / 10000.0) * (1.0 - (double)tChance / 10000.0);
            Random random = new Random();
            int tAmount = (int)Math.ceil(Math.sqrt(e) * random.nextGaussian() + u);
            tOutput.add(GT_Utility.copyAmountUnsafe((long)tAmount * (long)aRecipe.getOutput((int)i2).field_77994_a, aRecipe.getOutput(i2)));
        }
        return tOutput.stream().filter(i -> i != null && i.field_77994_a > 0).collect(Collectors.toList());
    }

    private void doCompress(List<ItemStack> aList) {
        HashMap<Integer, Integer> rProduct = new HashMap<Integer, Integer>();
        for (ItemStack stack : aList) {
            int tID = GT_Utility.stackToInt(stack);
            if (this.sVoidStone && GT_Utility.areStacksEqual(Materials.Stone.getDust(1), stack) || tID == 0) continue;
            if (rProduct.containsKey(tID)) {
                rProduct.put(tID, (Integer)rProduct.get(tID) + stack.field_77994_a);
                continue;
            }
            rProduct.put(tID, stack.field_77994_a);
        }
        this.sMidProduct = new ItemStack[rProduct.size()];
        int cnt = 0;
        for (Integer id : rProduct.keySet()) {
            ItemStack stack = GT_Utility.intToStack(id);
            this.sMidProduct[cnt] = GT_Utility.copyAmountUnsafe(((Integer)rProduct.get(id)).intValue(), stack);
            ++cnt;
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 8, 9, 1) && this.mMaintenanceHatches.size() <= 1 && !this.mMufflerHatches.isEmpty();
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return 200;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_IntegratedOreFactory(this.mName);
    }

    private void setCurrentParallelism(int parallelism) {
        this.currentParallelism = parallelism;
    }

    private int getCurrentParallelism() {
        return this.currentParallelism;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> informationData = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        String parallelism = StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.BLUE + this.getCurrentParallelism() + EnumChatFormatting.RESET;
        informationData.add(parallelism);
        informationData.add(StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.void", (Object[])new Object[]{this.sVoidStone}));
        informationData.addAll(GT_MetaTileEntity_IntegratedOreFactory.getDisplayMode(this.sMode));
        return informationData.toArray(new String[0]);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    private static List<String> getDisplayMode(int mode) {
        EnumChatFormatting AQUA = EnumChatFormatting.AQUA;
        String CRUSH = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Macerate", (Object[])new Object[0]);
        String WASH = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Ore_Washer", (Object[])new Object[0]).replace(" ", " " + AQUA);
        String THERMAL = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Thermal_Centrifuge", (Object[])new Object[0]).replace(" ", " " + AQUA);
        String CENTRIFUGE = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Centrifuge", (Object[])new Object[0]);
        String SIFTER = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Sifter", (Object[])new Object[0]);
        String CHEM_WASH = StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.Chemical_Bathing", (Object[])new Object[0]).replace(" ", " " + AQUA);
        String ARROW = " " + AQUA + "-> ";
        ArrayList<String> des = new ArrayList<String>();
        des.add(StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor1", (Object[])new Object[0]) + " ");
        switch (mode) {
            case 0: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + WASH + ARROW);
                des.add(AQUA + THERMAL + ARROW);
                des.add(AQUA + CRUSH + ' ');
                break;
            }
            case 1: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + WASH + ARROW);
                des.add(AQUA + CENTRIFUGE + ARROW);
                des.add(AQUA + CRUSH + ' ');
                break;
            }
            case 2: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CENTRIFUGE + ' ');
                break;
            }
            case 3: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + WASH + ARROW);
                des.add(AQUA + SIFTER + ' ');
                break;
            }
            case 4: {
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CHEM_WASH + ARROW);
                des.add(AQUA + CRUSH + ARROW);
                des.add(AQUA + CENTRIFUGE + ' ');
                break;
            }
            default: {
                des.add(StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.WRONG_MODE", (Object[])new Object[0]));
            }
        }
        des.add(StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor2", (Object[])new Object[]{GT_MetaTileEntity_IntegratedOreFactory.getTime(mode) / 20}));
        return des;
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(StatCollector.func_74838_a((String)"GT5U.multiblock.parallelism") + ": " + EnumChatFormatting.BLUE + tag.func_74762_e("currentParallelism") + EnumChatFormatting.RESET);
        currenttip.addAll(GT_MetaTileEntity_IntegratedOreFactory.getDisplayMode(tag.func_74762_e("ssMode")));
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.machines.oreprocessor.void", (Object[])new Object[]{tag.func_74767_n("ssStone")}));
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("ssMode", this.sMode);
        tag.func_74757_a("ssStone", this.sVoidStone);
        tag.func_74768_a("currentParallelism", this.currentParallelism);
    }
}

