/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.gui.modularui.GUITextureSet;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.modularui.IGetTitleColor;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Pollution;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_Cleanroom;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class GT_MetaTileEntity_PrimitiveBlastFurnace
extends MetaTileEntity
implements IAlignment,
ISurvivalConstructable,
IAddUIWidgets,
IGetTitleColor {
    public static final int INPUT_SLOTS = 3;
    public static final int OUTPUT_SLOTS = 3;
    private static final ClassValue<IStructureDefinition<GT_MetaTileEntity_PrimitiveBlastFurnace>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<GT_MetaTileEntity_PrimitiveBlastFurnace>>(){

        @Override
        protected IStructureDefinition<GT_MetaTileEntity_PrimitiveBlastFurnace> computeValue(Class<?> type) {
            return IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "c-c", "ccc"}, {"ccc", "clc", "ccc"}, {"c~c", "clc", "ccc"}, {"ccc", "ccc", "ccc"}})).addElement('c', (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofBlock((Block)t.getCasingBlock(), (int)t.getCasingMetaID()))).addElement('l', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.isAir(), StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150353_l, (int)1), StructureUtility.ofBlockAnyMeta((Block)Blocks.field_150356_k, (int)1)})).build();
        }
    };
    public int mMaxProgresstime = 0;
    private volatile boolean mUpdated;
    public int mUpdate = 5;
    public int mProgresstime = 0;
    public boolean mMachine = false;
    public ItemStack[] mOutputItems = new ItemStack[3];
    @Deprecated
    public ItemStack mOutputItem1;
    @Deprecated
    public ItemStack mOutputItem2;

    public GT_MetaTileEntity_PrimitiveBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6);
    }

    public GT_MetaTileEntity_PrimitiveBlastFurnace(String aName) {
        super(aName, 6);
    }

    @Override
    public boolean isSteampowered() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public boolean isPneumatic() {
        return false;
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public boolean isEnetOutput() {
        return false;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return (facing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        this.mProgresstime += aProgress;
        return this.mMaxProgresstime - this.mProgresstime;
    }

    @Override
    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aCoverID) {
        return GregTech_API.getCoverBehaviorNew(aCoverID.toStack()).isSimpleCover() && super.allowCoverOnSide(side, aCoverID);
    }

    @Override
    public abstract MetaTileEntity newMetaEntity(IGregTechTileEntity var1);

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        if (this.mOutputItems != null) {
            for (int i = 0; i < this.mOutputItems.length; ++i) {
                if (this.mOutputItems[i] == null) continue;
                NBTTagCompound tNBT = new NBTTagCompound();
                this.mOutputItems[i].func_77955_b(tNBT);
                aNBT.func_74782_a("mOutputItem" + i, (NBTBase)tNBT);
            }
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mUpdate = 5;
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        this.mOutputItems = new ItemStack[3];
        for (int i = 0; i < 3; ++i) {
            this.mOutputItems[i] = GT_Utility.loadItem(aNBT, "mOutputItem" + i);
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    public ExtendedFacing getExtendedFacing() {
        return ExtendedFacing.of((ForgeDirection)this.getBaseMetaTileEntity().getFrontFacing());
    }

    public void setExtendedFacing(ExtendedFacing alignment) {
        this.getBaseMetaTileEntity().setFrontFacing(alignment.getDirection());
    }

    public IAlignmentLimits getAlignmentLimits() {
        return (d, r, f) -> (d.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && r.isNotRotated() && f.isNotFlipped();
    }

    private boolean checkMachine() {
        return STRUCTURE_DEFINITION.get(this.getClass()).check((Object)this, "main", this.getBaseMetaTileEntity().getWorld(), this.getExtendedFacing(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 1, 2, 0, !this.mMachine);
    }

    protected abstract Block getCasingBlock();

    protected abstract int getCasingMetaID();

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdated = true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        int lavaX = aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1);
        int lavaZ = aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.3, 0.0).setIdentifier((Enum)ParticleFX.LARGE_SMOKE)).setPosition((float)lavaX + XSTR.XSTR_INSTANCE.nextFloat(), aBaseMetaTileEntity.getOffsetY(aBaseMetaTileEntity.getBackFacing(), 1), (float)lavaZ + XSTR.XSTR_INSTANCE.nextFloat()).setWorld(this.getBaseMetaTileEntity().getWorld()).run();
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mUpdated) {
                if (this.mUpdate < 0) {
                    this.mUpdate = 5;
                }
                this.mUpdated = false;
            }
            if (this.mUpdate-- == 0) {
                this.mMachine = this.checkMachine();
            }
            if (this.mMachine) {
                if (this.mMaxProgresstime > 0) {
                    if (++this.mProgresstime >= this.mMaxProgresstime) {
                        this.addOutputProducts();
                        this.mOutputItems = null;
                        this.mProgresstime = 0;
                        this.mMaxProgresstime = 0;
                        GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "steel");
                    }
                } else if (aBaseMetaTileEntity.isAllowedToWork()) {
                    this.checkRecipe();
                }
            }
            if (this.mMaxProgresstime > 0 && aTimer % 20L == 0L) {
                GT_Pollution.addPollution(this.getBaseMetaTileEntity(), GT_Mod.gregtechproxy.mPollutionPrimitveBlastFurnacePerSecond);
            }
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0 && this.mMachine);
            short lavaY = aBaseMetaTileEntity.getYCoord();
            if (aBaseMetaTileEntity.isActive()) {
                if (aBaseMetaTileEntity.getAir(lavaX, lavaY, lavaZ)) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(lavaX, (int)lavaY, lavaZ, Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
                if (aBaseMetaTileEntity.getAir(lavaX, lavaY + 1, lavaZ)) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(lavaX, lavaY + 1, lavaZ, Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
            } else {
                Block lowerLava = aBaseMetaTileEntity.getBlock(lavaX, lavaY, lavaZ);
                Block upperLava = aBaseMetaTileEntity.getBlock(lavaX, lavaY + 1, lavaZ);
                if (lowerLava == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(lavaX, (int)lavaY, lavaZ, Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
                if (upperLava == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(lavaX, lavaY + 1, lavaZ, Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
            }
        }
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isClientSide()) {
            StructureLibAPI.queryAlignment((IAlignmentProvider)((IAlignmentProvider)aBaseMetaTileEntity));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isActive()) {
            double z;
            double x;
            ForgeDirection frontFacing = aBaseMetaTileEntity.getFrontFacing();
            double oX = (double)aBaseMetaTileEntity.getOffsetX(frontFacing, 1) + 0.5;
            double oY = aBaseMetaTileEntity.getOffsetY(frontFacing, 1);
            double oZ = (double)aBaseMetaTileEntity.getOffsetZ(frontFacing, 1) + 0.5;
            double offset = -0.48;
            double horizontal = (double)XSTR.XSTR_INSTANCE.nextFloat() * 8.0 / 16.0 - 0.25;
            double y = oY + (double)XSTR.XSTR_INSTANCE.nextFloat() * 10.0 / 16.0 + 0.3125;
            if (frontFacing == ForgeDirection.WEST) {
                x = oX - -0.48;
                z = oZ + horizontal;
            } else if (frontFacing == ForgeDirection.EAST) {
                x = oX + -0.48;
                z = oZ + horizontal;
            } else if (frontFacing == ForgeDirection.NORTH) {
                x = oX + horizontal;
                z = oZ - -0.48;
            } else {
                x = oX + horizontal;
                z = oZ + -0.48;
            }
            WorldSpawnedEventBuilder.ParticleEventBuilder particleEventBuilder = new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.0, 0.0).setPosition(x, y, z).setWorld(this.getBaseMetaTileEntity().getWorld());
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.SMOKE)).run();
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.FLAME)).run();
        }
    }

    @Override
    public Class<?> getType() {
        return GT_MetaTileEntity_Cleanroom.class;
    }

    protected GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sPrimitiveBlastRecipes;
    }

    private void addOutputProducts() {
        if (this.mOutputItems == null) {
            return;
        }
        int limit = Math.min(this.mOutputItems.length, 3);
        for (int i = 0; i < limit; ++i) {
            int absi = 3 + i;
            if (this.mInventory[absi] == null) {
                this.mInventory[absi] = GT_Utility.copyOrNull(this.mOutputItems[i]);
                continue;
            }
            if (!GT_Utility.areStacksEqual(this.mInventory[absi], this.mOutputItems[i])) continue;
            this.mInventory[absi].field_77994_a = Math.min(this.mInventory[absi].func_77976_d(), this.mInventory[absi].field_77994_a + this.mOutputItems[i].field_77994_a);
        }
    }

    private boolean spaceForOutput(ItemStack outputStack, int relativeOutputSlot) {
        int absoluteSlot = relativeOutputSlot + 3;
        if (this.mInventory[absoluteSlot] == null || outputStack == null) {
            return true;
        }
        return this.mInventory[absoluteSlot].field_77994_a + outputStack.field_77994_a <= this.mInventory[absoluteSlot].func_77976_d() && GT_Utility.areStacksEqual(this.mInventory[absoluteSlot], outputStack);
    }

    private boolean checkRecipe() {
        int i;
        if (!this.mMachine) {
            return false;
        }
        ItemStack[] inputs = new ItemStack[3];
        System.arraycopy(this.mInventory, 0, inputs, 0, 3);
        GT_Recipe recipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, 0L, null, inputs);
        if (recipe == null) {
            this.mOutputItems = null;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (this.spaceForOutput(recipe.getOutput(i), i)) continue;
            this.mOutputItems = null;
            return false;
        }
        if (!recipe.isRecipeInputEqual(true, null, inputs)) {
            this.mOutputItems = null;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a != 0) continue;
            this.mInventory[i] = null;
        }
        this.mMaxProgresstime = recipe.mDuration;
        this.mOutputItems = recipe.mOutputs;
        return true;
    }

    @Override
    public boolean isGivingInformation() {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return aIndex > 3;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return !GT_Utility.areStacksEqual(aStack, this.mInventory[0]);
    }

    @Override
    public byte getTileEntityBaseType() {
        return 0;
    }

    public abstract String getName();

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return STRUCTURE_DEFINITION.get(this.getClass()).survivalBuild((Object)this, stackSize, "main", this.getBaseMetaTileEntity().getWorld(), this.getExtendedFacing(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 1, 2, 0, elementBudget, env, false);
    }

    public IStructureDefinition<?> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        STRUCTURE_DEFINITION.get(this.getClass()).buildOrHints((Object)this, stackSize, "main", this.getBaseMetaTileEntity().getWorld(), this.getExtendedFacing(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord(), 1, 2, 0, hintsOnly);
    }

    @Override
    public boolean useModularUI() {
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 0).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_INGOT_STEAM.get(this.getSteamVariant())}).setPos(33, 15))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 1).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_DUST_STEAM.get(this.getSteamVariant())}).setPos(33, 33))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 2).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_FURNACE_STEAM.get(this.getSteamVariant())}).setPos(33, 51))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 3).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_INGOT_STEAM.get(this.getSteamVariant())}).setPos(85, 24))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 4).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_DUST_STEAM.get(this.getSteamVariant())}).setPos(103, 24))).widget(new SlotWidget((IItemHandlerModifiable)this.inventoryHandler, 5).setAccess(true, false).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_DUST_STEAM.get(this.getSteamVariant())}).setPos(121, 24))).widget(new ProgressBar().setTexture(GT_UITextures.PROGRESSBAR_ARROW_2_STEAM.get(this.getSteamVariant()), 20).setProgress(() -> Float.valueOf((float)this.mProgresstime / (float)this.mMaxProgresstime)).setNEITransferRect(this.getRecipeMap().mNEIName).setPos(58, 24).setSize(20, 18));
    }

    @Override
    public GUITextureSet getGUITextureSet() {
        return GUITextureSet.STEAM.apply(this.getSteamVariant());
    }

    @Override
    public int getTitleColor() {
        return this.getSteamVariant() == SteamVariant.BRONZE ? (Integer)this.COLOR_TITLE.get() : (Integer)this.COLOR_TITLE_WHITE.get();
    }
}

