/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multiblock;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.multitileentity.multiblock.base.MultiBlockPart;
import gregtech.api.multitileentity.multiblock.base.StackableController;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class Macerator
extends StackableController<Macerator> {
    private static IStructureDefinition<Macerator> STRUCTURE_DEFINITION = null;

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.macerator";
    }

    @Override
    public IStructureDefinition<Macerator> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STACKABLE_TOP, StructureUtility.transpose((String[][])new String[][]{{" CCC ", "CCCCC", "CCCCC", "CCCCC", " CCC "}})).addShape(STACKABLE_MIDDLE, StructureUtility.transpose((String[][])new String[][]{{"  BBB  ", " B---B ", "DC---CD", " B---B ", "  BBB  "}})).addShape(STACKABLE_BOTTOM, StructureUtility.transpose((String[][])new String[][]{{" G~F ", "AAAAA", "AAAAA", "AAAAA", " AAA "}})).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.casings", this.getCasingMeta(), MultiBlockPart.ENERGY_IN)})).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{this.addMultiTileCasing("gt.multitileentity.casings", this.getCasingMeta(), MultiBlockPart.FLUID_IN | MultiBlockPart.ITEM_IN | MultiBlockPart.FLUID_OUT | MultiBlockPart.ITEM_OUT)})).addElement('C', this.addMultiTileCasing("gt.multitileentity.casings", this.getCasingMeta(), 0)).addElement('D', this.addMultiTileCasing("gt.multitileentity.casings", this.getCasingMeta(), 0)).addElement('F', this.addMotorCasings(0)).addElement('G', this.addMultiTileCasing("gt.multitileentity.component.casings", 10000, 0)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    @Override
    public short getCasingRegistryID() {
        return 0;
    }

    @Override
    public int getCasingMeta() {
        return 18000;
    }

    @Override
    public boolean hasTop() {
        return true;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Macerator").addInfo("Controller for the Macerator").addSeparator().beginVariableStructureBlock(7, 9, 2 + this.getMinStacks(), 2 + this.getMaxStacks(), 7, 9, true).addController("Bottom Front Center").addCasingInfoExactly("Test Casing", 60, false).addEnergyHatch("Any bottom layer casing").addInputHatch("Any non-optional external facing casing on the stacks").addInputBus("Any non-optional external facing casing on the stacks").addOutputHatch("Any non-optional external facing casing on the stacks").addOutputBus("Any non-optional external facing casing on the stacks").addStructureInfo(String.format("Stackable middle stacks between %d-%d time(s).", this.getMinStacks(), this.getMaxStacks())).toolTipFinisher("Wildcard");
        return tt;
    }

    @Override
    public int getMinStacks() {
        return 1;
    }

    @Override
    public int getMaxStacks() {
        return 10;
    }

    @Override
    public Vec3Impl getStartingStructureOffset() {
        return new Vec3Impl(2, 0, 0);
    }

    @Override
    public Vec3Impl getStartingStackOffset() {
        return new Vec3Impl(1, 1, 0);
    }

    @Override
    public Vec3Impl getPerStackOffset() {
        return new Vec3Impl(0, 1, 0);
    }

    @Override
    public Vec3Impl getAfterLastStackOffset() {
        return new Vec3Impl(-1, 0, 0);
    }

    @Override
    protected boolean checkRecipe() {
        if (this.isSeparateInputs()) {
            for (Pair<ItemStack[], String> tItemInputs : this.getItemInputsForEachInventory()) {
                if (!this.processRecipe((ItemStack[])tItemInputs.getLeft(), (String)tItemInputs.getRight())) continue;
                return true;
            }
            return false;
        }
        ItemStack[] tItemInputs = this.getInventoriesForInput().getStacks().toArray(new ItemStack[0]);
        return this.processRecipe(tItemInputs, null);
    }

    private boolean processRecipe(ItemStack[] aItemInputs, String aInventory) {
        GT_Recipe.GT_Recipe_Map tRecipeMap = GT_Recipe.GT_Recipe_Map.sMaceratorRecipes;
        GT_Recipe tRecipe = tRecipeMap.findRecipe((IHasWorldObjectAndCoords)this, false, TierEU.IV, null, aItemInputs);
        if (tRecipe == null) {
            return false;
        }
        if (!tRecipe.isRecipeInputEqual(true, false, 1, null, aItemInputs)) {
            return false;
        }
        this.setDuration(tRecipe.mDuration);
        this.setEut(tRecipe.mEUt);
        this.setItemOutputs(aInventory, tRecipe.mOutputs);
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getActivitySoundLoop() {
        return SoundResource.IC2_MACHINES_MACERATOR_OP.resourceLocation;
    }
}

