/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import gregtech.api.enums.HeatingCoilLevel;
import gregtech.nei.INEISpecialInfoFormatter;
import gregtech.nei.NEIRecipeInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class HeatingCoilSpecialValueFormatter
implements INEISpecialInfoFormatter {
    public static final HeatingCoilSpecialValueFormatter INSTANCE = new HeatingCoilSpecialValueFormatter();

    @Override
    public List<String> format(NEIRecipeInfo recipeInfo, Function<Integer, String> applyPrefixAndSuffix) {
        int heat = recipeInfo.recipe.mSpecialValue;
        ArrayList<String> result = new ArrayList<String>();
        result.add(applyPrefixAndSuffix.apply(heat));
        for (HeatingCoilLevel heatLevel : HeatingCoilLevel.values()) {
            if (heatLevel == HeatingCoilLevel.None || heatLevel == HeatingCoilLevel.ULV || heatLevel.getHeat() < (long)heat) continue;
            result.add(" (" + heatLevel.getName() + ")");
            return result;
        }
        result.add(" (" + HeatingCoilLevel.MAX.getName() + "+)");
        return result;
    }
}

