/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.config.Option;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.util.GT_Recipe;
import gregtech.common.items.GT_MetaGenerated_Item_01;
import gregtech.common.items.GT_MetaGenerated_Item_02;
import gregtech.common.items.GT_MetaGenerated_Item_03;
import gregtech.nei.GT_NEI_DefaultHandler;
import gregtech.nei.RecipeMapHandler;
import gregtech.nei.dumper.BatchModeSupportDumper;
import gregtech.nei.dumper.InputSeparationSupportDumper;
import gregtech.nei.dumper.MaterialDumper;
import gregtech.nei.dumper.MetaItemDumper;
import gregtech.nei.dumper.MetaTileEntityDumper;
import gregtech.nei.dumper.RecipeLockingSupportDumper;
import gregtech.nei.dumper.VoidProtectionSupportDumper;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.item.ItemStack;

public class NEI_GT_Config
implements IConfigureNEI {
    private static final ImmutableMap<GT_Recipe.GT_Recipe_Map, Integer> RECIPE_MAP_ORDERING = ImmutableMap.builder().put((Object)GT_Recipe.GT_Recipe_Map.sAssemblylineVisualRecipes, (Object)1).put((Object)GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes, (Object)2).build();
    private static final Comparator<RecipeMapHandler> RECIPE_MAP_HANDLER_COMPARATOR = Comparator.comparingInt(handler -> (Integer)RECIPE_MAP_ORDERING.getOrDefault((Object)handler.getRecipeMap(), (Object)0));
    public static boolean sIsAdded = true;

    private static void addHandler(TemplateRecipeHandler handler) {
        FMLInterModComms.sendRuntimeMessage((Object)GT_Values.GT, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("gregtech@" + handler.getRecipeName() + "@" + handler.getOverlayIdentifier()));
        GuiCraftingRecipe.craftinghandlers.add(handler);
        GuiUsageRecipe.usagehandlers.add(handler);
    }

    public void loadConfig() {
        sIsAdded = false;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ArrayList<RecipeMapHandler> handlers = new ArrayList<RecipeMapHandler>();
            for (GT_Recipe.GT_Recipe_Map tMap : GT_Recipe.GT_Recipe_Map.sMappings) {
                if (!tMap.mNEIAllowed) continue;
                handlers.add(new GT_NEI_DefaultHandler(tMap));
            }
            handlers.sort(RECIPE_MAP_HANDLER_COMPARATOR);
            handlers.forEach(NEI_GT_Config::addHandler);
            API.addItemListEntry((ItemStack)ItemList.VOLUMETRIC_FLASK.get(1L, new Object[0]));
            API.addOption((Option)new MetaTileEntityDumper());
            API.addOption((Option)new MaterialDumper());
            API.addOption((Option)new MetaItemDumper(GT_MetaGenerated_Item_01.INSTANCE, "metaitem01"));
            API.addOption((Option)new MetaItemDumper(GT_MetaGenerated_Item_02.INSTANCE, "metaitem02"));
            API.addOption((Option)new MetaItemDumper(GT_MetaGenerated_Item_03.INSTANCE, "metaitem03"));
            API.addOption((Option)new VoidProtectionSupportDumper());
            API.addOption((Option)new InputSeparationSupportDumper());
            API.addOption((Option)new BatchModeSupportDumper());
            API.addOption((Option)new RecipeLockingSupportDumper());
        }
        sIsAdded = true;
    }

    public String getName() {
        return "GregTech NEI Plugin";
    }

    public String getVersion() {
        return "(5.03a)";
    }
}

