/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.common.loaders;

import com.github.bartimaeusnek.bartworks.common.tileentities.multis.GT_TileEntity_ElectricImplosionCompressor;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ElectricImplosionCompressorRecipes
implements Runnable {
    private static final ItemStack[] circuits = new ItemStack[]{ItemList.Circuit_ExoticProcessor.get(1L, new Object[0]), ItemList.Circuit_OpticalAssembly.get(1L, new Object[0]), ItemList.Circuit_Biowaresupercomputer.get(1L, new Object[0]), ItemList.Circuit_Wetwaremainframe.get(1L, new Object[0])};

    private static void addElectricImplosionRecipe(ItemStack[] inputItems, FluidStack[] inputFluids, ItemStack[] outputItems, FluidStack[] outputFluids, int durationInTicks, int EUPerTick) {
        GT_TileEntity_ElectricImplosionCompressor.eicMap.addRecipe(false, inputItems, outputItems, null, inputFluids, outputFluids, durationInTicks, EUPerTick, 1);
    }

    @Override
    public void run() {
        if (Mods.EternalSingularity.isModLoaded()) {
            ElectricImplosionCompressorRecipes.addElectricImplosionRecipe(new ItemStack[]{GT_Values.NI}, new FluidStack[]{MaterialsUEVplus.SpaceTime.getMolten(72L)}, new ItemStack[]{GT_ModHandler.getModItem((String)Mods.EternalSingularity.ID, (String)"eternal_singularity", (long)1L)}, new FluidStack[]{GT_Values.NF}, 2000, (int)TierEU.RECIPE_UMV);
            if (Mods.UniversalSingularities.isModLoaded()) {
                ElectricImplosionCompressorRecipes.addElectricImplosionRecipe(new ItemStack[]{ItemList.Circuit_Silicon_Wafer7.get(1L, new Object[0]), GT_ModHandler.getModItem((String)Mods.UniversalSingularities.ID, (String)"universal.general.singularity", (long)1L, (int)20)}, new FluidStack[]{GT_Values.NF}, new ItemStack[]{ItemList.Circuit_Chip_Optical.get(16L, new Object[0])}, new FluidStack[]{GT_Values.NF}, 100, (int)TierEU.RECIPE_UMV);
            }
        }
        ElectricImplosionCompressorRecipes.addElectricImplosionRecipe(new ItemStack[]{GT_ModHandler.getModItem((String)Mods.GoodGenerator.ID, (String)"highDensityPlutoniumNugget", (long)5L)}, new FluidStack[]{Materials.Infinity.getMolten(9L)}, new ItemStack[]{GT_ModHandler.getModItem((String)Mods.GoodGenerator.ID, (String)"highDensityPlutonium", (long)1L)}, new FluidStack[]{GT_Values.NF}, 1, (int)TierEU.RECIPE_UEV);
        ElectricImplosionCompressorRecipes.addElectricImplosionRecipe(new ItemStack[]{GT_ModHandler.getModItem((String)Mods.GoodGenerator.ID, (String)"highDensityUraniumNugget", (long)5L)}, new FluidStack[]{Materials.Infinity.getMolten(9L)}, new ItemStack[]{GT_ModHandler.getModItem((String)Mods.GoodGenerator.ID, (String)"highDensityUranium", (long)1L)}, new FluidStack[]{GT_Values.NF}, 1, (int)TierEU.RECIPE_UEV);
        ElectricImplosionCompressorRecipes.addElectricImplosionRecipe(new ItemStack[]{GT_ModHandler.getModItem((String)Mods.GoodGenerator.ID, (String)"highDensityThoriumNugget", (long)5L)}, new FluidStack[]{Materials.Infinity.getMolten(9L)}, new ItemStack[]{GT_ModHandler.getModItem((String)Mods.GoodGenerator.ID, (String)"highDensityThorium", (long)1L)}, new FluidStack[]{GT_Values.NF}, 1, (int)TierEU.RECIPE_UEV);
        ElectricImplosionCompressorRecipes.addElectricImplosionRecipe(new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.nanite, (Object)MaterialsUEVplus.WhiteDwarfMatter, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.nanite, (Object)MaterialsUEVplus.Universium, (long)1L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.nanite, (Object)MaterialsUEVplus.BlackDwarfMatter, (long)1L)}, new FluidStack[]{MaterialsUEVplus.RawStarMatter.getFluid(9216L)}, new ItemStack[]{GT_Values.NI}, new FluidStack[]{MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(2304L)}, 80, (int)TierEU.RECIPE_UXV);
        ElectricImplosionCompressorRecipes.addElectricImplosionRecipe(new ItemStack[]{MaterialsUEVplus.Eternity.getNanite(1), MaterialsUEVplus.Universium.getNanite(1)}, new FluidStack[]{MaterialsUEVplus.RawStarMatter.getFluid(18432L)}, new ItemStack[]{GT_Values.NI}, new FluidStack[]{MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten(4608L)}, 80, (int)TierEU.RECIPE_MAX);
        this.addMagnetohydrodynamicallyConstrainedStarMatterPartRecipes();
    }

    private void addMagnetohydrodynamicallyConstrainedStarMatterPartRecipes() {
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.frameGt, 1, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.nugget, 9, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.ingot, 1, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.plate, 1, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.plateDense, 1, 3);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.stick, 2, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.round, 8, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.bolt, 8, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.screw, 8, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.ring, 4, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.foil, 8, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.itemCasing, 2, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.gearGtSmall, 1, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.rotor, 1, 2);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.stickLong, 1, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.springSmall, 2, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.spring, 1, 1);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.gearGt, 1, 2);
        this.addWhiteDwarfMagnetoEICRecipe(OrePrefixes.wireFine, 8, 1);
    }

    private void addWhiteDwarfMagnetoEICRecipe(OrePrefixes part, int multiplier, int circuitMultiplier) {
        int partFraction = (int)(144L * part.mMaterialAmount / 3628800L);
        for (ItemStack circuit : circuits) {
            ElectricImplosionCompressorRecipes.addElectricImplosionRecipe(new ItemStack[]{circuit.func_77979_a(circuitMultiplier), GT_ModHandler.getModItem((String)Mods.SuperSolarPanels.ID, (String)"solarsplitter", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.OpenComputers.ID, (String)"hologram2", (long)circuitMultiplier, (int)0), GT_OreDictUnificator.get((OrePrefixes)part, (Object)MaterialsUEVplus.Eternity, (long)multiplier)}, new FluidStack[]{MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.getMolten((long)partFraction * (long)multiplier)}, new ItemStack[]{GT_OreDictUnificator.get((OrePrefixes)part, (Object)MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter, (long)multiplier)}, new FluidStack[]{GT_Values.NF}, (int)((double)multiplier * ((double)(20 * partFraction) / 144.0)), (int)TierEU.RECIPE_UXV);
        }
    }
}

