/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.compactkineticgenerators.tileentity;

import com.lulan.compactkineticgenerators.handler.ConfigHandler;
import ic2.api.energy.tile.IKineticSource;
import ic2.core.IC2;
import ic2.core.block.generator.tileentity.TileEntityKineticGenerator;
import ic2.core.init.MainConfig;
import ic2.core.util.Config;
import ic2.core.util.ConfigUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class BasicTileCkg
extends TileEntityKineticGenerator {
    public int type;
    protected double guiproduction = 0.0;
    protected double production = 0.0;
    protected int receivedkinetic = 0;
    protected final int MaxStorage;
    protected final double productionpeerkineticunit;

    public BasicTileCkg() {
        this(0);
    }

    public BasicTileCkg(int type) {
        this.type = type;
        this.productionpeerkineticunit = 0.25 * (double)ConfigUtil.getFloat((Config)MainConfig.get(), (String)"balance/energy/generator/Kinetic");
        this.updateTicker = IC2.random.nextInt(this.getTickRate());
        switch (this.type) {
            case 1: {
                this.MaxStorage = 4000000;
                break;
            }
            case 2: {
                this.MaxStorage = 10000000;
                break;
            }
            case 3: {
                this.MaxStorage = 40000000;
                break;
            }
            default: {
                this.MaxStorage = 1000000;
            }
        }
    }

    protected void updateEntityServer() {
        boolean newActive = this.gainEnergy();
        if (this.updateTicker++ >= this.getTickRate()) {
            this.guiproduction = this.production;
            this.updateTicker = 0;
        }
        if (this.EUstorage > (double)this.MaxStorage) {
            this.EUstorage = this.MaxStorage;
        }
        if (this.getActive() != newActive) {
            this.setActive(newActive);
        }
    }

    protected boolean gainEnergy() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.getFacing());
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        if (te instanceof IKineticSource) {
            int kineticbandwith = ((IKineticSource)te).maxrequestkineticenergyTick(dir.getOpposite());
            double freeEU = (double)this.MaxStorage - this.EUstorage;
            double gainEU = this.productionpeerkineticunit * (double)kineticbandwith;
            this.receivedkinetic = ((IKineticSource)te).requestkineticenergy(dir.getOpposite(), kineticbandwith);
            if (this.receivedkinetic >= 0) {
                this.production = (double)this.receivedkinetic * this.productionpeerkineticunit;
                this.EUstorage += this.production;
                return true;
            }
        }
        this.production = 0.0;
        this.receivedkinetic = 0;
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = nbt.func_74762_e("type");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("type", this.type);
    }

    public int getSourceTier() {
        if (this.type >= 3) {
            return ConfigHandler.customKGTier;
        }
        return 4 + this.type;
    }

    public int gaugeEUStorageScaled(int i) {
        return (int)(this.EUstorage * (double)i / (double)this.MaxStorage);
    }

    public String func_145825_b() {
        return StatCollector.func_74837_a((String)("tile.ckg:BlockCkg" + (8 + this.type) + ".name"), (Object[])new Object[0]);
    }

    public double getproduction() {
        return this.guiproduction;
    }
}

