/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.database.cachebuilder.GregTechOre;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTCompound;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTList;
import com.sinthoras.visualprospecting.shadow.io.xol.enklume.nbt.NBTNamed;
import java.util.HashSet;
import java.util.Set;

public class ChunkAnalysis {
    private final Set<Short> ores = new HashSet<Short>();
    private final Set<VeinType> matchedVeins = new HashSet<VeinType>();
    private int minVeinBlockY = 256;

    public void processMinecraftChunk(NBTCompound chunkRoot) {
        for (NBTNamed tileEntity : ((NBTList)chunkRoot.getTag((String)"Level.TileEntities")).elements) {
            GregTechOre gtOre = new GregTechOre((NBTCompound)tileEntity);
            if (!gtOre.isValidGTOre) continue;
            this.ores.add(gtOre.metaData);
            if (this.minVeinBlockY <= gtOre.blockY) continue;
            this.minVeinBlockY = gtOre.blockY;
        }
    }

    public boolean matchesSingleVein() {
        for (VeinType veinType : VeinTypeCaching.veinTypes) {
            if (!veinType.matches(this.ores)) continue;
            this.matchedVeins.add(veinType);
        }
        return this.matchedVeins.size() <= 1;
    }

    public VeinType getMatchedVein() {
        if (this.matchedVeins.isEmpty()) {
            return VeinType.NO_VEIN;
        }
        return (VeinType)this.matchedVeins.stream().findAny().get();
    }

    public int getVeinBlockY() {
        return this.minVeinBlockY;
    }
}

