/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.gui.controls;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mods.battlegear2.client.gui.controls.IControlListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.item.ItemDye;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiColourPicker
extends GuiButton {
    public static final int RES = 128;
    public static final DynamicTexture sb_buffer;
    public static final DynamicTexture hue_buffer;
    public static final DynamicTexture background_buffer;
    public static final DynamicTexture default_colours;
    public static final int DEFAULT_COLOURS = 1;
    public static final int ALPHA_SELECTION = 2;
    public static final int COLOUR_DISPLAY = 4;
    private int dragState = 0;
    private static final int DRAG_NONE = 0;
    private static final int DRAG_SB = 1;
    private static final int DRAG_HUE = 2;
    private static final int DRAG_ALPHA = 3;
    public List<IControlListener> listeners = new ArrayList<IControlListener>();
    private int selectedRGB;
    private float[] selectedHSB;
    private float selected_alpha;
    private int sb_start_x;
    private int sb_start_y;
    private int hue_start_x;
    private int alpha_start_x;
    private int type;

    public GuiColourPicker(int id, int x, int y, int rgb, int type) {
        super(id, x, y, (type & 2) == 2 ? 80 : 64, 48 + (type & 1) == 1 ? 0 : (16 + (type & 4) == 4 ? 0 : 16), "");
        this.type = type;
        this.sb_start_x = x;
        this.sb_start_y = y;
        if (this.isSwitchOn(1)) {
            this.sb_start_y += 16;
        }
        this.hue_start_x = this.sb_start_x + 52;
        this.alpha_start_x = this.hue_start_x + 16;
        this.selectColour(rgb);
    }

    private void calculateBuffers() {
        int[] pixels = sb_buffer.func_110565_c();
        for (int s = 0; s < 128; ++s) {
            for (int b = 0; b < 128; ++b) {
                pixels[s * 128 + b] = Color.getHSBColor(this.selectedHSB[0], 1.0f - (float)s / 128.0f, (float)b / 128.0f).getRGB() | 0xFF000000;
            }
        }
    }

    public void func_146118_a(int par1, int par2) {
        super.func_146118_a(par1, par2);
        this.dragState = 0;
    }

    public boolean func_146116_c(Minecraft par1Minecraft, int x, int y) {
        if (x >= this.hue_start_x && x < 12 + this.hue_start_x && y >= this.sb_start_y && y < 48 + this.sb_start_y) {
            float hue = (float)(y - this.sb_start_y) / 48.0f;
            hue = Math.max(hue, 0.0f);
            hue = Math.min(hue, 1.0f);
            this.selectColour(hue, this.selectedHSB[1], this.selectedHSB[2], this.selected_alpha);
            this.dragState = 2;
            return true;
        }
        if (x >= this.sb_start_x && x < this.sb_start_x + 48 && y >= this.sb_start_y && y < this.sb_start_y + 48) {
            float sat = 1.0f - (float)(y - this.sb_start_y) / 48.0f;
            sat = Math.max(sat, 0.0f);
            sat = Math.min(sat, 1.0f);
            float bright = (float)(x - this.sb_start_x) / 48.0f;
            bright = Math.max(bright, 0.0f);
            bright = Math.min(bright, 1.0f);
            this.selectColour(this.selectedHSB[0], sat, bright, this.selected_alpha);
            this.dragState = 1;
            return true;
        }
        if (this.isSwitchOn(2) && x >= this.alpha_start_x && x < 12 + this.alpha_start_x && y >= this.sb_start_y && y < 48 + this.sb_start_y) {
            float alpha = 1.0f - (float)(y - this.sb_start_y) / 48.0f;
            alpha = Math.max(alpha, 0.0f);
            alpha = Math.min(alpha, 1.0f);
            this.selectColour(this.selectedHSB[0], this.selectedHSB[1], this.selectedHSB[2], alpha);
            this.dragState = 3;
            return true;
        }
        if (this.isSwitchOn(1) && x >= this.field_146128_h && x < 48 + this.field_146128_h && y >= this.field_146129_i && y < 12 + this.field_146129_i) {
            this.selectColour(ItemDye.field_150922_c[(x - this.field_146128_h) / 6 + (y - this.field_146129_i) / 6 * 8] | 0xFF000000);
            return true;
        }
        return super.func_146116_c(par1Minecraft, x, y);
    }

    public void func_146112_a(Minecraft mc, int mouse_x, int mouse_y) {
        if (this.field_146125_m) {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            sb_buffer.func_110564_a();
            this.drawTexturedModalRect(this.sb_start_x, this.sb_start_y, 48, 48, 0, 0, 1, 1);
            hue_buffer.func_110564_a();
            this.drawTexturedModalRect(this.hue_start_x, this.sb_start_y, 12, 48, 0, 0, 1, 1);
            if (this.isSwitchOn(2)) {
                background_buffer.func_110564_a();
                this.drawTexturedModalRect(this.alpha_start_x, this.sb_start_y, 12, 48, 0, 0, 2, 8);
                this.func_73733_a(this.alpha_start_x, this.sb_start_y, this.alpha_start_x + 12, this.sb_start_y + 48, this.selectedRGB | 0xFF000000, this.selectedRGB & 0xFFFFFF);
            }
            if (this.isSwitchOn(1)) {
                default_colours.func_110564_a();
                this.drawTexturedModalRect(this.field_146128_h, this.field_146129_i, 48, 12, 0, 0, 1, 1);
            }
            if (this.isSwitchOn(4)) {
                background_buffer.func_110564_a();
                this.drawTexturedModalRect(this.sb_start_x, this.sb_start_y + 52, 48, 12, 0, 0, 8, 2);
                GuiColourPicker.func_73734_a((int)this.sb_start_x, (int)(this.sb_start_y + 52), (int)(this.sb_start_x + 48), (int)(this.sb_start_y + 64), (int)this.selectedRGB);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            GL11.glPushMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)775, (int)0);
            GuiColourPicker.drawRect2(this.sb_start_x, this.sb_start_y + (int)((1.0f - this.selectedHSB[1]) * 48.0f), this.sb_start_x + 48, this.sb_start_y + (int)((1.0f - this.selectedHSB[1]) * 48.0f) + 1, -1);
            GuiColourPicker.drawRect2(this.sb_start_x + (int)(this.selectedHSB[2] * 48.0f), this.sb_start_y, this.sb_start_x + (int)(this.selectedHSB[2] * 48.0f) + 1, this.sb_start_y + 48, -1);
            GuiColourPicker.drawRect2(this.hue_start_x, this.sb_start_y + (int)(this.selectedHSB[0] * 48.0f), this.hue_start_x + 12, this.sb_start_y + (int)(this.selectedHSB[0] * 48.0f) + 1, -1);
            if (this.isSwitchOn(2)) {
                GuiColourPicker.drawRect2(this.alpha_start_x, this.sb_start_y + (int)((1.0f - this.selected_alpha) * 48.0f), this.alpha_start_x + 12, this.sb_start_y + (int)((1.0f - this.selected_alpha) * 48.0f) + 1, -1);
            }
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            if (Mouse.isButtonDown((int)0) && this.field_146124_l) {
                switch (this.dragState) {
                    case 2: {
                        float hue = (float)(mouse_y - this.sb_start_y) / 48.0f;
                        hue = Math.max(hue, 0.0f);
                        hue = Math.min(hue, 1.0f);
                        this.selectColour(hue, this.selectedHSB[1], this.selectedHSB[2], this.selected_alpha);
                        break;
                    }
                    case 3: {
                        float alpha = 1.0f - (float)(mouse_y - this.sb_start_y) / 48.0f;
                        alpha = Math.max(alpha, 0.0f);
                        alpha = Math.min(alpha, 1.0f);
                        this.selectColour(this.selectedHSB[0], this.selectedHSB[1], this.selectedHSB[2], alpha);
                        break;
                    }
                    case 1: {
                        float sat = 1.0f - (float)(mouse_y - this.sb_start_y) / 48.0f;
                        sat = Math.max(sat, 0.0f);
                        sat = Math.min(sat, 1.0f);
                        float bright = (float)(mouse_x - this.sb_start_x) / 48.0f;
                        bright = Math.max(bright, 0.0f);
                        bright = Math.min(bright, 1.0f);
                        this.selectColour(this.selectedHSB[0], sat, bright, this.selected_alpha);
                    }
                }
            } else {
                this.dragState = 0;
            }
        }
    }

    public void selectColour(int rgb) {
        this.selectedRGB = rgb;
        this.selectedHSB = Color.RGBtoHSB((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF, new float[3]);
        this.selected_alpha = (float)((rgb & 0xFF000000) >>> 24) / 255.0f;
        if (this.field_146124_l && this.field_146125_m) {
            for (IControlListener l : this.listeners) {
                l.actionPreformed(this);
            }
        }
        this.calculateBuffers();
    }

    public void selectColour(float hue, float sat, float bright, float alpha) {
        this.selectedHSB = new float[]{hue, sat, bright};
        this.selected_alpha = alpha;
        this.selectedRGB = Color.HSBtoRGB(hue, sat, bright) & 0xFFFFFF | (int)(alpha * 255.0f) << 24;
        if (this.field_146124_l && this.field_146125_m) {
            for (IControlListener l : this.listeners) {
                l.actionPreformed(this);
            }
        }
        this.calculateBuffers();
    }

    private boolean isSwitchOn(int switchMask) {
        return (this.type & switchMask) == switchMask;
    }

    public void addListener(IControlListener listener) {
        this.listeners.add(listener);
    }

    public void drawTexturedModalRect(int x, int y, int width, int height, int tex_x, int tex_y, int tex_width, int tex_height) {
        float f = 1.0f;
        float f1 = 1.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)this.field_73735_i, (double)((float)(tex_x + 0) * f), (double)((float)(tex_y + tex_height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)this.field_73735_i, (double)((float)(tex_x + tex_width) * f), (double)((float)(tex_y + tex_height) * f1));
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)this.field_73735_i, (double)((float)(tex_x + tex_width) * f), (double)((float)(tex_y + 0) * f1));
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)this.field_73735_i, (double)((float)(tex_x + 0) * f), (double)((float)(tex_y + 0) * f1));
        tessellator.func_78381_a();
    }

    public static void drawRect2(int x1, int y1, int x2, int y2, int colour) {
        int j1;
        if (x1 < x2) {
            j1 = x1;
            x1 = x2;
            x2 = j1;
        }
        if (y1 < y2) {
            j1 = y1;
            y1 = y2;
            y2 = j1;
        }
        float f = (float)(colour >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colour >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colour >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colour & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glColor4f((float)f1, (float)f2, (float)f3, (float)f);
        tessellator.func_78382_b();
        tessellator.func_78377_a((double)x1, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y2, 0.0);
        tessellator.func_78377_a((double)x2, (double)y1, 0.0);
        tessellator.func_78377_a((double)x1, (double)y1, 0.0);
        tessellator.func_78381_a();
    }

    public int getRGB() {
        return this.selectedRGB;
    }

    static {
        int i;
        sb_buffer = new DynamicTexture(128, 128);
        hue_buffer = new DynamicTexture(1, 128);
        background_buffer = new DynamicTexture(2, 2);
        default_colours = new DynamicTexture(8, 2);
        int[] pixels = hue_buffer.func_110565_c();
        for (i = 0; i < pixels.length; ++i) {
            pixels[i] = Color.getHSBColor((float)i / 128.0f, 1.0f, 1.0f).getRGB() | 0xFF000000;
        }
        pixels = background_buffer.func_110565_c();
        pixels[0] = -10066330;
        pixels[3] = -10066330;
        pixels[1] = -6710887;
        pixels[2] = -6710887;
        pixels = default_colours.func_110565_c();
        for (i = 0; i < pixels.length; ++i) {
            pixels[i] = ItemDye.field_150922_c[i] | 0xFF000000;
        }
    }
}

