/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.modintegration;

import com.google.common.base.Throwables;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.block.BlockColor;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class EE3Integration {
    static final boolean EE3Present;
    public static Method addRecipe;
    public static Method setAsNotLearnable;
    public static Method setAsNotRecoverable;
    public static Method addPreAssignedEnergyValue;
    static List<EE3Recipe> recipes;

    public static void addPreAssignedEnergyValue(Object object, float val) {
        if (!EE3Present) {
            return;
        }
        try {
            addPreAssignedEnergyValue.invoke(null, object, Float.valueOf(val));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void setAsNotLearnable(Object o) {
        if (!EE3Present) {
            return;
        }
        try {
            setAsNotLearnable.invoke(null, o);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void setAsNotRecoverable(Object o) {
        if (!EE3Present) {
            return;
        }
        try {
            setAsNotRecoverable.invoke(null, o);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void addEMCRecipes() {
        if (!EE3Present) {
            return;
        }
        if (ExtraUtils.cursedEarthEnabled) {
            EE3Integration.addRecipe(new ItemStack(ExtraUtils.cursedEarth), Blocks.field_150346_d, Items.field_151078_bh);
        }
        if (ExtraUtils.enderLilyEnabled) {
            EE3Integration.addRecipe(new ItemStack((Block)ExtraUtils.enderLily), new ItemStack(Items.field_151079_bi, 64));
        }
        if (ExtraUtils.divisionSigilEnabled) {
            EE3Integration.addRecipe(new ItemStack(ExtraUtils.divisionSigil, 2), new ItemStack(Items.field_151079_bi, 4), Items.field_151156_bN);
        }
        if (ExtraUtils.wateringCanEnabled) {
            EE3Integration.addRecipe(new ItemStack((Item)ExtraUtils.wateringCan, 1, 0), new ItemStack((Item)ExtraUtils.wateringCan, 1, 1), new FluidStack(FluidRegistry.WATER, 1000));
        }
        if (ExtraUtils.decorative1 != null) {
            EE3Integration.addRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 8), Blocks.field_150342_X, new ItemStack(Items.field_151043_k, 4), new ItemStack(Items.field_151079_bi, 4));
            EE3Integration.addRecipe(new ItemStack((Block)ExtraUtils.decorative1, 1, 2), Blocks.field_150371_ca);
        }
        for (BlockColor colorblock : ExtraUtils.colorblocks) {
            for (int i = 0; i < 16; ++i) {
                EE3Integration.addRecipe(new ItemStack((Block)colorblock, 1, i), colorblock.baseBlock);
            }
        }
        if (ExtraUtils.decorative2 != null) {
            EE3Integration.addRecipe(new ItemStack((Block)ExtraUtils.decorative2, 1, 0), Blocks.field_150359_w);
        }
        if (ExtraUtils.unstableIngot != null) {
            EE3Integration.setAsNotLearnable(new ItemStack(ExtraUtils.unstableIngot, 1, Short.MAX_VALUE));
            EE3Integration.addRecipe(new ItemStack(ExtraUtils.unstableIngot, 1, 0), ExtraUtils.unstableIngot, 9, 2);
        }
        if (ExtraUtils.soul != null) {
            EE3Integration.addPreAssignedEnergyValue(new ItemStack((Item)ExtraUtils.soul), 1515413.0f);
            EE3Integration.setAsNotLearnable(new ItemStack((Item)ExtraUtils.soul, 1, Short.MAX_VALUE));
        }
    }

    public static void addRecipe(ItemStack itemStack, Object ... inputs) {
        if (!EE3Present) {
            return;
        }
        ArrayList<Object> items = new ArrayList<Object>(inputs.length);
        for (Object a : inputs) {
            if (a == null) continue;
            if (!(a instanceof ItemStack)) {
                items.add(a);
                continue;
            }
            ItemStack input = (ItemStack)a;
            if (input.field_77994_a == 0) continue;
            if (input.field_77994_a == 1) {
                items.add(input.func_77946_l());
                continue;
            }
            int k = input.field_77994_a;
            input = input.func_77946_l();
            input.field_77994_a = 1;
            for (int i = 0; i < k; ++i) {
                items.add(input.func_77946_l());
            }
        }
        if (items.isEmpty()) {
            return;
        }
        recipes.add(new EE3Recipe(itemStack, items));
    }

    public static void finalRegister() {
        if (!EE3Present) {
            return;
        }
        try {
            for (EE3Recipe recipe : recipes) {
                addRecipe.invoke(null, recipe.output, recipe.inputs);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        boolean found = false;
        if (Loader.isModLoaded((String)"EE3")) {
            try {
                Class<?> aClass = Class.forName("com.pahimar.ee3.api.exchange.RecipeRegistryProxy");
                addRecipe = aClass.getDeclaredMethod("addRecipe", Object.class, List.class);
                aClass = Class.forName("com.pahimar.ee3.api.knowledge.AbilityRegistryProxy");
                setAsNotLearnable = aClass.getDeclaredMethod("setAsNotLearnable", Object.class);
                setAsNotRecoverable = aClass.getDeclaredMethod("setAsNotRecoverable", Object.class);
                aClass = Class.forName("com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy");
                addPreAssignedEnergyValue = aClass.getDeclaredMethod("addPreAssignedEnergyValue", Object.class, Float.TYPE);
                found = true;
            }
            catch (Exception e) {
                found = false;
            }
        }
        EE3Present = found;
        recipes = new ArrayList<EE3Recipe>();
    }

    public static class EE3Recipe {
        ItemStack output;
        List<?> inputs;

        public EE3Recipe(ItemStack itemStack, List object) {
            this.output = itemStack;
            this.inputs = object;
        }
    }
}

