/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.texture;

import java.awt.color.ColorSpace;

public class CIELabColorSpace
extends ColorSpace {
    private final float INV255 = 0.003921569f;
    private static final long serialVersionUID = 5027741380892134289L;
    private static final ColorSpace CIEXYZ = ColorSpace.getInstance(1001);
    private static final double N = 0.13793103448275862;
    private static final double X0 = 0.95047;
    private static final double XI = 1.0521110608435826;
    private static final double Y0 = 1.0;
    private static final double YI = 1.0;
    private static final double Z0 = 1.08883;
    private static final double ZI = 0.9184170164304805;

    public static CIELabColorSpace getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        double l = CIELabColorSpace.f((double)colorvalue[1] * 1.0);
        double L = 116.0 * l - 16.0;
        double a = 500.0 * (CIELabColorSpace.f((double)colorvalue[0] * 1.0521110608435826) - l);
        double b = 200.0 * (l - CIELabColorSpace.f((double)colorvalue[2] * 0.9184170164304805));
        return new float[]{(float)L, (float)a, (float)b};
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        float[] xyz = CIEXYZ.fromRGB(rgbvalue);
        return this.fromCIEXYZ(xyz);
    }

    public float[] fromRGB(int r, int g, int b) {
        return this.fromRGB(new float[]{(float)r * 0.003921569f, (float)g * 0.003921569f, (float)b * 0.003921569f});
    }

    public float[] fromRGB(int col) {
        return this.fromRGB(new float[]{(float)((col & 0xFF0000) >> 16) * 0.003921569f, (float)((col & 0xFF00) >> 8) * 0.003921569f, (float)(col & 0xFF) * 0.003921569f});
    }

    @Override
    public float getMaxValue(int component) {
        return 128.0f;
    }

    @Override
    public float getMinValue(int component) {
        return component == 0 ? 0.0f : -128.0f;
    }

    @Override
    public String getName(int idx) {
        return String.valueOf("Lab".charAt(idx));
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        double i = ((double)colorvalue[0] + 16.0) * 0.008620689655172414;
        double X = CIELabColorSpace.fInv(i + (double)colorvalue[1] * 0.002) * 0.95047;
        double Y = CIELabColorSpace.fInv(i) * 1.0;
        double Z = CIELabColorSpace.fInv(i - (double)colorvalue[2] * 0.005) * 1.08883;
        return new float[]{(float)X, (float)Y, (float)Z};
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        float[] xyz = this.toCIEXYZ(colorvalue);
        return CIEXYZ.toRGB(xyz);
    }

    CIELabColorSpace() {
        super(1, 3);
    }

    private static double f(double x) {
        if (x > 0.008856451679035631) {
            return Math.cbrt(x);
        }
        return 7.787037037037037 * x + 0.13793103448275862;
    }

    private static double fInv(double x) {
        if (x > 0.20689655172413793) {
            return x * x * x;
        }
        return 0.12841854934601665 * (x - 0.13793103448275862);
    }

    private Object readResolve() {
        return CIELabColorSpace.getInstance();
    }

    private static class Holder {
        static final CIELabColorSpace INSTANCE = new CIELabColorSpace();

        private Holder() {
        }
    }
}

