/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary;

import binnie.core.machines.TileEntityMachine;
import binnie.extrabees.apiary.machine.AlvearyMachine;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IIndividual;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogicAlveary;
import forestry.api.multiblock.MultiblockManager;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;

public class TileExtraBeeAlveary
extends TileEntityMachine
implements IAlvearyComponent.Active,
IAlvearyComponent.BeeModifier,
IAlvearyComponent.BeeListener,
IBeeListener,
IBeeModifier {
    protected IMultiblockLogicAlveary structureLogic = MultiblockManager.logicFactory.createAlvearyLogic();
    protected ChunkCoordinates min;
    protected ChunkCoordinates max;

    public TileExtraBeeAlveary() {
    }

    public TileExtraBeeAlveary(AlvearyMachine.AlvearyPackage alvearyPackage) {
        super(alvearyPackage);
    }

    public ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public GameProfile getOwner() {
        return this.getMachine().getOwner();
    }

    public List<TileEntity> getAlvearyBlocks() {
        LinkedList<TileEntity> tiles = new LinkedList<TileEntity>();
        if (this.min == null || this.max == null) {
            return tiles;
        }
        for (int x = this.min.field_71574_a; x <= this.max.field_71574_a; ++x) {
            for (int z = this.min.field_71573_c; z <= this.max.field_71573_c; ++z) {
                for (int y = this.min.field_71572_b; y <= this.max.field_71572_b; ++y) {
                    TileEntity tile = this.func_145831_w().func_147438_o(x, y, z);
                    if (!(tile instanceof IMultiblockComponent)) continue;
                    tiles.add(tile);
                }
            }
        }
        return tiles;
    }

    public void onMachineAssembled(IMultiblockController arg0, ChunkCoordinates min, ChunkCoordinates max) {
        this.min = min;
        this.max = max;
    }

    public void onMachineBroken() {
        this.min = null;
        this.max = null;
    }

    public IMultiblockLogicAlveary getMultiblockLogic() {
        return this.structureLogic;
    }

    public boolean canUpdate() {
        return false;
    }

    public void updateClient(int arg0) {
        super.func_145845_h();
    }

    public void updateServer(int arg0) {
        super.func_145845_h();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.structureLogic.invalidate(this.field_145850_b, (IMultiblockComponent)this);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        this.structureLogic.onChunkUnload(this.field_145850_b, (IMultiblockComponent)this);
    }

    public void func_145829_t() {
        this.structureLogic.validate(this.field_145850_b, (IMultiblockComponent)this);
    }

    public IBeeModifier getBeeModifier() {
        return this.getMachine().getInterface(IBeeModifier.class);
    }

    public IBeeListener getBeeListener() {
        return this.getMachine().getInterface(IBeeListener.class);
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        if (this.getBeeModifier() == null) {
            return 1.0f;
        }
        return this.getBeeModifier().getTerritoryModifier(genome, currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        if (this.getBeeModifier() == null) {
            return 1.0f;
        }
        return this.getBeeModifier().getMutationModifier(genome, mate, currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        if (this.getBeeModifier() == null) {
            return 1.0f;
        }
        return this.getBeeModifier().getLifespanModifier(genome, mate, currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        if (this.getBeeModifier() == null) {
            return 1.0f;
        }
        return this.getBeeModifier().getProductionModifier(genome, currentModifier);
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        if (this.getBeeModifier() == null) {
            return 1.0f;
        }
        return this.getBeeModifier().getFloweringModifier(genome, currentModifier);
    }

    public boolean isSealed() {
        return this.getBeeModifier() != null && this.getBeeModifier().isSealed();
    }

    public boolean isSelfLighted() {
        return this.getBeeModifier() != null && this.getBeeModifier().isSelfLighted();
    }

    public boolean isSunlightSimulated() {
        return this.getBeeModifier() != null && this.getBeeModifier().isSunlightSimulated();
    }

    public boolean isHellish() {
        return this.getBeeModifier() != null && this.getBeeModifier().isHellish();
    }

    public void wearOutEquipment(int amount) {
        if (this.getBeeListener() != null) {
            this.getBeeListener().wearOutEquipment(amount);
        }
    }

    public void onQueenDeath() {
        if (this.getBeeListener() != null) {
            this.getBeeListener().onQueenDeath();
        }
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    public boolean onPollenRetrieved(IIndividual arg0) {
        return false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        NBTTagCompound tag = new NBTTagCompound();
        this.structureLogic.writeToNBT(tag);
        nbtTagCompound.func_74782_a("structureLogic", (NBTBase)tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        NBTTagCompound tag = nbtTagCompound.func_74775_l("structureLogic");
        if (tag != null) {
            this.structureLogic.readFromNBT(tag);
        }
    }
}

