/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.Mods;
import binnie.extrabees.genetics.ExtraBeeBranchDefinition;
import binnie.extrabees.genetics.ExtraBeeMutation;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.genetics.effect.ExtraBeesEffect;
import binnie.extrabees.genetics.requirements.RequirementPerson;
import binnie.extrabees.products.EnumHoneyComb;
import binnie.extrabees.products.ItemHoneyComb;
import binnie.genetics.genetics.AlleleHelper;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesCustom;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeBranchDefinition;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.BiomeDictionary;

public enum ExtraBeeDefinition implements IBeeDefinition
{
    ARID(ExtraBeeBranchDefinition.BARREN, "aridus", true, new Color(12511316), new Color(13362036)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MEADOWS, BeeDefinition.FRUGAL, 10);
            this.registerMutation(BeeDefinition.FOREST, BeeDefinition.FRUGAL, 10);
        }
    }
    ,
    BARREN(ExtraBeeBranchDefinition.BARREN, "infelix", true, new Color(14733923), new Color(13362036)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.COMMON, ARID, 10);
        }
    }
    ,
    DESOLATE(ExtraBeeBranchDefinition.BARREN, "desolo", false, new Color(13744272), new Color(13362036)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.3f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.HUNGER.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(ARID, BARREN, 10);
        }
    }
    ,
    DECOMPOSING(ExtraBeeBranchDefinition.BARREN, "aegrus", true, new Color(5388049), new Color(0xFFFFFF)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.3f)).addSpecialty(EnumHoneyComb.COMPOST.get(1), Float.valueOf(0.08f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MARSHY, BARREN, 15);
        }
    }
    ,
    GNAWING(ExtraBeeBranchDefinition.BARREN, "apica", true, new Color(15234224), new Color(13362036)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.25f)).addSpecialty(EnumHoneyComb.SAWDUST.get(1), Float.valueOf(0.25f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.WOOD.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FOREST, BARREN, 15);
        }
    }
    ,
    ROTTEN(ExtraBeeBranchDefinition.HOSTILE, "caries", true, new Color(12574902), new Color(13362036)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.3f)).addSpecialty(EnumHoneyComb.ROTTEN.get(1), Float.valueOf(0.1f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.SPAWN_ZOMBIE.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MEADOWS, DESOLATE, 15);
        }
    }
    ,
    BONE(ExtraBeeBranchDefinition.HOSTILE, "os", true, new Color(15330792), new Color(13362036)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.3f)).addSpecialty(EnumHoneyComb.BONE.get(1), Float.valueOf(0.1f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.SPAWN_SKELETON.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FOREST, DESOLATE, 15);
        }
    }
    ,
    CREEPER(ExtraBeeBranchDefinition.HOSTILE, "erepo", true, new Color(2942485), new Color(13362036)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.3f)).addSpecialty(ItemHoneyComb.VanillaComb.POWDERY.get(), Float.valueOf(0.08f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.SPAWN_CREEPER.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MODEST, DESOLATE, 15);
        }
    }
    ,
    ROCK(ExtraBeeBranchDefinition.ROCKY, "saxum", true, new Color(0xA8A8A8), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.3f));
        }
    }
    ,
    STONE(ExtraBeeBranchDefinition.ROCKY, "lapis", false, new Color(0x757575), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.3f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.DILIGENT, ROCK, 12);
        }
    }
    ,
    GRANITE(ExtraBeeBranchDefinition.ROCKY, "granum", true, new Color(0x695555), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.UNWEARY, STONE, 10);
        }
    }
    ,
    MINERAL(ExtraBeeBranchDefinition.ROCKY, "minerale", true, new Color(7239037), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.INDUSTRIOUS, GRANITE, 6);
        }
    }
    ,
    COPPER(ExtraBeeBranchDefinition.METALLIC, "cuprous", true, new Color(13722376), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.COPPER.get(1), Float.valueOf(0.06f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.WINTRY, MINERAL, 5);
            this.registerMutation(BeeDefinition.MODEST, MINERAL, 5);
        }
    }
    ,
    TIN(ExtraBeeBranchDefinition.METALLIC, "stannus", true, new Color(0xBDB1BD), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.TIN.get(1), Float.valueOf(0.06f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MARSHY, MINERAL, 5);
            this.registerMutation(BeeDefinition.TROPICAL, MINERAL, 5);
        }
    }
    ,
    IRON(ExtraBeeBranchDefinition.METALLIC, "ferrous", false, new Color(11038808), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.IRON.get(1), Float.valueOf(0.05f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MEADOWS, MINERAL, 5);
            this.registerMutation(BeeDefinition.FOREST, MINERAL, 5);
        }
    }
    ,
    LEAD(ExtraBeeBranchDefinition.METALLIC, "plumbous", true, new Color(11373483), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.LEAD.get(1), Float.valueOf(0.05f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MEADOWS, MINERAL, 5);
            this.registerMutation(BeeDefinition.MODEST, MINERAL, 5);
        }
    }
    ,
    ZINC(ExtraBeeBranchDefinition.METALLIC2, "spelta", true, new Color(15592447), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.ZINC.get(1), Float.valueOf(0.05f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.WINTRY, MINERAL, 5);
            this.registerMutation(BeeDefinition.TROPICAL, MINERAL, 5);
        }
    }
    ,
    TITANIUM(ExtraBeeBranchDefinition.METALLIC2, "titania", true, new Color(11578083), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.TITANIUM.get(1), Float.valueOf(0.02f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.CULTIVATED, MINERAL, 3);
        }
    }
    ,
    TUNGSTATE(ExtraBeeBranchDefinition.METALLIC2, "wolfram", true, new Color(1249812), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.TUNGSTEN.get(1), Float.valueOf(0.01f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.COMMON, MINERAL, 3);
        }
    }
    ,
    NICKEL(ExtraBeeBranchDefinition.METALLIC2, "claro", true, new Color(16768764), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.NICKEL.get(1), Float.valueOf(0.05f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FOREST, MINERAL, 5);
            this.registerMutation(BeeDefinition.MARSHY, MINERAL, 5);
        }
    }
    ,
    GOLD(ExtraBeeBranchDefinition.PRECIOUS, "aureus", true, new Color(15125515), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.GOLD.get(1), Float.valueOf(0.02f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MAJESTIC, IRON, 2);
            this.registerMutation(BeeDefinition.MAJESTIC, COPPER, 2);
            this.registerMutation(BeeDefinition.MAJESTIC, NICKEL, 2);
            this.registerMutation(BeeDefinition.MAJESTIC, TUNGSTATE, 2);
        }
    }
    ,
    SILVER(ExtraBeeBranchDefinition.PRECIOUS, "argentus", false, new Color(4408667), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.SILVER.get(1), Float.valueOf(0.02f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MAJESTIC, ZINC, 2);
            this.registerMutation(BeeDefinition.MAJESTIC, TIN, 2);
            this.registerMutation(BeeDefinition.MAJESTIC, LEAD, 2);
            this.registerMutation(BeeDefinition.MAJESTIC, TITANIUM, 2);
        }
    }
    ,
    PLATINUM(ExtraBeeBranchDefinition.PRECIOUS, "platina", false, new Color(0xDBDBDB), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.PLATINUM.get(1), Float.valueOf(0.01f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(GOLD, SILVER, 2);
        }
    }
    ,
    LAPIS(ExtraBeeBranchDefinition.MINERAL, "lazuli", true, new Color(4009179), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.LAPIS.get(1), Float.valueOf(0.05f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.IMPERIAL, MINERAL, 5);
        }
    }
    ,
    EMERALD(ExtraBeeBranchDefinition.GEMSTONE, "emerala", true, new Color(1900291), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.EMERALD.get(1), Float.valueOf(0.04f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FOREST, LAPIS, 5);
        }
    }
    ,
    RUBY(ExtraBeeBranchDefinition.GEMSTONE, "ruba", true, new Color(0xD60000), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.RUBY.get(1), Float.valueOf(0.03f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MODEST, LAPIS, 5);
        }
    }
    ,
    SAPPHIRE(ExtraBeeBranchDefinition.GEMSTONE, "saphhira", true, new Color(673791), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.SAPPHIRE.get(1), Float.valueOf(0.03f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(WATER, LAPIS, 5);
        }
    }
    ,
    DIAMOND(ExtraBeeBranchDefinition.GEMSTONE, "diama", true, new Color(8371706), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.STONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.DIAMOND.get(1), Float.valueOf(0.01f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.CULTIVATED, LAPIS, 5);
        }
    }
    ,
    UNSTABLE(ExtraBeeBranchDefinition.NUCLEAR, "levis", false, new Color(4099124), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.2f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(PREHISTORIC, MINERAL, 5);
        }
    }
    ,
    NUCLEAR(ExtraBeeBranchDefinition.NUCLEAR, "nucleus", false, new Color(4312111), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.2f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(UNSTABLE, IRON, 5);
            this.registerMutation(UNSTABLE, COPPER, 5);
            this.registerMutation(UNSTABLE, TIN, 5);
            this.registerMutation(UNSTABLE, ZINC, 5);
            this.registerMutation(UNSTABLE, NICKEL, 5);
            this.registerMutation(UNSTABLE, LEAD, 5);
        }
    }
    ,
    RADIOACTIVE(ExtraBeeBranchDefinition.NUCLEAR, "fervens", false, new Color(2031360), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.URANIUM.get(1), Float.valueOf(0.02f)).setHasEffect();
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(NUCLEAR, GOLD, 5);
            this.registerMutation(NUCLEAR, SILVER, 5);
        }
    }
    ,
    YELLORIUM(ExtraBeeBranchDefinition.NUCLEAR, "yellori", true, new Color(14019840), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.YELLORIUM.get(1), Float.valueOf(0.02f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.RADIOACTIVE.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FRUGAL, NUCLEAR, 5);
        }
    }
    ,
    CYANITE(ExtraBeeBranchDefinition.NUCLEAR, "cyanita", true, new Color(34541), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.CYANITE.get(1), Float.valueOf(0.01f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.RADIOACTIVE.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(NUCLEAR, YELLORIUM, 5);
        }
    }
    ,
    BLUTONIUM(ExtraBeeBranchDefinition.NUCLEAR, "caruthus", true, new Color(1769702), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.BARREN.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.BLUTONIUM.get(1), Float.valueOf(0.01f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.RADIOACTIVE.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(CYANITE, YELLORIUM, 5);
        }
    }
    ,
    ANCIENT(ExtraBeeBranchDefinition.HISTORIC, "antiquus", true, new Color(15915919), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.OLD.get(1), Float.valueOf(0.3f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.NOBLE, BeeDefinition.DILIGENT, 10);
        }
    }
    ,
    PRIMEVAL(ExtraBeeBranchDefinition.HISTORIC, "priscus", true, new Color(11773563), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.OLD.get(1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.SECLUDED, ANCIENT, 8);
        }
    }
    ,
    PREHISTORIC(ExtraBeeBranchDefinition.HISTORIC, "pristinus", false, new Color(7232064), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.OLD.get(1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(PRIMEVAL, ANCIENT, 8);
        }
    }
    ,
    RELIC(ExtraBeeBranchDefinition.HISTORIC, "sapiens", true, new Color(5062166), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.OLD.get(1), Float.valueOf(0.3f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.IMPERIAL, PREHISTORIC, 8);
        }
    }
    ,
    COAL(ExtraBeeBranchDefinition.FOSSILIZED, "carbo", true, new Color(8025672), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.OLD.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.COAL.get(1), Float.valueOf(0.08f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(PRIMEVAL, GROWING, 8);
            this.registerMutation(BeeDefinition.RURAL, PRIMEVAL, 8);
        }
    }
    ,
    RESIN(ExtraBeeBranchDefinition.FOSSILIZED, "lacrima", false, new Color(10908443), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.OLD.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.RESIN.get(1), Float.valueOf(0.05f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MIRY, PRIMEVAL, 8);
        }
    }
    ,
    OIL(ExtraBeeBranchDefinition.FOSSILIZED, "lubricus", true, new Color(5719920), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.OLD.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.OIL.get(1), Float.valueOf(0.05f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(OCEAN, PRIMEVAL, 8);
            this.registerMutation(BeeDefinition.FRUGAL, PRIMEVAL, 8);
        }
    }
    ,
    DISTILLED(ExtraBeeBranchDefinition.REFINED, "distilli", false, new Color(0x356356), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.OLD.get(1), Float.valueOf(0.1f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.INDUSTRIOUS, OIL, 8);
        }
    }
    ,
    FUEL(ExtraBeeBranchDefinition.REFINED, "refina", true, new Color(16760835), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.OIL.get(1), Float.valueOf(0.1f)).addSpecialty(EnumHoneyComb.FUEL.get(1), Float.valueOf(0.04f)).setHasEffect();
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DISTILLED, OIL, 8);
        }
    }
    ,
    CREOSOTE(ExtraBeeBranchDefinition.REFINED, "creosota", true, new Color(9936403), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.COAL.get(1), Float.valueOf(0.1f)).addSpecialty(EnumHoneyComb.CREOSOTE.get(1), Float.valueOf(0.07f)).setHasEffect();
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DISTILLED, COAL, 8);
        }
    }
    ,
    LATEX(ExtraBeeBranchDefinition.REFINED, "latex", true, new Color(4803134), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.RESIN.get(1), Float.valueOf(0.1f)).addSpecialty(EnumHoneyComb.LATEX.get(1), Float.valueOf(0.05f)).setHasEffect();
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DISTILLED, RESIN, 8);
        }
    }
    ,
    WATER(ExtraBeeBranchDefinition.AQUATIC, "aqua", true, new Color(9741055), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.WATER.get(1), Float.valueOf(0.3f)).setHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    RIVER(ExtraBeeBranchDefinition.AQUATIC, "flumen", true, new Color(8631252), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.WATER.get(1), Float.valueOf(0.3f)).addSpecialty(EnumHoneyComb.CLAY.get(1), Float.valueOf(0.2f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.DILIGENT, WATER, 10).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.RIVER});
        }
    }
    ,
    OCEAN(ExtraBeeBranchDefinition.AQUATIC, "mare", false, new Color(1912493), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.WATER.get(1), Float.valueOf(0.3f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.DILIGENT, WATER, 10).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN});
        }
    }
    ,
    INK(ExtraBeeBranchDefinition.AQUATIC, "atramentum", true, new Color(922695), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.WATER.get(1), Float.valueOf(0.3f)).addSpecialty(new ItemStack(Items.field_151100_aR, 1, 0), Float.valueOf(0.1f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BLACK, OCEAN, 8);
        }
    }
    ,
    GROWING((IBranchDefinition)BeeBranchDefinition.AGRARIAN, "tyrelli", true, new Color(6024152), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.35f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.LEAVES.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FOREST, BeeDefinition.DILIGENT, 10);
        }
    }
    ,
    FARM((IBranchDefinition)BeeBranchDefinition.AGRARIAN, "ager", true, new Color(7723872), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.WHEATEN.get(), Float.valueOf(0.3f)).addSpecialty(EnumHoneyComb.SEED.get(1), Float.valueOf(0.1f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FARMERLY, BeeDefinition.MEADOWS, 10);
        }
    }
    ,
    THRIVING((IBranchDefinition)BeeBranchDefinition.AGRARIAN, "thriva", true, new Color(3466109), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.35f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.LEAVES.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.UNWEARY, GROWING, 10);
        }
    }
    ,
    BLOOMING((IBranchDefinition)BeeBranchDefinition.AGRARIAN, "blooma", true, new Color(704308), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.35f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.HIGH);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.SAPLING.getUID()));
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.BONEMEAL_SAPLING.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.INDUSTRIOUS, THRIVING, 8);
        }
    }
    ,
    SWEET(ExtraBeeBranchDefinition.SACCHARINE, "mellitus", true, new Color(16536049), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.4f)).addProduct(new ItemStack(Items.field_151102_aT, 1, 0), Float.valueOf(0.1f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.VALIANT, BeeDefinition.DILIGENT, 15);
        }
    }
    ,
    SUGAR(ExtraBeeBranchDefinition.SACCHARINE, "dulcis", true, new Color(15127520), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.4f)).addProduct(new ItemStack(Items.field_151102_aT, 1, 0), Float.valueOf(0.2f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.RURAL, SWEET, 15);
        }
    }
    ,
    RIPENING(ExtraBeeBranchDefinition.SACCHARINE, "ripa", true, new Color(11716445), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151102_aT, 1, 0), Float.valueOf(0.1f)).addSpecialty(EnumHoneyComb.FRUIT.get(1), Float.valueOf(0.1f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, AlleleHelper.getAllele(ExtraBeesFlowers.FRUIT.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SWEET, GROWING, 5);
        }
    }
    ,
    FRUIT(ExtraBeeBranchDefinition.SACCHARINE, "pomum", true, new Color(14375030), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f)).addProduct(new ItemStack(Items.field_151102_aT, 1, 0), Float.valueOf(0.15f)).addSpecialty(EnumHoneyComb.FRUIT.get(1), Float.valueOf(0.2f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.BONEMEAL_FRUIT.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SWEET, THRIVING, 5);
        }
    }
    ,
    ALCOHOL(ExtraBeeBranchDefinition.FARMING, "vinum", false, new Color(15239777), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.WHEATEN.get(), Float.valueOf(0.3f)).addSpecialty(EnumHoneyComb.ALCOHOL.get(1), Float.valueOf(0.1f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele("forestry.effectDrunkard"));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FARMERLY, BeeDefinition.MEADOWS, 10);
        }
    }
    ,
    MILK(ExtraBeeBranchDefinition.FARMING, "lacteus", true, new Color(0xE3E8E8), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.WHEATEN.get(), Float.valueOf(0.3f)).addSpecialty(EnumHoneyComb.MILK.get(1), Float.valueOf(0.1f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FARMERLY, WATER, 10);
        }
    }
    ,
    COFFEE(ExtraBeeBranchDefinition.FARMING, "arabica", true, new Color(9199152), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.WHEATEN.get(), Float.valueOf(0.3f)).addSpecialty(EnumHoneyComb.COFFEE.get(1), Float.valueOf(0.08f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FARMERLY, BeeDefinition.TROPICAL, 10);
        }
    }
    ,
    SWAMP((IBranchDefinition)BeeBranchDefinition.BOGGY, "paludis", true, new Color(3500339), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.MOSSY.get(), Float.valueOf(0.3f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.SLOW.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MIRY, WATER, 10);
        }
    }
    ,
    BOGGY((IBranchDefinition)BeeBranchDefinition.BOGGY, "lama", false, new Color(7887913), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.MOSSY.get(), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.SLOW.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.BOGGY, SWAMP, 8);
        }
    }
    ,
    FUNGAL((IBranchDefinition)BeeBranchDefinition.BOGGY, "boletus", true, new Color(13722112), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.MOSSY.get(), Float.valueOf(0.3f)).addSpecialty(EnumHoneyComb.FUNGAL.get(1), Float.valueOf(0.15f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.BONEMEAL_MUSHROOM.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.BOGGY, BeeDefinition.MIRY, 8);
            this.registerMutation(BeeDefinition.BOGGY, FUNGAL, 8);
        }
    }
    ,
    BASALT(ExtraBeeBranchDefinition.VOLCANIC, "aceri", true, new Color(9202025), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SIMMERING.get(), Float.valueOf(0.25f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectAggressive);
        }
    }
    ,
    TEMPERED(ExtraBeeBranchDefinition.VOLCANIC, "iratus", false, new Color(0x8A4848), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SIMMERING.get(), Float.valueOf(0.25f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FIENDISH, BASALT, 30).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    VOLCANIC(ExtraBeeBranchDefinition.VOLCANIC, "volcano", true, new Color(5049356), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SIMMERING.get(), Float.valueOf(0.25f)).addSpecialty(EnumHoneyComb.BLAZE.get(1), Float.valueOf(0.1f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID).setHasEffect();
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.DEMONIC, TEMPERED, 20).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        }
    }
    ,
    GLOWSTONE(ExtraBeeBranchDefinition.VOLCANIC, "glowia", true, new Color(14730779), new Color(10101539)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.GLOWSTONE.get(1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectAggressive);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(TEMPERED, EXCITED, 5);
        }
    }
    ,
    MALICIOUS(ExtraBeeBranchDefinition.VIRULENT, "acerbus", true, new Color(7875191), new Color(431972)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f)).setHumidity(EnumHumidity.DAMP).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.SINISTER, BeeDefinition.TROPICAL, 10);
        }
    }
    ,
    INFECTIOUS(ExtraBeeBranchDefinition.VIRULENT, "contagio", true, new Color(12070581), new Color(431972)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.TROPICAL, MALICIOUS, 8);
        }
    }
    ,
    VIRULENT(ExtraBeeBranchDefinition.VIRULENT, "morbus", false, new Color(15733740), new Color(431972)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f)).addSpecialty(EnumHoneyComb.VENOMOUS.get(1), Float.valueOf(0.12f)).setHumidity(EnumHumidity.DAMP).setTemperature(EnumTemperature.WARM).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MALICIOUS, INFECTIOUS, 8);
        }
    }
    ,
    VISCOUS(ExtraBeeBranchDefinition.VISCOUS, "liquidus", true, new Color(608014), new Color(431972)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f)).setHumidity(EnumHumidity.DAMP).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.EXOTIC, WATER, 10);
        }
    }
    ,
    GLUTINOUS(ExtraBeeBranchDefinition.VISCOUS, "glutina", true, new Color(1936423), new Color(431972)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f)).setHumidity(EnumHumidity.DAMP).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.EXOTIC, VISCOUS, 8);
        }
    }
    ,
    STICKY(ExtraBeeBranchDefinition.VISCOUS, "lentesco", true, new Color(1565480), new Color(431972)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f)).addSpecialty(EnumHoneyComb.SLIME.get(1), Float.valueOf(0.12f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(VISCOUS, GLUTINOUS, 8);
        }
    }
    ,
    CORROSIVE(ExtraBeeBranchDefinition.CAUSTIC, "corrumpo", false, new Color(4873227), new Color(431972)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.2f)).setHumidity(EnumHumidity.DAMP).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(MALICIOUS, VISCOUS, 10);
        }
    }
    ,
    CAUSTIC(ExtraBeeBranchDefinition.CAUSTIC, "torrens", true, new Color(8691997), new Color(431972)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.25f)).addSpecialty(EnumHoneyComb.ACIDIC.get(1), Float.valueOf(0.03f)).setHumidity(EnumHumidity.DAMP).setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FIENDISH, CORROSIVE, 8);
        }
    }
    ,
    ACIDIC(ExtraBeeBranchDefinition.CAUSTIC, "acidus", true, new Color(12644374), new Color(431972)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.SILKY.get(), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.ACIDIC.get(1), Float.valueOf(0.16f)).setHumidity(EnumHumidity.DAMP).setTemperature(EnumTemperature.WARM).setHasEffect();
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(CORROSIVE, CAUSTIC, 4);
        }
    }
    ,
    EXCITED(ExtraBeeBranchDefinition.ENERGETIC, "excita", true, new Color(0xFF4545), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.REDSTONE.get(1), Float.valueOf(0.1f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.VALIANT, BeeDefinition.CULTIVATED, 10);
        }
    }
    ,
    ENERGETIC(ExtraBeeBranchDefinition.ENERGETIC, "energia", false, new Color(15218119), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.REDSTONE.get(1), Float.valueOf(0.12f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.DILIGENT, EXCITED, 8);
        }
    }
    ,
    ECSTATIC(ExtraBeeBranchDefinition.ENERGETIC, "ecstatica", true, new Color(11482600), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.REDSTONE.get(1), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.IC2ENERGY.get(1), Float.valueOf(0.08f)).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.POWER.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(EXCITED, ENERGETIC, 8);
        }
    }
    ,
    ARTIC((IBranchDefinition)BeeBranchDefinition.FROZEN, "artica", true, new Color(11395296), new Color(14349811)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.FROZEN.get(), Float.valueOf(0.25f)).setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.MAXIMUM);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.WINTRY, BeeDefinition.DILIGENT, 10);
        }
    }
    ,
    FREEZING((IBranchDefinition)BeeBranchDefinition.FROZEN, "glacia", true, new Color(8119267), new Color(14349811)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.FROZEN.get(), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.GLACIAL.get(1), Float.valueOf(0.1f)).setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.MAXIMUM);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(OCEAN, ARTIC, 10);
        }
    }
    ,
    SHADOW(ExtraBeeBranchDefinition.SHADOW, "shadowa", false, new Color(0x595959), new Color(0x333333)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.SHADOW.get(1), Float.valueOf(0.05f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.SINISTER, ROCK, 10);
        }
    }
    ,
    DARKENED(ExtraBeeBranchDefinition.SHADOW, "darka", true, new Color(0x332E33), new Color(0x333333)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.SHADOW.get(1), Float.valueOf(0.1f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SHADOW, ROCK, 8);
        }
    }
    ,
    ABYSS(ExtraBeeBranchDefinition.SHADOW, "abyssba", true, new Color(2164769), new Color(0x333333)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.SHADOW.get(1), Float.valueOf(0.25f)).setTemperature(EnumTemperature.HELLISH).setHumidity(EnumHumidity.ARID).setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.WITHER.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SHADOW, DARKENED, 8);
        }
    }
    ,
    RED(ExtraBeeBranchDefinition.PRIMARY, "rubra", true, new Color(0xFF0000), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.RED.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.FOREST, BeeDefinition.VALIANT, 5);
        }
    }
    ,
    YELLOW(ExtraBeeBranchDefinition.PRIMARY, "fulvus", true, new Color(0xFFDD00), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.YELLOW.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MEADOWS, BeeDefinition.VALIANT, 5);
        }
    }
    ,
    BLUE(ExtraBeeBranchDefinition.PRIMARY, "caeruleus", true, new Color(8959), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.BLUE.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.VALIANT, WATER, 5);
        }
    }
    ,
    GREEN(ExtraBeeBranchDefinition.PRIMARY, "prasinus", true, new Color(39168), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.GREEN.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.TROPICAL, BeeDefinition.VALIANT, 5);
        }
    }
    ,
    BLACK(ExtraBeeBranchDefinition.PRIMARY, "niger", true, new Color(0x575757), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.BLACK.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.VALIANT, ROCK, 5);
        }
    }
    ,
    WHITE(ExtraBeeBranchDefinition.PRIMARY, "albus", true, new Color(0xFFFFFF), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.WHITE.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.WINTRY, BeeDefinition.VALIANT, 5);
        }
    }
    ,
    BROWN(ExtraBeeBranchDefinition.PRIMARY, "fuscus", true, new Color(6042895), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.BROWN.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MARSHY, BeeDefinition.VALIANT, 5);
        }
    }
    ,
    ORANGE(ExtraBeeBranchDefinition.SECONDARY, "flammeus", true, new Color(16751872), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.ORANGE.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(RED, YELLOW, 5);
        }
    }
    ,
    CYAN(ExtraBeeBranchDefinition.SECONDARY, "cyana", true, new Color(65509), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.CYAN.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(GREEN, BLUE, 5);
        }
    }
    ,
    PURPLE(ExtraBeeBranchDefinition.SECONDARY, "purpureus", true, new Color(11403519), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.PURPLE.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(RED, BLUE, 5);
        }
    }
    ,
    GRAY(ExtraBeeBranchDefinition.SECONDARY, "ravus", true, new Color(0xBABABA), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.GRAY.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BLACK, WHITE, 5);
        }
    }
    ,
    LIGHTBLUE(ExtraBeeBranchDefinition.SECONDARY, "aqua", true, new Color(40447), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.LIGHTBLUE.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BLUE, WHITE, 5);
        }
    }
    ,
    PINK(ExtraBeeBranchDefinition.SECONDARY, "rosaceus", true, new Color(16744671), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.PINK.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(RED, WHITE, 5);
        }
    }
    ,
    LIMEGREEN(ExtraBeeBranchDefinition.SECONDARY, "lima", true, new Color(65288), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.LIMEGREEN.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(GREEN, WHITE, 5);
        }
    }
    ,
    MAGENTA(ExtraBeeBranchDefinition.TERTIARY, "fuchsia", true, new Color(0xFF00CC), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.MAGENTA.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(PURPLE, PINK, 5);
        }
    }
    ,
    LIGHTGRAY(ExtraBeeBranchDefinition.TERTIARY, "canus", true, new Color(0xC9C9C9), new Color(9240320)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.75f)).addSpecialty(EnumHoneyComb.LIGHTGRAY.get(1), Float.valueOf(0.25f));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(GRAY, WHITE, 5);
        }
    }
    ,
    CELEBRATORY((IBranchDefinition)BeeBranchDefinition.FESTIVE, "celeba", true, new Color(16386666), new Color(0xD40000)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.FIREWORKS.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.AUSTERE, EXCITED, 5);
        }
    }
    ,
    JADED(ExtraBeeBranchDefinition.FTB, "jadeca", true, new Color(16386666), new Color(14453483)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.HONEY.get(), Float.valueOf(0.3f)).addSpecialty(Mods.forestry.stack("pollen"), Float.valueOf(0.2f)).addSpecialty(EnumHoneyComb.PURPLE.get(1), Float.valueOf(0.15f)).setIsNotCounted().setHasEffect();
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.ENDED, RELIC, 2).restrictPerson("jadedcat");
        }
    }
    ,
    CHAD(ExtraBeeBranchDefinition.FTB, "merciboocoup", true, new Color(2185179), new Color(13806545)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(new ItemStack(Items.field_151105_aU, 1), Float.valueOf(1.0f)).addSpecialty(Mods.forestry.stack("pollenFertile"), Float.valueOf(0.5f)).addSpecialty(EnumHoneyComb.MILK.get(1), Float.valueOf(0.55f)).setIsNotCounted().setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_5);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_5);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, AlleleHelper.getAllele(ExtraBeesEffect.BIRTHDAY.getUID()));
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.CULTIVATED, CELEBRATORY, 5).restrictPerson(new RequirementPerson(new String[0]).add(name -> "" + EnumChatFormatting.DARK_RED + EnumChatFormatting.BOLD + "R" + EnumChatFormatting.RED + EnumChatFormatting.BOLD + "u" + EnumChatFormatting.GOLD + EnumChatFormatting.BOLD + "n" + EnumChatFormatting.YELLOW + EnumChatFormatting.BOLD + "a" + EnumChatFormatting.DARK_GREEN + EnumChatFormatting.BOLD + "k" + EnumChatFormatting.GREEN + EnumChatFormatting.BOLD + "a" + EnumChatFormatting.AQUA + EnumChatFormatting.BOLD + "i", "Runakai").add("boubou_19", "Alastors_Game", "BlueWeabo", "Lewis_Saber", "True_Aurastorm", "mitchej123", "minecraft7771", "_Timbo", "kuba6000", "Alrightsc", "YeetYeetDatBoi", "DreamMasterXXL", "Colen", "OrderedSet"));
        }
    }
    ,
    HAZARDOUS((IBranchDefinition)BeeBranchDefinition.AUSTERE, "infensus", true, new Color(11562024), new Color(16768022)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(EnumHoneyComb.SALTPETER.get(1), Float.valueOf(0.12f)).setTemperature(EnumTemperature.HOT).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectCreeper);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.AUSTERE, DESOLATE, 5);
        }
    }
    ,
    QUANTUM(ExtraBeeBranchDefinition.QUANTUM, "quanta", true, new Color(3655131), new Color(13963227)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.QUARTZ.get(), Float.valueOf(0.25f)).addSpecialty(EnumHoneyComb.CERTUS.get(1), Float.valueOf(0.15f)).addSpecialty(EnumHoneyComb.ENDERPEARL.get(1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, false);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectNone);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.SPECTRAL, SPATIAL, 5);
        }
    }
    ,
    UNUSUAL(ExtraBeeBranchDefinition.QUANTUM, "daniella", true, new Color(5874874), new Color(12231403)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.QUARTZ.get(), Float.valueOf(0.25f)).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.SECLUDED, BeeDefinition.ENDED, 5);
        }
    }
    ,
    SPATIAL(ExtraBeeBranchDefinition.QUANTUM, "spatia", true, new Color(4987872), new Color(10768076)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(ItemHoneyComb.VanillaComb.QUARTZ.get(), Float.valueOf(0.25f)).addSpecialty(EnumHoneyComb.CERTUS.get(1), Float.valueOf(0.05f)).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.HERMITIC, UNUSUAL, 5);
        }
    }
    ,
    MYSTICAL(ExtraBeeBranchDefinition.BOTANIA, "mystica", true, new Color(4630306), new Color(0xFFFFFF)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            Map products = BeeDefinition.NOBLE.getGenome().getPrimary().getProductChances();
            for (Map.Entry entry : products.entrySet()) {
                beeSpecies.addProduct((ItemStack)entry.getKey(), (Float)entry.getValue());
            }
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.NOBLE, BeeDefinition.MONASTIC, 5);
        }
    };

    private static final EnumSet<ExtraBeeDefinition> overworldHiveBees;
    private final IBranchDefinition branch;
    private final IAlleleBeeSpeciesCustom species;
    private IAllele[] template;
    private IBeeGenome genome;

    private ExtraBeeDefinition(IBranchDefinition branch, String binomial, boolean dominant, Color primary, Color secondary) {
        String species = this.toString().toLowerCase(Locale.ENGLISH);
        String uid = "extrabees.species." + species;
        String description = "extrabees.species." + species + ".desc";
        String name = "extrabees.species." + species + ".name";
        this.branch = branch;
        this.species = branch != null ? BeeManager.beeFactory.createSpecies(uid, dominant, "Binnie", name, description, branch.getBranch(), binomial, primary.getRGB(), secondary.getRGB()) : null;
    }

    protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
    }

    protected void setAlleles(IAllele[] template) {
    }

    protected void registerMutations() {
    }

    protected boolean isNeedRegister() {
        return this.branch != null;
    }

    public static void initBees() {
        for (ExtraBeeDefinition bee : ExtraBeeDefinition.values()) {
            if (!bee.isNeedRegister()) continue;
            bee.init();
            bee.registerMutations();
        }
        ExtraBeeDefinition.registerMutation(BeeDefinition.FOREST, WATER, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.MEADOWS, WATER, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.MODEST, WATER, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.TROPICAL, WATER, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.MARSHY, WATER, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.WINTRY, WATER, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(ROCK, WATER, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BASALT, WATER, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.FOREST, ROCK, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.MEADOWS, ROCK, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.MODEST, ROCK, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.TROPICAL, ROCK, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.MARSHY, ROCK, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.WINTRY, ROCK, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BASALT, ROCK, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.FOREST, BASALT, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.MEADOWS, BASALT, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.MODEST, BASALT, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.TROPICAL, BASALT, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.MARSHY, BASALT, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.WINTRY, BASALT, BeeDefinition.COMMON, 15);
        ExtraBeeDefinition.registerMutation(BeeDefinition.COMMON, WATER, BeeDefinition.CULTIVATED, 12);
        ExtraBeeDefinition.registerMutation(BeeDefinition.COMMON, ROCK, BeeDefinition.CULTIVATED, 12);
        ExtraBeeDefinition.registerMutation(BeeDefinition.COMMON, BASALT, BeeDefinition.CULTIVATED, 12);
        ExtraBeeDefinition.registerMutation(BeeDefinition.CULTIVATED, BASALT, BeeDefinition.SINISTER, 60).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
        ExtraBeeDefinition.registerMutation(BeeDefinition.SINISTER, BASALT, BeeDefinition.FIENDISH, 40).restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER});
    }

    private void init() {
        if (!overworldHiveBees.contains((Object)this)) {
            this.species.setIsSecret();
        }
        this.setSpeciesProperties(this.species);
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    protected final ExtraBeeMutation registerMutation(ExtraBeeDefinition parent1, ExtraBeeDefinition parent2, int chance) {
        return this.registerMutation((IAlleleBeeSpecies)parent1.species, (IAlleleBeeSpecies)parent2.species, chance);
    }

    protected final ExtraBeeMutation registerMutation(BeeDefinition parent1, ExtraBeeDefinition parent2, int chance) {
        return this.registerMutation(parent1.getGenome().getPrimary(), (IAlleleBeeSpecies)parent2.species, chance);
    }

    protected final ExtraBeeMutation registerMutation(BeeDefinition parent1, BeeDefinition parent2, int chance) {
        return this.registerMutation(parent1.getGenome().getPrimary(), parent2.getGenome().getPrimary(), chance);
    }

    protected final ExtraBeeMutation registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance) {
        ExtraBeeMutation mutation = new ExtraBeeMutation(parent1, parent2, this.getTemplate(), chance);
        BeeManager.beeRoot.registerMutation((IMutation)mutation);
        return mutation;
    }

    private static ExtraBeeMutation registerMutation(ExtraBeeDefinition parent1, ExtraBeeDefinition parent2, BeeDefinition result, int chance) {
        ExtraBeeMutation mutation = new ExtraBeeMutation((IAlleleBeeSpecies)parent1.species, (IAlleleBeeSpecies)parent2.species, result.getTemplate(), chance);
        BeeManager.beeRoot.registerMutation((IMutation)mutation);
        return mutation;
    }

    private static ExtraBeeMutation registerMutation(BeeDefinition parent1, ExtraBeeDefinition parent2, BeeDefinition result, int chance) {
        ExtraBeeMutation mutation = new ExtraBeeMutation(parent1.getGenome().getPrimary(), (IAlleleBeeSpecies)parent2.species, result.getTemplate(), chance);
        BeeManager.beeRoot.registerMutation((IMutation)mutation);
        return mutation;
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, beeType.ordinal());
    }

    static {
        overworldHiveBees = EnumSet.of(ROCK, WATER, BASALT);
    }
}

