/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.LMMod;
import ftb.lib.api.block.IBlockLM;
import ftb.lib.api.block.ItemBlockLM;
import ftb.lib.api.tile.TileLM;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockLM
extends Block
implements IBlockLM {
    public final String blockName;

    public BlockLM(String s, Material m) {
        super(m);
        this.blockName = s;
        this.func_149663_c(this.getMod().getBlockName(s));
        this.func_149711_c(1.8f);
        this.func_149752_b(3.0f);
        this.field_149758_A = false;
    }

    @Override
    public Class<? extends ItemBlock> getItemBlock() {
        return ItemBlockLM.class;
    }

    public abstract LMMod getMod();

    @SideOnly(value=Side.CLIENT)
    public abstract CreativeTabs func_149708_J();

    @Override
    public final String getItemID() {
        return this.blockName;
    }

    public String func_149739_a() {
        return this.getMod().getBlockName(this.blockName);
    }

    @Override
    public void onPostLoaded() {
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean hasTileEntity(int meta) {
        return this.field_149758_A;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs c, List l) {
        l.add(new ItemStack(item, 1, 0));
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase el, ItemStack is) {
        TileLM tile;
        super.func_149689_a(w, x, y, z, el, is);
        if (this.hasTileEntity(w.func_72805_g(x, y, z)) && el instanceof EntityPlayer && (tile = BlockLM.getTile((IBlockAccess)w, x, y, z)) != null) {
            tile.onPlacedBy((EntityPlayer)el, is);
        }
    }

    public float func_149737_a(EntityPlayer ep, World w, int x, int y, int z) {
        TileLM tile;
        if (this.hasTileEntity(w.func_72805_g(x, y, z)) && (tile = BlockLM.getTile((IBlockAccess)w, x, y, z)) != null && !tile.isMinable(ep)) {
            return -1.0f;
        }
        return super.func_149737_a(ep, w, x, y, z);
    }

    public float func_149712_f(World w, int x, int y, int z) {
        TileLM tile;
        if (this.hasTileEntity(w.func_72805_g(x, y, z)) && (tile = BlockLM.getTile((IBlockAccess)w, x, y, z)) != null && !tile.isMinable(null)) {
            return -1.0f;
        }
        return super.func_149712_f(w, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World w, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileLM tile;
        if (this.hasTileEntity(w.func_72805_g(x, y, z)) && (tile = BlockLM.getTile((IBlockAccess)w, x, y, z)) != null && tile.isExplosionResistant()) {
            return 1000000.0f;
        }
        return super.getExplosionResistance(entity, w, x, y, z, explosionX, explosionY, explosionZ);
    }

    public int func_149656_h() {
        return this.field_149758_A ? 2 : 0;
    }

    public void func_149749_a(World w, int x, int y, int z, Block block, int meta) {
        TileLM tile;
        if (!w.field_72995_K && this.hasTileEntity(w.func_72805_g(x, y, z)) && (tile = BlockLM.getTile((IBlockAccess)w, x, y, z)) != null) {
            tile.onBroken();
        }
        super.func_149749_a(w, x, y, z, block, meta);
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer ep, int s, float x1, float y1, float z1) {
        if (!this.hasTileEntity(w.func_72805_g(x, y, z))) {
            return false;
        }
        TileLM tile = BlockLM.getTile((IBlockAccess)w, x, y, z);
        return tile != null ? tile.onRightClick(ep, ep.func_70694_bm(), s, x1, y1, z1) : false;
    }

    public boolean func_149696_a(World w, int x, int y, int z, int eventID, int param) {
        TileLM t;
        if (this.hasTileEntity(w.func_72805_g(x, y, z)) && (t = BlockLM.getTile((IBlockAccess)w, x, y, z)) != null) {
            return t.func_145842_c(eventID, param);
        }
        return false;
    }

    public boolean recolourBlock(World w, int x, int y, int z, ForgeDirection side, int color) {
        TileLM t;
        if (this.hasTileEntity(w.func_72805_g(x, y, z)) && (t = BlockLM.getTile((IBlockAccess)w, x, y, z)) != null) {
            if (t.recolorBlock(side.ordinal(), color)) {
                // empty if block
            }
            return true;
        }
        return super.recolourBlock(w, x, y, z, side, color);
    }

    @Override
    public void loadRecipes() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack is, EntityPlayer ep, List<String> l, boolean b) {
    }

    public void func_149695_a(World w, int x, int y, int z, Block neighbor) {
        TileLM t;
        if (this.hasTileEntity(w.func_72805_g(x, y, z)) && (t = BlockLM.getTile((IBlockAccess)w, x, y, z)) != null) {
            t.onNeighborBlockChange(neighbor);
        }
    }

    @Override
    public final Item getItem() {
        return Item.func_150898_a((Block)this);
    }

    public AxisAlignedBB func_149668_a(World w, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)w, x, y, z);
        return super.func_149668_a(w, x, y, z);
    }

    public int func_149660_a(World worldIn, int x, int y, int z, int facing, float hitX, float hitY, float hitZ, int meta) {
        return meta;
    }

    public static TileLM getTile(IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te != null && !te.func_145837_r() && te instanceof TileLM) {
            return (TileLM)te;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBlockIcon() {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    protected final String func_149641_N() {
        if (this.field_149768_d == null) {
            return this.getMod().lowerCaseModID + ":" + this.blockName;
        }
        return this.getMod().lowerCaseModID + ":" + this.field_149768_d;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.field_149761_L = ir.func_94245_a(this.func_149641_N());
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int s, int m) {
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iba, int x, int y, int z, int s) {
        return this.func_149691_a(s, iba.func_72805_g(x, y, z));
    }
}

