/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.api.carts.ICartContentsTextureProvider;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.carts.CartModelManager;
import mods.railcraft.client.render.carts.RenderCart;
import mods.railcraft.client.render.models.ModelTextured;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class CartContentRenderer {
    private final RenderFakeBlock.RenderInfo info = new RenderFakeBlock.RenderInfo();

    public CartContentRenderer() {
        this.info.texture = new IIcon[6];
    }

    public void render(RenderCart renderer, EntityMinecart cart, float light, float time) {
        int blockOffset = cart.func_94099_q();
        if (cart instanceof ICartContentsTextureProvider) {
            ICartContentsTextureProvider texInterface = (ICartContentsTextureProvider)cart;
            renderer.bindTex(TextureMap.field_110575_b);
            for (int side = 0; side < 6; ++side) {
                this.info.texture[side] = texInterface.getBlockTextureOnSide(side);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)((float)blockOffset / 16.0f), (float)0.0f);
            RenderFakeBlock.renderBlockOnInventory(renderer.renderBlocks(), this.info, 1.0f);
            GL11.glPopMatrix();
            return;
        }
        Block block = cart.func_145820_n();
        if (block != null && block != Blocks.field_150350_a) {
            int blockMeta = cart.func_94098_o();
            renderer.bindTex(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)((float)blockOffset / 16.0f), (float)0.0f);
            renderer.renderBlocks().func_147800_a(block, blockMeta, 1.0f);
            GL11.glPopMatrix();
            return;
        }
        ModelTextured contents = CartModelManager.getContentModel(cart.getClass());
        if (contents == CartModelManager.emptyModel) {
            return;
        }
        ResourceLocation texture = contents.getTexture();
        if (texture == null) {
            return;
        }
        renderer.bindTex(texture);
        GL11.glPushAttrib((int)8192);
        if (!contents.cullBackFaces()) {
            GL11.glDisable((int)2884);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)-0.5f, (float)((float)blockOffset / 16.0f - 0.5f), (float)-0.5f);
        contents.func_78088_a((Entity)cart, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }
}

