/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.effects;

import cpw.mods.fml.common.SidedProxy;
import mods.railcraft.common.util.effects.IEffectManager;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;

public class EffectManager {
    @SidedProxy(clientSide="mods.railcraft.client.util.effects.ClientEffectProxy", serverSide="mods.railcraft.common.util.effects.CommonEffectProxy")
    public static IEffectManager instance;

    public static IEffectSource getEffectSource(Object source) {
        if (source instanceof TileEntity) {
            return new EffectSourceTile((TileEntity)source);
        }
        if (source instanceof Entity) {
            return new EffectSourceEntity((Entity)source);
        }
        return null;
    }

    public static class EffectSourceEntity
    implements IEffectSource {
        private final Entity source;

        private EffectSourceEntity(Entity source) {
            this.source = source;
        }

        @Override
        public double getX() {
            return this.source.field_70165_t;
        }

        @Override
        public double getY() {
            return this.source.field_70163_u + (double)this.source.field_70129_M;
        }

        @Override
        public double getZ() {
            return this.source.field_70161_v;
        }

        @Override
        public boolean isDead() {
            return this.source.field_70128_L;
        }
    }

    public static class EffectSourceTile
    implements IEffectSource {
        private final TileEntity source;

        private EffectSourceTile(TileEntity source) {
            this.source = source;
        }

        @Override
        public double getX() {
            return (double)this.source.field_145851_c + 0.5;
        }

        @Override
        public double getY() {
            return (double)this.source.field_145848_d + 0.5;
        }

        @Override
        public double getZ() {
            return (double)this.source.field_145849_e + 0.5;
        }

        @Override
        public boolean isDead() {
            return this.source.func_145837_r();
        }
    }

    public static interface IEffectSource {
        public double getX();

        public double getY();

        public double getZ();

        public boolean isDead();
    }
}

