/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.dries007.holoInventory.Config;
import net.dries007.holoInventory.client.Renderer;
import net.dries007.holoInventory.util.NamedData;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class BlockInventoryMessage
implements IMessage {
    NBTTagCompound data;

    public BlockInventoryMessage(NBTTagCompound inventoryData) {
        this.data = inventoryData;
    }

    public BlockInventoryMessage() {
    }

    public void fromBytes(ByteBuf buf) {
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class Handler
    implements IMessageHandler<BlockInventoryMessage, IMessage> {
        public IMessage onMessage(BlockInventoryMessage message, MessageContext ctx) {
            if (message == null || message.data == null) {
                return null;
            }
            if (ctx.side.isClient()) {
                NBTTagList list = message.data.func_150295_c("list", 10);
                ItemStack[] itemStacks = new ItemStack[list.func_74745_c()];
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound tag = list.func_150305_b(i);
                    itemStacks[i] = ItemStack.func_77949_a((NBTTagCompound)tag);
                    if (itemStacks[i] == null) continue;
                    itemStacks[i].field_77994_a = tag.func_74762_e("Count");
                }
                NamedData<ItemStack[]> data = message.data.func_74764_b("class") ? new NamedData<ItemStack[]>(message.data.func_74779_i("name"), message.data.func_74779_i("class"), itemStacks) : new NamedData<ItemStack[]>(message.data.func_74779_i("name"), itemStacks);
                if (Config.enableStacking) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (ItemStack stackToAdd : (ItemStack[])data.data) {
                        int remainingAmount = stackToAdd.field_77994_a;
                        for (ItemStack stackInList : stacks) {
                            if (stackInList == null || !stackToAdd.func_77969_a(stackInList) || !ItemStack.func_77970_a((ItemStack)stackToAdd, (ItemStack)stackInList)) continue;
                            int toMerge = Math.min(remainingAmount, Integer.MAX_VALUE - stackInList.field_77994_a);
                            if (toMerge > 0) {
                                stackInList.field_77994_a += toMerge;
                                remainingAmount -= toMerge;
                            }
                            if (remainingAmount > 0) continue;
                            break;
                        }
                        if (remainingAmount == 0) continue;
                        ItemStack remainingStack = stackToAdd.func_77946_l();
                        remainingStack.field_77994_a = remainingAmount;
                        stacks.add(remainingStack);
                    }
                    data.data = stacks.toArray(new ItemStack[0]);
                }
                Renderer.tileInventoryMap.put(message.data.func_74762_e("id"), data);
            }
            return null;
        }
    }
}

