/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.journeymap;

import com.sinthoras.visualprospecting.Config;
import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.integration.journeymap.buttons.DirtyChunkButton;
import com.sinthoras.visualprospecting.integration.journeymap.buttons.LayerButton;
import com.sinthoras.visualprospecting.integration.journeymap.buttons.OreVeinButton;
import com.sinthoras.visualprospecting.integration.journeymap.buttons.ThaumcraftNodeButton;
import com.sinthoras.visualprospecting.integration.journeymap.buttons.UndergroundFluidButton;
import com.sinthoras.visualprospecting.integration.journeymap.render.DirtyChunkRenderer;
import com.sinthoras.visualprospecting.integration.journeymap.render.LayerRenderer;
import com.sinthoras.visualprospecting.integration.journeymap.render.OreVeinRenderer;
import com.sinthoras.visualprospecting.integration.journeymap.render.ThaumcraftNodeRenderer;
import com.sinthoras.visualprospecting.integration.journeymap.render.UndergroundFluidChunkRenderer;
import com.sinthoras.visualprospecting.integration.journeymap.render.UndergroundFluidRenderer;
import com.sinthoras.visualprospecting.integration.journeymap.waypoints.OreVeinWaypointManager;
import com.sinthoras.visualprospecting.integration.journeymap.waypoints.ThaumcraftNodeWaypointManager;
import com.sinthoras.visualprospecting.integration.journeymap.waypoints.WaypointManager;
import com.sinthoras.visualprospecting.mixins.late.journeymap.FullscreenAccessor;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.render.map.GridRenderer;

public class JourneyMapState {
    public static JourneyMapState instance = new JourneyMapState();
    public final List<LayerButton> buttons = new ArrayList<LayerButton>();
    public final List<LayerRenderer> renderers = new ArrayList<LayerRenderer>();
    public final List<WaypointManager> waypointManagers = new ArrayList<WaypointManager>();

    public JourneyMapState() {
        if (Utils.isTCNodeTrackerInstalled()) {
            this.buttons.add(ThaumcraftNodeButton.instance);
            this.renderers.add(ThaumcraftNodeRenderer.instance);
            this.waypointManagers.add(ThaumcraftNodeWaypointManager.instance);
        }
        this.buttons.add(UndergroundFluidButton.instance);
        this.renderers.add(UndergroundFluidRenderer.instance);
        this.renderers.add(UndergroundFluidChunkRenderer.instance);
        this.buttons.add(OreVeinButton.instance);
        this.renderers.add(OreVeinRenderer.instance);
        this.waypointManagers.add(OreVeinWaypointManager.instance);
        if (Config.enableDeveloperOverlays) {
            this.buttons.add(DirtyChunkButton.instance);
            this.renderers.add(DirtyChunkRenderer.instance);
        }
    }

    public void openJourneyMapAt(int blockX, int blockZ) {
        GridRenderer gridRenderer = FullscreenAccessor.getGridRenderer();
        assert (gridRenderer != null);
        gridRenderer.center(gridRenderer.getMapType(), (double)blockX, (double)blockZ, gridRenderer.getZoom());
    }

    public void openJourneyMapAt(int blockX, int blockZ, int zoom) {
        GridRenderer gridRenderer = FullscreenAccessor.getGridRenderer();
        assert (gridRenderer != null);
        gridRenderer.center(gridRenderer.getMapType(), (double)blockX, (double)blockZ, zoom);
    }
}

