/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.internal.IGT_RecipeAdder;
import gregtech.api.interfaces.internal.IThaumcraftCompat;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.items.GT_CoolantCellIC_Item;
import gregtech.api.items.GT_CoolantCell_Item;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.items.GT_Tool_Item;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.objects.GT_Cover_Default;
import gregtech.api.objects.GT_Cover_None;
import gregtech.api.objects.GT_HashSet;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.threads.GT_Runnable_Cable_Update;
import gregtech.api.threads.GT_Runnable_MachineBlockUpdate;
import gregtech.api.util.GT_CircuitryBehavior;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_CreativeTab;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.api.world.GT_Worldgen;
import gregtech.common.GT_DummyWorld;
import gregtech.common.items.GT_IntegratedCircuit_Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class GregTech_API {
    @Deprecated
    public static final long MATERIAL_UNIT = 3628800L;
    @Deprecated
    public static final long FLUID_MATERIAL_UNIT = 144L;
    public static final Collection<Map<? extends GT_ItemStack, ?>> sItemStackMappings = new ArrayList();
    public static final short MAXIMUM_METATILE_IDS = 32766;
    public static final CreativeTabs TAB_GREGTECH = new GT_CreativeTab("Main", "Main");
    public static final CreativeTabs TAB_GREGTECH_MATERIALS = new GT_CreativeTab("Materials", "Materials");
    public static final CreativeTabs TAB_GREGTECH_ORES = new GT_CreativeTab("Ores", "Ores");
    public static final IMetaTileEntity[] METATILEENTITIES = new IMetaTileEntity[32766];
    public static final Map<GT_ItemStack, ITexture> sCovers = new ConcurrentHashMap<GT_ItemStack, ITexture>();
    public static final Map<GT_ItemStack, GT_CoverBehaviorBase<?>> sCoverBehaviors = new ConcurrentHashMap();
    public static final Map<Integer, GT_CircuitryBehavior> sCircuitryBehaviors = new ConcurrentHashMap<Integer, GT_CircuitryBehavior>();
    public static final Map<Block, Integer> sMachineIDs = new ConcurrentHashMap<Block, Integer>();
    public static final Map<Integer, Byte> sWirelessRedstone = new ConcurrentHashMap<Integer, Byte>();
    public static final Map<String, Map<Integer, Map<Long, Byte>>> sAdvancedWirelessRedstone = new ConcurrentHashMap<String, Map<Integer, Map<Long, Byte>>>();
    public static final Map<Integer, Integer> sIDSUList = new ConcurrentHashMap<Integer, Integer>();
    public static final Map<String, ItemStack> sBookList = new ConcurrentHashMap<String, ItemStack>();
    @Deprecated
    public static final Map<Integer, String> sSoundList = SoundResource.asSoundList();
    public static final GT_HashSet<GT_ItemStack> sToolList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sCrowbarList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sScrewdriverList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sWrenchList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sSoftHammerList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sHardHammerList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sWireCutterList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sSolderingToolList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sSolderingMetalList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sGasHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sBioHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sFrostHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sHeatHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sRadioHazmatList = new GT_HashSet();
    public static final GT_HashSet<GT_ItemStack> sElectroHazmatList = new GT_HashSet();
    private static final Multimap<Integer, ItemStack> sRealConfigurationList = Multimaps.newListMultimap(new TreeMap(), ArrayList::new);
    private static final Map<Integer, List<ItemStack>> sConfigurationLists = new ConcurrentHashMap<Integer, List<ItemStack>>();
    private static final Map<Predicate<ItemStack>, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> sRealCircuitProgrammerList = new LinkedHashMap<Predicate<ItemStack>, BiFunction<ItemStack, EntityPlayerMP, ItemStack>>();
    public static final Map<Predicate<ItemStack>, BiFunction<ItemStack, EntityPlayerMP, ItemStack>> sCircuitProgrammerList = Collections.unmodifiableMap(sRealCircuitProgrammerList);
    public static final Collection<Integer> sDimensionalList = new HashSet<Integer>();
    public static final List<GT_Worldgen> sWorldgenList = new ArrayList<GT_Worldgen>();
    public static final Materials[] sGeneratedMaterials = new Materials[1000];
    public static final GT_CoverBehavior sDefaultBehavior = new GT_Cover_Default();
    public static final GT_CoverBehavior sNoBehavior = new GT_Cover_None();
    public static volatile int VERSION = 509;
    @Deprecated
    public static IGT_RecipeAdder sRecipeAdder;
    public static IThaumcraftCompat sThaumcraftCompat;
    public static List<Runnable> sBeforeGTPreload;
    public static List<Runnable> sAfterGTPreload;
    public static List<Runnable> sBeforeGTLoad;
    public static List<Runnable> sAfterGTLoad;
    public static List<Runnable> sBeforeGTPostload;
    public static List<Runnable> sAfterGTPostload;
    public static List<Runnable> sFirstWorldTick;
    public static List<Runnable> sBeforeGTServerstart;
    public static List<Runnable> sAfterGTServerstart;
    public static List<Runnable> sBeforeGTServerstop;
    public static List<Runnable> sAfterGTServerstop;
    public static List<Runnable> sGTBlockIconload;
    public static List<Runnable> sGTItemIconload;
    public static List<Runnable> sGTCompleteLoad;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sBlockIcons;
    @SideOnly(value=Side.CLIENT)
    public static IIconRegister sItemIcons;
    public static GT_Config sRecipeFile;
    public static GT_Config sMachineFile;
    public static GT_Config sWorldgenFile;
    public static GT_Config sMaterialProperties;
    public static GT_Config sMaterialComponents;
    public static GT_Config sUnification;
    public static GT_Config sSpecialFile;
    public static GT_Config sClientDataFile;
    public static GT_Config sOPStuff;
    public static int TICKS_FOR_LAG_AVERAGING;
    public static int MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING;
    public static Block sBlockMachines;
    public static Block sBlockOres1;
    public static Block sBlockOresUb1;
    public static Block sBlockOresUb2;
    public static Block sBlockOresUb3;
    public static Block sBlockMetal1;
    public static Block sBlockMetal2;
    public static Block sBlockMetal3;
    public static Block sBlockMetal4;
    public static Block sBlockMetal5;
    public static Block sBlockMetal6;
    public static Block sBlockMetal7;
    public static Block sBlockMetal8;
    public static Block sBlockMetal9;
    public static Block sBlockGem1;
    public static Block sBlockGem2;
    public static Block sBlockGem3;
    public static Block sBlockReinforced;
    public static Block sBlockGranites;
    public static Block sBlockConcretes;
    public static Block sBlockStones;
    public static Block sBlockCasings1;
    public static Block sBlockCasings2;
    public static Block sBlockCasings3;
    public static Block sBlockCasings4;
    public static Block sBlockCasings5;
    public static Block sBlockCasings6;
    public static Block sBlockCasings8;
    public static Block sBlockCasings9;
    public static Block sSolenoidCoilCasings;
    public static Block sBlockLongDistancePipes;
    public static boolean sTimber;
    public static boolean sDrinksAlwaysDrinkable;
    public static boolean sMultiThreadedSounds;
    public static boolean sDoShowAllItemsInCreative;
    public static boolean sColoredGUI;
    public static boolean sMachineMetalGUI;
    public static boolean sConstantEnergy;
    public static boolean sMachineExplosions;
    public static boolean sMachineFlammable;
    public static boolean sMachineNonWrenchExplosions;
    public static boolean sMachineRainExplosions;
    public static boolean sMachineThunderExplosions;
    public static boolean sMachineFireExplosions;
    public static boolean sMachineWireFire;
    public static boolean mOutputRF;
    public static boolean mInputRF;
    public static boolean meIOLoaded;
    public static boolean mRFExplosions;
    public static boolean mServerStarted;
    public static boolean mIC2Classic;
    public static boolean mMagneticraft;
    public static boolean mImmersiveEngineering;
    public static boolean mGTPlusPlus;
    public static boolean mTranslocator;
    public static boolean mTConstruct;
    public static boolean mGalacticraft;
    public static boolean mAE2;
    public static boolean mHodgepodge;
    public static boolean mEternalSingularity;
    public static int mEUtoRF;
    public static int mRFtoEU;
    public static boolean sUseMachineMetal;
    public static boolean mUseOnlyGoodSolderingMaterials;
    private static final String aTextIC2Lower;
    public static boolean sUnificationEntriesRegistered;
    public static boolean sPreloadStarted;
    public static boolean sPreloadFinished;
    public static boolean sLoadStarted;
    public static boolean sLoadFinished;
    public static boolean sPostloadStarted;
    public static boolean sPostloadFinished;
    private static Class<BaseMetaTileEntity> sBaseMetaTileEntityClass;
    private static final IntFunction<TileEntity>[] teCreators;
    private static final Set<Class<?>> dummyWorlds;

    private static void tryAddDummyWorld(String className) {
        Class<?> clazz;
        ClassLoader cl = GregTech_API.class.getClassLoader();
        try {
            clazz = Class.forName(className, false, cl);
        }
        catch (ReflectiveOperationException ex) {
            return;
        }
        dummyWorlds.add(clazz);
    }

    public static void addDummyWorld(Class<?> clazz) {
        dummyWorlds.add(clazz);
    }

    public static boolean isDummyWorld(@Nonnull World w) {
        return dummyWorlds.contains(w.getClass());
    }

    public static ItemStack getUnificatedOreDictStack(ItemStack aOreStack) {
        if (!sPreloadFinished) {
            GT_Log.err.println("GregTech_API ERROR: " + aOreStack.func_77973_b() + "." + aOreStack.func_77960_j() + " - OreDict Unification Entries are not registered now, please call it in the postload phase.");
        }
        return GT_OreDictUnificator.get(true, aOreStack);
    }

    public static boolean causeMachineUpdate(World aWorld, int aX, int aY, int aZ) {
        if (aWorld != null && !aWorld.field_72995_K && !GregTech_API.isDummyWorld(aWorld)) {
            GT_Runnable_MachineBlockUpdate.setMachineUpdateValues(aWorld, new ChunkCoordinates(aX, aY, aZ));
            return true;
        }
        return false;
    }

    public static boolean causeCableUpdate(World aWorld, int aX, int aY, int aZ) {
        if (aWorld == null || aWorld.field_72995_K || GregTech_API.isDummyWorld(aWorld)) {
            return false;
        }
        GT_Runnable_Cable_Update.setCableUpdateValues(aWorld, new ChunkCoordinates(aX, aY, aZ));
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, int aMeta) {
        if (aBlock == null) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        sMachineIDs.put(aBlock, aMeta);
        return true;
    }

    public static boolean registerMachineBlock(Block aBlock, boolean ... aMeta) {
        if (aBlock == null || aMeta == null || aMeta.length == 0) {
            return false;
        }
        if (sThaumcraftCompat != null) {
            sThaumcraftCompat.registerPortholeBlacklistedBlock(aBlock);
        }
        int rMeta = 0;
        for (int i = 0; i < aMeta.length && i < 16; i = (int)((byte)(i + 1))) {
            if (!aMeta[i]) continue;
            rMeta |= GT_Values.B[i];
        }
        sMachineIDs.put(aBlock, rMeta);
        return true;
    }

    public static boolean isMachineBlock(Block aBlock, int aMeta) {
        if (aBlock != null) {
            Integer id = sMachineIDs.get(aBlock);
            return id != null && (id & GT_Values.B[aMeta]) != 0;
        }
        return false;
    }

    public static Item constructCoolantCellItem(String aUnlocalized, String aEnglish, int aMaxStore) {
        try {
            return new GT_CoolantCellIC_Item(aUnlocalized, aEnglish, aMaxStore);
        }
        catch (Throwable throwable) {
            try {
                return new GT_CoolantCell_Item(aUnlocalized, aEnglish, aMaxStore);
            }
            catch (Throwable throwable2) {
                return new GT_Generic_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", false);
            }
        }
    }

    public static Item constructElectricArmorItem(String aUnlocalized, String aEnglish, int aCharge, int aTransfer, int aTier, int aDamageEnergyCost, int aSpecials, double aArmorAbsorbtionPercentage, boolean aChargeProvider, int aType, int aArmorIndex) {
        try {
            return (Item)Class.forName("gregtechmod.api.items.GT_EnergyArmorIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aDamageEnergyCost, aSpecials, aArmorAbsorbtionPercentage, aChargeProvider, aType, aArmorIndex);
        }
        catch (Throwable throwable) {
            try {
                return (Item)Class.forName("gregtechmod.api.items.GT_EnergyArmor_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aDamageEnergyCost, aSpecials, aArmorAbsorbtionPercentage, aChargeProvider, aType, aArmorIndex);
            }
            catch (Throwable throwable2) {
                return new GT_Generic_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", false);
            }
        }
    }

    public static Item constructElectricEnergyStorageItem(String aUnlocalized, String aEnglish, int aCharge, int aTransfer, int aTier, int aEmptyID, int aFullID) {
        try {
            return (Item)Class.forName("gregtechmod.api.items.GT_EnergyStoreIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aEmptyID, aFullID);
        }
        catch (Throwable throwable) {
            try {
                return (Item)Class.forName("gregtechmod.api.items.GT_EnergyStore_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aCharge, aTransfer, aTier, aEmptyID, aFullID);
            }
            catch (Throwable throwable2) {
                return new GT_Generic_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", false);
            }
        }
    }

    public static GT_Tool_Item constructHardHammerItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_HardHammer_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructCrowbarItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_CrowbarRC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage);
        }
        catch (Throwable throwable) {
            try {
                return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_Crowbar_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage);
            }
            catch (Throwable throwable2) {
                return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
            }
        }
    }

    public static GT_Tool_Item constructWrenchItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_Wrench_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricScrewdriverItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_ScrewdriverIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricWrenchItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_WrenchIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricSawItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aToolQuality, float aToolStrength, int aEnergyConsumptionPerBlockBreak, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_SawIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aToolQuality, Float.valueOf(aToolStrength), aEnergyConsumptionPerBlockBreak, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricDrillItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aToolQuality, float aToolStrength, int aEnergyConsumptionPerBlockBreak, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_DrillIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aToolQuality, Float.valueOf(aToolStrength), aEnergyConsumptionPerBlockBreak, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructElectricSolderingToolItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aEntityDamage, int aDisChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_SolderingToolIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aEntityDamage, aDisChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, aEntityDamage, false);
        }
    }

    public static GT_Tool_Item constructEmptyElectricToolItem(String aUnlocalized, String aEnglish, int aMaxDamage, int aChargedGTID) {
        try {
            return (GT_Tool_Item)Class.forName("gregtechmod.api.items.GT_EmptyToolIC_Item").getConstructors()[0].newInstance(aUnlocalized, aEnglish, aMaxDamage, aChargedGTID);
        }
        catch (Throwable throwable) {
            return new GT_Tool_Item(aUnlocalized, aEnglish, "Doesn't work as intended, this is a Bug", aMaxDamage, 0, false);
        }
    }

    public static BaseMetaTileEntity constructBaseMetaTileEntity() {
        if (sBaseMetaTileEntityClass == null) {
            try {
                sBaseMetaTileEntityClass = BaseMetaTileEntity.class;
                return (BaseMetaTileEntity)BaseMetaTileEntity.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return sBaseMetaTileEntityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            GT_Log.err.println("GT_Mod: Fatal Error occurred while initializing TileEntities, crashing Minecraft.");
            e.printStackTrace(GT_Log.err);
            throw new RuntimeException(e);
        }
    }

    public static void registerConfigurationCircuit(ItemStack aStack) {
        GregTech_API.registerConfigurationCircuit(aStack, 0);
    }

    public static void registerConfigurationCircuit(ItemStack aStack, int minTier) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        for (ItemStack tRegistered : sRealConfigurationList.values()) {
            if (!GT_Utility.areStacksEqual(tRegistered, aStack)) continue;
            return;
        }
        ItemStack stack = GT_Utility.copyAmount(0L, aStack);
        sRealConfigurationList.put((Object)minTier, (Object)stack);
        for (Map.Entry<Integer, List<ItemStack>> e : sConfigurationLists.entrySet()) {
            if (e.getKey() < minTier) continue;
            e.getValue().add(stack);
            e.getValue().sort(GregTech_API.getConfigurationCircuitsComparator());
        }
    }

    public static List<ItemStack> getConfigurationCircuitList(int machineTier) {
        return Collections.unmodifiableList(sConfigurationLists.computeIfAbsent(machineTier, t -> sRealConfigurationList.entries().stream().filter(e -> (Integer)e.getKey() <= machineTier).map(Map.Entry::getValue).sorted(GregTech_API.getConfigurationCircuitsComparator()).collect(Collectors.toList())));
    }

    public static Comparator<ItemStack> getConfigurationCircuitsComparator() {
        return Comparator.comparingInt(is -> {
            if (GT_Mod.gregtechproxy.mCircuitsOrder.isEmpty()) {
                return is.func_77973_b() instanceof GT_IntegratedCircuit_Item ? 0 : 1;
            }
            return GT_Mod.gregtechproxy.mCircuitsOrder.getOrDefault(String.valueOf(GameRegistry.findUniqueIdentifierFor((Item)is.func_77973_b())), Integer.MAX_VALUE);
        }).thenComparing(ItemStack::func_77977_a).thenComparing(ItemStack::func_77960_j);
    }

    public static void registerCircuitProgrammer(ItemStack stack, boolean ignoreNBT, boolean useContainer) {
        GregTech_API.registerCircuitProgrammer((ItemStack rhs) -> GT_Utility.areStacksEqual(stack, rhs, ignoreNBT), useContainer);
    }

    public static void registerCircuitProgrammer(Predicate<ItemStack> predicate, boolean useContainer) {
        sRealCircuitProgrammerList.put(predicate, useContainer ? (s, p) -> s.func_77973_b().getContainerItem(s) : (s, p) -> s);
    }

    public static void registerCircuitProgrammer(Predicate<ItemStack> predicate, BiFunction<ItemStack, EntityPlayerMP, ItemStack> doDamage) {
        sRealCircuitProgrammerList.put(predicate, doDamage);
    }

    public static void registerCover(ItemStack aStack, ITexture aCover, GT_CoverBehavior aBehavior) {
        GregTech_API.registerCover(aStack, aCover, aBehavior);
    }

    public static void registerCover(ItemStack aStack, ITexture aCover, GT_CoverBehaviorBase<?> aBehavior) {
        if (!sCovers.containsKey(new GT_ItemStack(aStack))) {
            sCovers.put(new GT_ItemStack(aStack), aCover == null || !aCover.isValidTexture() ? Textures.BlockIcons.ERROR_RENDERING[0] : aCover);
        }
        if (aBehavior != null) {
            sCoverBehaviors.put(new GT_ItemStack(aStack), aBehavior);
        }
    }

    public static void registerCoverBehavior(ItemStack aStack, GT_CoverBehavior aBehavior) {
        GregTech_API.registerCoverBehavior(aStack, aBehavior);
    }

    public static void registerCoverBehavior(ItemStack aStack, GT_CoverBehaviorBase<?> aBehavior) {
        sCoverBehaviors.put(new GT_ItemStack(aStack), aBehavior == null ? sDefaultBehavior : aBehavior);
    }

    public static void registerCover(Collection<ItemStack> aStackList, ITexture aCover, GT_CoverBehavior aBehavior) {
        GregTech_API.registerCover(aStackList, aCover, aBehavior);
    }

    public static void registerCover(Collection<ItemStack> aStackList, ITexture aCover, GT_CoverBehaviorBase<?> aBehavior) {
        if (aCover.isValidTexture()) {
            aStackList.forEach(tStack -> GregTech_API.registerCover(tStack, aCover, aBehavior));
        }
    }

    @Deprecated
    public static GT_CoverBehavior getCoverBehavior(ItemStack aStack) {
        if (aStack == null || aStack.func_77973_b() == null) {
            return sNoBehavior;
        }
        GT_CoverBehaviorBase<?> rCover = sCoverBehaviors.get(new GT_ItemStack(aStack));
        if (!(rCover instanceof GT_CoverBehavior)) {
            return sDefaultBehavior;
        }
        return (GT_CoverBehavior)rCover;
    }

    public static GT_CoverBehaviorBase<?> getCoverBehaviorNew(ItemStack aStack) {
        if (aStack == null || aStack.func_77973_b() == null) {
            return sNoBehavior;
        }
        GT_CoverBehaviorBase<?> rCover = sCoverBehaviors.get(new GT_ItemStack(aStack));
        if (rCover != null) {
            return rCover;
        }
        rCover = sCoverBehaviors.get(new GT_ItemStack(aStack, true));
        if (rCover != null) {
            return rCover;
        }
        return sDefaultBehavior;
    }

    @Deprecated
    public static GT_CoverBehavior getCoverBehavior(int aStack) {
        if (aStack == 0) {
            return sNoBehavior;
        }
        return GregTech_API.getCoverBehavior(GT_Utility.intToStack(aStack));
    }

    public static GT_CoverBehaviorBase<?> getCoverBehaviorNew(int aStack) {
        if (aStack == 0) {
            return sNoBehavior;
        }
        return GregTech_API.getCoverBehaviorNew(GT_Utility.intToStack(aStack));
    }

    public static boolean registerWrench(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sWrenchList);
    }

    public static boolean registerCrowbar(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sCrowbarList);
    }

    public static boolean registerScrewdriver(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sScrewdriverList);
    }

    public static boolean registerSoftHammer(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sSoftHammerList);
    }

    public static boolean registerHardHammer(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sHardHammerList);
    }

    public static boolean registerWireCutter(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sWireCutterList);
    }

    public static boolean registerSolderingTool(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sSolderingToolList);
    }

    public static boolean registerSolderingMetal(ItemStack aTool) {
        return GregTech_API.registerTool(aTool, sSolderingMetalList);
    }

    public static boolean registerTool(ItemStack aTool, Collection<GT_ItemStack> aToolList) {
        if (aTool == null || GT_Utility.isStackInList(aTool, sToolList) || !aTool.func_77973_b().func_77645_m() && !GT_ModHandler.isElectricItem(aTool) && !(aTool.func_77973_b() instanceof IDamagableItem)) {
            return false;
        }
        aToolList.add(new GT_ItemStack(GT_Utility.copyAmount(1L, aTool)));
        sToolList.add(new GT_ItemStack(GT_Utility.copyAmount(1L, aTool)));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setBlockIconRegister(IIconRegister aIconRegister) {
        sBlockIcons = aIconRegister;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setItemIconRegister(IIconRegister aIconRegister) {
        sItemIcons = aIconRegister;
    }

    public static void registerTileEntityConstructor(int meta, IntFunction<TileEntity> constructor) {
        if (meta < 0 || meta > 15 || constructor == null) {
            throw new IllegalArgumentException();
        }
        if (teCreators[meta] != null) {
            throw new IllegalStateException("previous constructor: " + teCreators[meta] + " new constructor: " + constructor + " meta:" + meta);
        }
        GregTech_API.teCreators[meta] = constructor;
    }

    public static TileEntity createTileEntity(int meta) {
        if (teCreators[meta = GT_Utility.clamp(meta, 0, 15)] == null) {
            return null;
        }
        return teCreators[meta].apply(meta);
    }

    static {
        sBeforeGTPreload = new ArrayList<Runnable>();
        sAfterGTPreload = new ArrayList<Runnable>();
        sBeforeGTLoad = new ArrayList<Runnable>();
        sAfterGTLoad = new ArrayList<Runnable>();
        sBeforeGTPostload = new ArrayList<Runnable>();
        sAfterGTPostload = new ArrayList<Runnable>();
        sFirstWorldTick = new ArrayList<Runnable>();
        sBeforeGTServerstart = new ArrayList<Runnable>();
        sAfterGTServerstart = new ArrayList<Runnable>();
        sBeforeGTServerstop = new ArrayList<Runnable>();
        sAfterGTServerstop = new ArrayList<Runnable>();
        sGTBlockIconload = new ArrayList<Runnable>();
        sGTItemIconload = new ArrayList<Runnable>();
        sGTCompleteLoad = new ArrayList<Runnable>();
        sRecipeFile = null;
        sMachineFile = null;
        sWorldgenFile = null;
        sMaterialProperties = null;
        sMaterialComponents = null;
        sUnification = null;
        sSpecialFile = null;
        sOPStuff = null;
        TICKS_FOR_LAG_AVERAGING = 25;
        MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING = 100;
        sTimber = true;
        sDrinksAlwaysDrinkable = false;
        sMultiThreadedSounds = false;
        sDoShowAllItemsInCreative = false;
        sColoredGUI = true;
        sMachineMetalGUI = false;
        sConstantEnergy = true;
        sMachineExplosions = true;
        sMachineFlammable = true;
        sMachineNonWrenchExplosions = true;
        sMachineRainExplosions = true;
        sMachineThunderExplosions = true;
        sMachineFireExplosions = true;
        sMachineWireFire = true;
        mOutputRF = false;
        mInputRF = false;
        meIOLoaded = false;
        mRFExplosions = false;
        mServerStarted = false;
        mIC2Classic = false;
        mMagneticraft = false;
        mImmersiveEngineering = false;
        mGTPlusPlus = false;
        mTranslocator = false;
        mTConstruct = false;
        mGalacticraft = false;
        mAE2 = false;
        mHodgepodge = false;
        mEternalSingularity = false;
        mEUtoRF = 360;
        mRFtoEU = 20;
        sUseMachineMetal = false;
        mUseOnlyGoodSolderingMaterials = false;
        aTextIC2Lower = Mods.IndustrialCraft2.ID.toLowerCase(Locale.ENGLISH);
        sUnificationEntriesRegistered = false;
        sPreloadStarted = false;
        sPreloadFinished = false;
        sLoadStarted = false;
        sLoadFinished = false;
        sPostloadStarted = false;
        sPostloadFinished = false;
        sBaseMetaTileEntityClass = null;
        teCreators = new IntFunction[16];
        dummyWorlds = new HashSet();
        sItemStackMappings.add(sCovers);
        sItemStackMappings.add(sCoverBehaviors);
        dummyWorlds.add(GT_DummyWorld.class);
        GregTech_API.tryAddDummyWorld("blockrenderer6343.client.world.DummyWorld");
    }
}

