/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs.paths;

import gregtech.api.graphs.paths.NodePath;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import net.minecraft.server.MinecraftServer;

public class PowerNodePath
extends NodePath {
    long mMaxAmps;
    long mAmps = 0L;
    long mLoss;
    long mVoltage = 0L;
    long mMaxVoltage;
    int mTick = 0;
    boolean mCountUp = true;

    public PowerNodePath(MetaPipeEntity[] aCables) {
        super(aCables);
    }

    public long getLoss() {
        return this.mLoss;
    }

    public void applyVoltage(long aVoltage, boolean aCountUp) {
        int tNewTime = MinecraftServer.func_71276_C().func_71259_af();
        if (this.mTick != tNewTime) {
            this.reset(tNewTime - this.mTick);
            this.mTick = tNewTime;
            this.mVoltage = aVoltage;
            this.mCountUp = aCountUp;
        } else if (this.mCountUp != aCountUp && aVoltage - this.mLoss > this.mVoltage || aVoltage > this.mVoltage) {
            this.mCountUp = aCountUp;
            this.mVoltage = aVoltage;
        }
        if (aVoltage > this.mMaxVoltage) {
            this.lock.addTileEntity(null);
            for (MetaPipeEntity tCable : this.mPipes) {
                BaseMetaPipeEntity tBaseCable;
                if (((GT_MetaPipeEntity_Cable)tCable).mVoltage >= this.mVoltage || (tBaseCable = (BaseMetaPipeEntity)tCable.getBaseMetaTileEntity()) == null) continue;
                tBaseCable.setToFire();
            }
        }
    }

    private void reset(int aTimePassed) {
        if (aTimePassed < 0 || aTimePassed > 100) {
            this.mAmps = 0L;
            return;
        }
        this.mAmps = Math.max(0L, this.mAmps - this.mMaxAmps * (long)aTimePassed);
    }

    public void addAmps(long aAmps) {
        this.mAmps += aAmps;
        if (this.mAmps > this.mMaxAmps * 40L) {
            this.lock.addTileEntity(null);
            for (MetaPipeEntity tCable : this.mPipes) {
                BaseMetaPipeEntity tBaseCable;
                if (((GT_MetaPipeEntity_Cable)tCable).mAmperage * 40L >= this.mAmps || (tBaseCable = (BaseMetaPipeEntity)tCable.getBaseMetaTileEntity()) == null) continue;
                tBaseCable.setToFire();
            }
        }
    }

    public long getAmps() {
        int tTime = MinecraftServer.func_71276_C().func_71259_af() - 10;
        if (this.mTick < tTime) {
            this.reset(tTime - this.mTick);
            this.mTick = tTime;
        }
        return this.mAmps;
    }

    public long getVoltage(MetaPipeEntity aCable) {
        int tLoss = 0;
        if (this.mCountUp) {
            for (MetaPipeEntity mPipe : this.mPipes) {
                GT_MetaPipeEntity_Cable tCable = (GT_MetaPipeEntity_Cable)mPipe;
                tLoss = (int)((long)tLoss + tCable.mCableLossPerMeter);
                if (aCable != tCable) continue;
                return Math.max(this.mVoltage - (long)tLoss, 0L);
            }
        } else {
            for (int i = this.mPipes.length - 1; i >= 0; --i) {
                GT_MetaPipeEntity_Cable tCable = (GT_MetaPipeEntity_Cable)this.mPipes[i];
                tLoss = (int)((long)tLoss + tCable.mCableLossPerMeter);
                if (aCable != tCable) continue;
                return Math.max(this.mVoltage - (long)tLoss, 0L);
            }
        }
        return -1L;
    }

    @Override
    protected void processPipes() {
        super.processPipes();
        this.mMaxAmps = Integer.MAX_VALUE;
        this.mMaxVoltage = Integer.MAX_VALUE;
        for (MetaPipeEntity tCable : this.mPipes) {
            if (!(tCable instanceof GT_MetaPipeEntity_Cable)) continue;
            this.mMaxAmps = Math.min(((GT_MetaPipeEntity_Cable)tCable).mAmperage, this.mMaxAmps);
            this.mLoss += ((GT_MetaPipeEntity_Cable)tCable).mCableLossPerMeter;
            this.mMaxVoltage = Math.min(((GT_MetaPipeEntity_Cable)tCable).mVoltage, this.mMaxVoltage);
        }
    }
}

