/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import gregtech.api.multitileentity.multiblock.base.Controller;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_ParallelHelper;
import gregtech.api.util.GT_Recipe;
import java.util.stream.LongStream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ComplexParallelProcessingLogic {
    protected Controller<?> tileEntity;
    protected GT_Recipe.GT_Recipe_Map recipeMap;
    protected boolean hasPerfectOverclock;
    protected final int maxComplexParallels;
    protected final ItemStack[][] outputItems;
    protected final ItemStack[][] inputItems;
    protected final FluidStack[][] inputFluids;
    protected final FluidStack[][] outputFluids;
    protected final long[] availableEut;
    protected final long[] eut;
    protected final long[] durations;
    protected final boolean[] isItemVoidProtected;
    protected final boolean[] isFluidVoidProtected;

    public ComplexParallelProcessingLogic(int maxComplexParallels) {
        this(null, maxComplexParallels);
    }

    public ComplexParallelProcessingLogic(GT_Recipe.GT_Recipe_Map recipeMap, int maxComplexParallels) {
        this.maxComplexParallels = maxComplexParallels;
        this.recipeMap = recipeMap;
        this.inputItems = new ItemStack[maxComplexParallels][];
        this.outputItems = new ItemStack[maxComplexParallels][];
        this.inputFluids = new FluidStack[maxComplexParallels][];
        this.outputFluids = new FluidStack[maxComplexParallels][];
        this.eut = new long[maxComplexParallels];
        this.availableEut = new long[maxComplexParallels];
        this.durations = new long[maxComplexParallels];
        this.isItemVoidProtected = new boolean[maxComplexParallels];
        this.isFluidVoidProtected = new boolean[maxComplexParallels];
    }

    public ComplexParallelProcessingLogic setRecipeMap(GT_Recipe.GT_Recipe_Map recipeMap) {
        this.recipeMap = recipeMap;
        return this;
    }

    public ComplexParallelProcessingLogic setInputItems(int index, ItemStack ... itemInputs) {
        if (index >= 0 && index < this.maxComplexParallels) {
            this.inputItems[index] = itemInputs;
        }
        return this;
    }

    public ComplexParallelProcessingLogic setInputFluids(int index, FluidStack ... inputFluids) {
        if (index >= 0 && index < this.maxComplexParallels) {
            this.inputFluids[index] = inputFluids;
        }
        return this;
    }

    public ComplexParallelProcessingLogic setTileEntity(Controller<?> tileEntity) {
        this.tileEntity = tileEntity;
        return this;
    }

    public ComplexParallelProcessingLogic setEut(int index, long eut) {
        if (index >= 0 && index < this.maxComplexParallels) {
            this.availableEut[index] = eut;
        }
        return this;
    }

    public ComplexParallelProcessingLogic setVoidProtection(int index, boolean protectItem, boolean protectFluid) {
        if (index >= 0 && index < this.maxComplexParallels) {
            this.isItemVoidProtected[index] = protectItem;
            this.isFluidVoidProtected[index] = protectFluid;
        }
        return this;
    }

    public ComplexParallelProcessingLogic setPerfectOverclock(boolean shouldOverclockPerfectly) {
        this.hasPerfectOverclock = shouldOverclockPerfectly;
        return this;
    }

    public ComplexParallelProcessingLogic clear() {
        for (int i = 0; i < this.maxComplexParallels; ++i) {
            this.outputItems[i] = null;
            this.outputFluids[i] = null;
            this.durations[i] = 0L;
            this.eut[i] = 0L;
        }
        return this;
    }

    public ComplexParallelProcessingLogic clear(int index) {
        if (index >= 0 && index < this.maxComplexParallels) {
            this.inputItems[index] = null;
            this.inputFluids[index] = null;
            this.outputItems[index] = null;
            this.outputFluids[index] = null;
            this.durations[index] = 0L;
            this.availableEut[index] = 0L;
            this.eut[index] = 0L;
        }
        return this;
    }

    public boolean process(int index) {
        if (this.recipeMap == null) {
            return false;
        }
        GT_Recipe recipe = this.recipeMap.findRecipe(this.tileEntity, false, false, this.availableEut[index], this.inputFluids[index], this.inputItems[index]);
        if (recipe == null) {
            return false;
        }
        GT_ParallelHelper helper = new GT_ParallelHelper().setRecipe(recipe).setItemInputs(this.inputItems[index]).setFluidInputs(this.inputFluids[index]).setAvailableEUt(this.availableEut[index]).setMachine(this.tileEntity, this.isItemVoidProtected[index], this.isFluidVoidProtected[index]).enableConsumption().enableOutputCalculation();
        helper.build();
        if (helper.getCurrentParallel() <= 0) {
            return false;
        }
        GT_OverclockCalculator calculator = new GT_OverclockCalculator().setRecipeEUt(recipe.mEUt).setDuration(recipe.mDuration).setEUt(this.availableEut[index]);
        if (this.hasPerfectOverclock) {
            calculator.enablePerfectOC();
        }
        if (calculator.getConsumption() == 0x7FFFFFFFFFFFFFFEL || calculator.getDuration() == 0x7FFFFFFE) {
            return false;
        }
        this.durations[index] = calculator.getDuration();
        this.eut[index] = calculator.getConsumption();
        this.outputItems[index] = helper.getItemOutputs();
        this.outputFluids[index] = helper.getFluidOutputs();
        return true;
    }

    public long getDuration(int index) {
        if (index >= 0 && index < this.maxComplexParallels) {
            return this.durations[index];
        }
        return 0L;
    }

    public long getTotalEU() {
        return LongStream.of(this.eut).sum();
    }

    public ItemStack[] getOutputItems(int index) {
        if (index >= 0 && index < this.maxComplexParallels) {
            return this.outputItems[index];
        }
        return null;
    }

    public FluidStack[] getOutputFluids(int index) {
        if (index >= 0 && index < this.maxComplexParallels) {
            return this.outputFluids[index];
        }
        return null;
    }
}

