/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import codechicken.lib.render.TextureUtils;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.common.render.items.GT_GeneratedMaterial_Renderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import singulariteam.eternalsingularity.render.CosmicRenderStuffs;

public class UniversiumRenderer
extends GT_GeneratedMaterial_Renderer {
    private static final float cosmicOpacity = 2.5f;

    @Override
    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION || helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING;
    }

    @Override
    public boolean renderFluidDisplayItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        this.magicRenderMethod(type, ItemList.Emitter_UEV.get(1L, new Object[0]), aStack.func_77973_b().func_77617_a(aStack.func_77960_j()), true, data);
        return true;
    }

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        short aMetaData = (short)aStack.func_77960_j();
        Item item = aStack.func_77973_b();
        if (!(item instanceof IGT_ItemWithMaterialRenderer)) {
            return;
        }
        IGT_ItemWithMaterialRenderer aItem = (IGT_ItemWithMaterialRenderer)item;
        int passes = 1;
        if (aItem.requiresMultipleRenderPasses()) {
            passes = aItem.getRenderPasses(aMetaData);
        }
        for (int pass = 0; pass < passes; ++pass) {
            IIcon tIcon = aItem.getIcon(aMetaData, pass);
            IIcon tOverlay = aItem.getOverlayIcon(aMetaData, pass);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3008);
            if (tIcon != null) {
                this.markNeedsAnimationUpdate(tIcon);
                this.magicRenderMethod(type, aStack, tIcon, false, data);
            }
            GL11.glDisable((int)2896);
            if (tOverlay != null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                TextureUtils.bindAtlas((int)aItem.getSpriteNumber());
                this.markNeedsAnimationUpdate(tOverlay);
                this.renderItemOverlay(type, tOverlay);
            }
            GL11.glDisable((int)3042);
        }
    }

    private void magicRenderMethod(IItemRenderer.ItemRenderType type, ItemStack aStack, IIcon tIcon, boolean fluidDisplay, Object ... data) {
        if (!GregTech_API.mEternalSingularity) {
            return;
        }
        RenderItem r = RenderItem.getInstance();
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator t = Tessellator.field_78398_a;
        this.processLightLevel(type, data);
        switch (type) {
            case ENTITY: {
                GL11.glPushMatrix();
                if (aStack.func_82839_y()) {
                    GL11.glTranslatef((float)0.0f, (float)-0.3f, (float)0.01f);
                }
                this.render(tIcon);
                GL11.glPopMatrix();
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                this.render(tIcon);
                break;
            }
            case INVENTORY: {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                RenderHelper.func_74520_c();
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2929);
                if (fluidDisplay) {
                    ResourceLocation resourcelocation = mc.func_110434_K().func_130087_a(aStack.func_94608_d());
                    mc.func_110434_K().func_110577_a(resourcelocation);
                } else {
                    r.renderItemIntoGUI(mc.field_71466_p, mc.func_110434_K(), aStack, 0, 0, true);
                }
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                RenderHelper.func_74520_c();
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2929);
                if (fluidDisplay) {
                    GL11.glDisable((int)3042);
                }
                CosmicRenderStuffs.cosmicOpacity = 2.5f;
                CosmicRenderStuffs.inventoryRender = true;
                CosmicRenderStuffs.useShader();
                GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)1.0);
                float minu = tIcon.func_94209_e();
                float maxu = tIcon.func_94212_f();
                float minv = tIcon.func_94206_g();
                float maxv = tIcon.func_94210_h();
                t.func_78382_b();
                t.func_78374_a(0.0, 0.0, 0.0, (double)minu, (double)minv);
                t.func_78374_a(0.0, 16.0, 0.0, (double)minu, (double)maxv);
                t.func_78374_a(16.0, 16.0, 0.0, (double)maxu, (double)maxv);
                t.func_78374_a(16.0, 0.0, 0.0, (double)maxu, (double)minv);
                t.func_78381_a();
                CosmicRenderStuffs.releaseShader();
                CosmicRenderStuffs.inventoryRender = false;
                GL11.glEnable((int)3008);
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2929);
                r.field_77024_a = true;
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                break;
            }
        }
    }

    private void render(IIcon icon) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float scale = 0.0625f;
        float f = icon.func_94209_e();
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94210_h();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)scale);
        GL11.glDisable((int)3008);
        GL11.glDepthFunc((int)514);
        CosmicRenderStuffs.cosmicOpacity = 2.5f;
        CosmicRenderStuffs.useShader();
        float minu = icon.func_94209_e();
        float maxu = icon.func_94212_f();
        float minv = icon.func_94206_g();
        float maxv = icon.func_94210_h();
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)maxu, (float)minv, (float)minu, (float)maxv, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)scale);
        CosmicRenderStuffs.releaseShader();
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void processLightLevel(IItemRenderer.ItemRenderType type, Object ... data) {
        switch (type) {
            case ENTITY: {
                EntityItem ent = (EntityItem)data[1];
                if (ent == null) break;
                CosmicRenderStuffs.setLightFromLocation((World)ent.field_70170_p, (int)MathHelper.func_76128_c((double)ent.field_70165_t), (int)MathHelper.func_76128_c((double)ent.field_70163_u), (int)MathHelper.func_76128_c((double)ent.field_70161_v));
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                EntityLivingBase ent = (EntityLivingBase)data[1];
                if (ent == null) break;
                CosmicRenderStuffs.setLightFromLocation((World)ent.field_70170_p, (int)MathHelper.func_76128_c((double)ent.field_70165_t), (int)MathHelper.func_76128_c((double)ent.field_70163_u), (int)MathHelper.func_76128_c((double)ent.field_70161_v));
                break;
            }
            case INVENTORY: {
                CosmicRenderStuffs.setLightLevel((float)10.2f);
                break;
            }
            default: {
                CosmicRenderStuffs.setLightLevel((float)1.0f);
            }
        }
    }
}

