/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Single_Recipe_Check;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_PyrolyseOven
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_PyrolyseOven>
implements ISurvivalConstructable {
    private HeatingCoilLevel coilHeat;
    private static final int CASING_INDEX = 1090;
    private static final IStructureDefinition<GT_MetaTileEntity_PyrolyseOven> STRUCTURE_DEFINITION = GT_MetaTileEntity_PyrolyseOven.createStructureDefinition();
    private int mCasingAmount;

    private static IStructureDefinition<GT_MetaTileEntity_PyrolyseOven> createStructureDefinition() {
        IStructureElement tCasingElement = Mods.NewHorizonsCoreMod.isModLoaded() ? StructureUtility.ofBlockUnlocalizedName((String)Mods.NewHorizonsCoreMod.ID, (String)"gt.blockcasingsNH", (int)2) : StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)0);
        return StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ctttc", "ctttc", "ctttc", "ccccc"}, {"ccccc", "c---c", "c---c", "c---c", "ccccc"}, {"ccccc", "c---c", "c---c", "c---c", "ccccc"}, {"bb~bb", "bCCCb", "bCCCb", "bCCCb", "bbbbb"}})).addElement('c', StructureUtility.onElementPass(GT_MetaTileEntity_PyrolyseOven::onCasingAdded, (IStructureElement)tCasingElement)).addElement('C', GT_StructureUtility.ofCoil(GT_MetaTileEntity_PyrolyseOven::setCoilLevel, GT_MetaTileEntity_PyrolyseOven::getCoilLevel)).addElement('b', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_PyrolyseOven.class).atLeast(GT_HatchElement.OutputBus, GT_HatchElement.OutputHatch, GT_HatchElement.Energy, GT_HatchElement.Maintenance).casingIndex(1090).dot(1).buildAndChain(StructureUtility.onElementPass(GT_MetaTileEntity_PyrolyseOven::onCasingAdded, (IStructureElement)tCasingElement))).addElement('t', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_PyrolyseOven.class).atLeast(GT_HatchElement.InputBus, GT_HatchElement.InputHatch, GT_HatchElement.Muffler).casingIndex(1090).dot(1).buildAndChain(StructureUtility.onElementPass(GT_MetaTileEntity_PyrolyseOven::onCasingAdded, (IStructureElement)tCasingElement))).build();
    }

    public GT_MetaTileEntity_PyrolyseOven(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_PyrolyseOven(String aName) {
        super(aName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Coke Oven").addInfo("Controller block for the Pyrolyse Oven").addInfo("Industrial Charcoal producer").addInfo("Processing speed scales linearly with Coil tier:").addInfo("CuNi: 50%, FeAlCr: 100%, Ni4Cr: 150%, TPV: 200%, etc.").addInfo("EU/t is not affected by Coil tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(5, 4, 5, true).addController("Front center").addCasingInfoRange("Pyrolyse Oven Casing", 60, 80, false).addOtherStructurePart("Heating Coils", "Center 3x1x3 of the bottom layer").addEnergyHatch("Any bottom layer casing", 1).addMaintenanceHatch("Any bottom layer casing", 1).addMufflerHatch("Center 3x1x3 area in top layer", 2).addInputBus("Center 3x1x3 area in top layer", 2).addInputHatch("Center 3x1x3 area in top layer", 2).addOutputBus("Any bottom layer casing", 1).addOutputHatch("Any bottom layer casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][66], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][66], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][66]};
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        GT_Recipe tRecipe;
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        if (this.mLockedToSingleRecipe && this.mSingleRecipeCheck != null) {
            if (!this.mSingleRecipeCheck.checkRecipeInputsSingleStack(true)) {
                return false;
            }
            tRecipe = this.mSingleRecipeCheck.getRecipe();
        } else {
            ItemStack[] tInputs = this.getCompactedInputs();
            FluidStack[] tFluids = this.getCompactedFluids();
            if (tInputs.length == 0) {
                return false;
            }
            GT_Single_Recipe_Check.Builder tSingleRecipeCheckBuilder = null;
            if (this.mLockedToSingleRecipe) {
                tSingleRecipeCheckBuilder = GT_Single_Recipe_Check.builder(this).setBefore(tInputs, tFluids);
            }
            if ((tRecipe = GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs)) == null || !this.canOutputAll(tRecipe) || !tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                return false;
            }
            if (this.mLockedToSingleRecipe) {
                this.mSingleRecipeCheck = tSingleRecipeCheckBuilder.setAfter(tInputs, tFluids).setRecipe(tRecipe).build();
            }
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.calculateOverclockedNessMultiInternal(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage, false);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(this.mMaxProgresstime * 2 / (1 + this.coilHeat.getTier()), 1);
        if (tRecipe.mOutputs.length > 0) {
            this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0)};
        }
        if (tRecipe.mFluidOutputs.length > 0) {
            this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
        }
        this.updateSlots();
        return true;
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_PyrolyseOven> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.coilHeat;
    }

    private void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.coilHeat = aCoilLevel;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.coilHeat = HeatingCoilLevel.None;
        this.mCasingAmount = 0;
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        return this.checkPiece("main", 2, 3, 0) && this.mCasingAmount >= 60 && this.mMaintenanceHatches.size() == 1 && !this.mMufflerHatches.isEmpty();
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GT_Mod.gregtechproxy.mPollutionPyrolyseOvenPerSecond;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_PyrolyseOven(this.mName);
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir * 2;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir * 2;
        for (int xPos = tX - 1; xPos <= tX + 1; ++xPos) {
            for (int zPos = tZ - 1; zPos <= tZ + 1; ++zPos) {
                if (aBaseMetaTileEntity.getBlock(xPos, tY, zPos) != GregTech_API.sBlockCasings1 || aBaseMetaTileEntity.getMetaID(xPos, tY, zPos) != 13) continue;
                aBaseMetaTileEntity.getWorld().func_147465_d(xPos, (int)tY, zPos, GregTech_API.sBlockCasings5, 1, 3);
            }
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece("main", stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }
}

