/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multiblock.logic;

import gregtech.api.enums.Mods;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CokeOvenProcessingLogic
extends ProcessingLogic {
    private static final int NORMAL_RECIPE_TIME = 1800;
    private static final int WOOD_ORE_ID = OreDictionary.getOreID((String)"logWood");
    private static final int COAL_ORE_ID = OreDictionary.getOreID((String)"coal");
    private static final int COAL_BLOCK_ORE_ID = OreDictionary.getOreID((String)"blockCoal");
    private static final int SUGARCANE_ORE_ID = OreDictionary.getOreID((String)"sugarcane");
    private static final int CACTUS_ORE_ID = OreDictionary.getOreID((String)"blockCactus");
    private static final int CACTUS_CHARCOAL_ORE_ID = OreDictionary.getOreID((String)"itemCharcoalCactus");
    private static final int SUGAR_CHARCOAL_ORE_ID = OreDictionary.getOreID((String)"itemCharcoalSugar");
    private int timeMultiplier = 1;

    @Override
    public boolean process() {
        if (this.inputItems == null || this.inputItems[0] == null) {
            return false;
        }
        ItemStack input = this.inputItems[0];
        int originalStackSize = input.field_77994_a;
        ItemStack output = this.findRecipe(input);
        if (this.currentOutputItems != null && this.currentOutputItems[0] != null && !this.currentOutputItems[0].func_77969_a(output)) {
            return false;
        }
        --input.field_77994_a;
        this.setDuration(1800L * (long)this.timeMultiplier);
        this.setOutputItems(output);
        return originalStackSize > input.field_77994_a;
    }

    protected ItemStack findRecipe(ItemStack input) {
        for (int oreId : OreDictionary.getOreIDs((ItemStack)input)) {
            if (oreId == COAL_ORE_ID) {
                return GT_OreDictUnificator.get("fuelCoke", null, 1L);
            }
            if (oreId == COAL_BLOCK_ORE_ID) {
                this.timeMultiplier = 9;
                return GT_ModHandler.getModItem(Mods.Railcraft.ID, "cube", 1L, 0);
            }
            if (oreId == WOOD_ORE_ID) {
                return new ItemStack(Items.field_151044_h, 1, 1);
            }
            if (oreId == SUGARCANE_ORE_ID) {
                return GT_OreDictUnificator.get("itemCharcoalSugar", null, 1L);
            }
            if (oreId == SUGAR_CHARCOAL_ORE_ID) {
                return GT_OreDictUnificator.get("itemCokeSugar", null, 1L);
            }
            if (oreId == CACTUS_ORE_ID) {
                return GT_OreDictUnificator.get("itemCharcoalCactus", null, 1L);
            }
            if (oreId != CACTUS_CHARCOAL_ORE_ID) continue;
            return GT_OreDictUnificator.get("itemCokeCactus", null, 1L);
        }
        return null;
    }
}

