/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TierEU;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import net.minecraft.item.ItemStack;

public class ProcessingPipe
implements IOreRecipeRegistrator {
    public ProcessingPipe() {
        OrePrefixes.pipeHuge.add(this);
        OrePrefixes.pipeLarge.add(this);
        OrePrefixes.pipeMedium.add(this);
        OrePrefixes.pipeSmall.add(this);
        OrePrefixes.pipeTiny.add(this);
        OrePrefixes.pipeRestrictiveHuge.add(this);
        OrePrefixes.pipeRestrictiveLarge.add(this);
        OrePrefixes.pipeRestrictiveMedium.add(this);
        OrePrefixes.pipeRestrictiveSmall.add(this);
        OrePrefixes.pipeRestrictiveTiny.add(this);
        OrePrefixes.pipeQuadruple.add(this);
        OrePrefixes.pipeNonuple.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        switch (aPrefix) {
            case pipeHuge: 
            case pipeLarge: 
            case pipeMedium: 
            case pipeSmall: 
            case pipeTiny: {
                if ((long)aMaterial.getProcessingMaterialTierEU() >= TierEU.IV) break;
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.pipeTiny, aMaterial, 8L), GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"PPP", "h w", "PPP", Character.valueOf('P'), OrePrefixes.plate.get(aMaterial)});
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial, 6L), GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"PWP", "P P", "PHP", Character.valueOf('P'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(aMaterial) : OrePrefixes.plate.get(aMaterial), Character.valueOf('H'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSoftHammer : ToolDictNames.craftingToolHardHammer, Character.valueOf('W'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSaw : ToolDictNames.craftingToolWrench});
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 2L), GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"PPP", "W H", "PPP", Character.valueOf('P'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(aMaterial) : OrePrefixes.plate.get(aMaterial), Character.valueOf('H'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSoftHammer : ToolDictNames.craftingToolHardHammer, Character.valueOf('W'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSaw : ToolDictNames.craftingToolWrench});
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.pipeLarge, aMaterial, 1L), GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"PHP", "P P", "PWP", Character.valueOf('P'), aMaterial == Materials.Wood ? OrePrefixes.plank.get(aMaterial) : OrePrefixes.plate.get(aMaterial), Character.valueOf('H'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSoftHammer : ToolDictNames.craftingToolHardHammer, Character.valueOf('W'), aMaterial.contains(SubTag.WOOD) ? ToolDictNames.craftingToolSaw : ToolDictNames.craftingToolWrench});
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.pipeHuge, aMaterial, 1L), GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"DhD", "D D", "DwD", Character.valueOf('D'), OrePrefixes.plateDouble.get(aMaterial)});
                break;
            }
            case pipeRestrictiveHuge: 
            case pipeRestrictiveLarge: 
            case pipeRestrictiveMedium: 
            case pipeRestrictiveSmall: 
            case pipeRestrictiveTiny: {
                GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.ring, Materials.Steel, aPrefix.mSecondaryMaterial.mAmount / OrePrefixes.ring.mMaterialAmount), GT_OreDictUnificator.get(aOreDictName.replaceFirst("Restrictive", ""), null, 1L, false, true)).itemOutputs(GT_Utility.copyAmount(1L, aStack)).noFluidInputs().noFluidOutputs().duration((int)(aPrefix.mSecondaryMaterial.mAmount * 400L / OrePrefixes.ring.mMaterialAmount) * 1).eut(4).addTo(GT_Recipe.GT_Recipe_Map.sAssemblerRecipes);
                break;
            }
            case pipeQuadruple: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.pipeQuadruple, aMaterial, 1L), GT_ModHandler.RecipeBits.REVERSIBLE | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"MM ", "MM ", "   ", Character.valueOf('M'), GT_OreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 1L)});
                }
                GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.pipeMedium, aMaterial, 4L), GT_Utility.getIntegratedCircuit(9)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeQuadruple, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(60).eut(GT_Utility.calculateRecipeEU(aMaterial, 4)).addTo(GT_Recipe.GT_Recipe_Map.sAssemblerRecipes);
                break;
            }
            case pipeNonuple: {
                if ((long)aMaterial.getProcessingMaterialTierEU() < TierEU.IV) {
                    GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.REVERSIBLE | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"PPP", "PPP", "PPP", Character.valueOf('P'), GT_OreDictUnificator.get(aOreDictName.replaceFirst("Nonuple", "Small"), null, 1L, false, true)});
                }
                GT_Values.RA.stdBuilder().itemInputs(GT_OreDictUnificator.get(OrePrefixes.pipeSmall, aMaterial, 9L), GT_Utility.getIntegratedCircuit(9)).itemOutputs(GT_OreDictUnificator.get(OrePrefixes.pipeNonuple, aMaterial, 1L)).noFluidInputs().noFluidOutputs().duration(60).eut(GT_Utility.calculateRecipeEU(aMaterial, 8)).addTo(GT_Recipe.GT_Recipe_Map.sAssemblerRecipes);
                break;
            }
        }
    }
}

