/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.waila;

import cpw.mods.fml.common.Optional;
import ftb.lib.api.EventLM;
import ftb.lib.api.tile.IWailaTile;
import ftb.lib.api.waila.BasicWailaHandler;
import ftb.lib.api.waila.WailaDataProvider;
import ftb.lib.api.waila.WailaLMTile;
import ftb.lib.api.waila.WailaType;
import java.util.ArrayList;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;

public class EventRegisterWaila
extends EventLM {
    private static final ArrayList<WailaRegEntry> registry = new ArrayList();

    public void register(Class<?> block, BasicWailaHandler h) {
        for (WailaType t : h.types) {
            registry.add(new WailaRegEntry(block, h, t));
        }
    }

    @Optional.Method(modid="Waila")
    public static void registerHandlers(IWailaRegistrar i) {
        EventRegisterWaila e = new EventRegisterWaila();
        e.register(IWailaTile.Stack.class, new WailaLMTile(e, WailaType.STACK));
        e.register(IWailaTile.Head.class, new WailaLMTile(e, WailaType.HEAD));
        e.register(IWailaTile.Body.class, new WailaLMTile(e, WailaType.BODY));
        e.register(IWailaTile.Tail.class, new WailaLMTile(e, WailaType.TAIL));
        e.post();
        for (WailaRegEntry wre : registry) {
            if (wre.type == WailaType.STACK) {
                i.registerStackProvider((IWailaDataProvider)new WailaDataProvider(wre.handler), wre.block);
            }
            if (wre.type == WailaType.HEAD) {
                i.registerHeadProvider((IWailaDataProvider)new WailaDataProvider(wre.handler), wre.block);
            }
            if (wre.type == WailaType.BODY) {
                i.registerBodyProvider((IWailaDataProvider)new WailaDataProvider(wre.handler), wre.block);
            }
            if (wre.type != WailaType.TAIL) continue;
            i.registerTailProvider((IWailaDataProvider)new WailaDataProvider(wre.handler), wre.block);
        }
    }

    private class WailaRegEntry {
        public final Class<?> block;
        public final BasicWailaHandler handler;
        public final WailaType type;

        public WailaRegEntry(Class<?> c, BasicWailaHandler h, WailaType t) {
            this.block = c;
            this.handler = h;
            this.type = t;
        }
    }
}

