/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.recipes;

import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class NBTItem {
    private ItemStack stack;
    private NBTTagCompound nbt;
    private boolean exact = false;

    public NBTItem() {
    }

    public NBTItem(ItemStack stack) {
        this.item(stack);
    }

    public boolean matches(ItemStack stack) {
        if (!GT_Utility.areStacksEqual((ItemStack)this.stack, (ItemStack)stack, (boolean)true)) {
            return false;
        }
        if (this.nbt == null && stack.field_77990_d != null) {
            return !this.exact;
        }
        if (this.nbt == null) {
            return true;
        }
        if (this.exact) {
            return this.nbt.equals((Object)stack.field_77990_d);
        }
        if (this.nbt.func_82582_d()) {
            return true;
        }
        if (stack.field_77990_d == null) {
            return false;
        }
        for (String key : this.nbt.func_150296_c()) {
            NBTBase v;
            if (!stack.field_77990_d.func_150297_b(key, (int)(v = this.nbt.func_74781_a(key)).func_74732_a())) {
                return false;
            }
            if (stack.field_77990_d.func_74781_a(key).equals((Object)v)) continue;
            return false;
        }
        return true;
    }

    public NBTItem item(ItemStack stack) {
        this.stack = stack;
        if (this.stack.field_77990_d != null) {
            this.nbt = this.stack.field_77990_d;
            this.stack.field_77990_d = null;
        }
        return this;
    }

    public NBTItem item(Item item) {
        this.stack = new ItemStack(item);
        return this;
    }

    public NBTItem item(Block block) {
        this.stack = new ItemStack(block);
        return this;
    }

    public NBTItem setNBT(NBTTagCompound nbt) {
        this.nbt = nbt;
        return this;
    }

    public NBTItem setNBT(String nbt) {
        try {
            this.nbt = (NBTTagCompound)JsonToNBT.func_150315_a((String)nbt);
        }
        catch (NBTException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public NBTItem addNBT(String tagName, NBTBase nbt) {
        if (this.nbt == null) {
            this.nbt = new NBTTagCompound();
        }
        this.nbt.func_74782_a(tagName, nbt);
        return this;
    }

    public NBTItem matchExact() {
        this.exact = true;
        return this;
    }

    public ItemStack getStack() {
        ItemStack stack = this.stack.func_77946_l();
        if (this.nbt != null && !this.nbt.func_82582_d()) {
            stack.field_77990_d = (NBTTagCompound)this.nbt.func_74737_b();
        }
        return stack;
    }
}

