/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.items;

import com.gtnewhorizons.gravisuiteneo.GraviSuiteNeoRegistry;
import com.gtnewhorizons.gravisuiteneo.client.ICustomItemBars;
import com.gtnewhorizons.gravisuiteneo.common.EntityPlasmaBallMKII;
import com.gtnewhorizons.gravisuiteneo.common.Properties;
import com.gtnewhorizons.gravisuiteneo.inventory.InventoryItem;
import com.gtnewhorizons.gravisuiteneo.items.ItemPlasmaCell;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.GraviSuite;
import gravisuite.ServerProxy;
import ic2.api.item.ElectricItem;
import java.awt.Color;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ItemPlasmaLauncher
extends Item
implements ICustomItemBars {
    public static int powerPerMaxShot;
    private static final int PLASMA_AMOUNT_PER_SHOT = 1000;

    public ItemPlasmaLauncher() {
        powerPerMaxShot = Properties.ElectricPresets.PlasmaLauncher.energyPerOperation;
        this.func_77637_a(GraviSuiteNeoRegistry.graviCreativeTab);
        this.func_77625_d(1);
        this.func_111206_d("gravisuiteneo:PlasmaCannon_0");
        this.func_77655_b("plasmaLauncher");
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 1;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K && player.func_70093_af()) {
            player.openGui((Object)GraviSuite.instance, 5, worldIn, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return itemStackIn;
        }
        ItemStack ammoStack = this.getAmmunition(itemStackIn);
        if (ammoStack == null) {
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.plasmaLauncher.noPlasmaCellFound")));
            return itemStackIn;
        }
        FluidStack plasma = ((ItemPlasmaCell)GraviSuiteNeoRegistry.itemPlasmaCell).getFluid(ammoStack);
        if (plasma == null) {
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.plasmaLauncher.PlasmaCellEmpty")));
            return itemStackIn;
        }
        if (plasma.amount < 1000) {
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.plasmaLauncher.NotEnoughPlasma")));
            return itemStackIn;
        }
        ((ItemPlasmaCell)GraviSuiteNeoRegistry.itemPlasmaCell).drain(ammoStack, 1000, true);
        float plasmaEnergyAmount = GraviSuiteNeoRegistry.getPlasmaEfficiency(plasma) / 100.0f;
        plasmaEnergyAmount = Math.min(100.0f, plasmaEnergyAmount);
        if (ElectricItem.manager.canUse(ammoStack, (double)powerPerMaxShot)) {
            EntityPlasmaBallMKII plasmaBall = new EntityPlasmaBallMKII(worldIn, (EntityLivingBase)player, plasmaEnergyAmount, 2);
            if (!worldIn.field_72995_K) {
                ElectricItem.manager.discharge(ammoStack, (double)powerPerMaxShot, 99, true, false, false);
                worldIn.func_72838_d((Entity)plasmaBall);
                ItemPlasmaLauncher.notifyWorldPlasmaFired(player);
            }
            player.func_71038_i();
        } else {
            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"message.plasmaLauncher.noEnergy")));
        }
        return itemStackIn;
    }

    private static void notifyWorldPlasmaFired(EntityPlayer player) {
        player.field_70170_p.func_72956_a((Entity)player, "gravisuiteneo:plasmaFired", 1.25f, 1.0f);
    }

    public ItemStack getAmmunition(ItemStack itemStack) {
        ItemStack tReturn = null;
        InventoryItem invi = new InventoryItem(itemStack);
        ItemStack ammoStack = invi.func_70301_a(0);
        if (ammoStack != null) {
            tReturn = ammoStack;
        }
        return tReturn;
    }

    public boolean hasAmmunition(ItemStack itemStack) {
        return this.getAmmunition(itemStack) != null;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List tooltip, boolean advancedTooltips) {
        if (this.hasAmmunition(itemStack)) {
            tooltip.addAll(ItemPlasmaCell.getToolTipInfo(this.getAmmunition(itemStack)));
        } else {
            tooltip.add(StatCollector.func_74838_a((String)"message.plasmaLauncher.depleted"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.epic;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public int getDamage(ItemStack stack) {
        stack.func_77964_b(0);
        return 0;
    }

    @Override
    public int getNumBars(ItemStack itemStack) {
        return this.hasAmmunition(itemStack) ? 2 : 0;
    }

    @Override
    public Color getColorForMinValue(ItemStack itemStack, int barIndex) {
        return ((ICustomItemBars)GraviSuiteNeoRegistry.itemPlasmaCell).getColorForMinValue(this.getAmmunition(itemStack), barIndex);
    }

    @Override
    public Color getColorForMaxValue(ItemStack itemStack, int barIndex) {
        return ((ICustomItemBars)GraviSuiteNeoRegistry.itemPlasmaCell).getColorForMaxValue(this.getAmmunition(itemStack), barIndex);
    }

    @Override
    public double getMaxValue(ItemStack itemStack, int barIndex) {
        return ((ICustomItemBars)GraviSuiteNeoRegistry.itemPlasmaCell).getMaxValue(this.getAmmunition(itemStack), barIndex);
    }

    @Override
    public double getValueForBar(ItemStack itemStack, int barIndex) {
        return ((ICustomItemBars)GraviSuiteNeoRegistry.itemPlasmaCell).getValueForBar(this.getAmmunition(itemStack), barIndex);
    }

    @Override
    public ICustomItemBars.BarAlignment getBarAlignment() {
        return ((ICustomItemBars)GraviSuiteNeoRegistry.itemPlasmaCell).getBarAlignment();
    }

    @Override
    public int getBarThickness(ItemStack itemStack, int barIndex) {
        return ((ICustomItemBars)GraviSuiteNeoRegistry.itemPlasmaCell).getBarThickness(this.getAmmunition(itemStack), barIndex);
    }

    @Override
    public boolean getIsBarInverted(ItemStack itemStack, int barIndex) {
        return ((ICustomItemBars)GraviSuiteNeoRegistry.itemPlasmaCell).getIsBarInverted(this.getAmmunition(itemStack), barIndex);
    }
}

