/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.Tooltip;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.geometry.CraftGUIUtil;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.util.I18N;
import binnie.core.util.UniqueItemStackSet;
import binnie.extratrees.craftgui.ControlFluidDisplay;
import binnie.genetics.gui.AnalystPageProduce;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IChromosomeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class AnalystPageProducts
extends AnalystPageProduce {
    public AnalystPageProducts(IWidget parent, IArea area, IBee ind) {
        super(parent, area);
        this.setColor(0xCC3300);
        IBeeGenome genome = ind.getGenome();
        float speed = genome.getSpeed();
        float modeSpeed = Binnie.Genetics.getBeeRoot().getBeekeepingMode(BinnieCore.proxy.getWorld()).getBeeModifier().getProductionModifier(genome, 1.0f);
        int y = 4;
        new ControlTextCentered((IWidget)this, y, EnumChatFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        String alleleName = Binnie.Genetics.beeBreedingSystem.getAlleleName((IChromosomeType)EnumBeeChromosome.SPEED, ind.getGenome().getActiveAllele((IChromosomeType)EnumBeeChromosome.SPEED));
        new ControlTextCentered((IWidget)this, y += 12, EnumChatFormatting.ITALIC + I18N.localise("genetics.gui.analyst.produce.rate", alleleName)).setColor(this.getColor());
        y += 20;
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        UniqueItemStackSet productList = new UniqueItemStackSet();
        Map products = new HashMap();
        products.putAll(genome.getPrimary().getProductChances());
        products.putAll(genome.getSecondary().getProductChances());
        if (!products.isEmpty()) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.produce.natural")).setColor(this.getColor());
            y += 12;
            for (Map.Entry entry : products.entrySet()) {
                if (!productList.add(entry.getKey())) continue;
                refinedProducts.addAll(this.getAllProducts((ItemStack)entry.getKey()));
                this.createProductEntry((ItemStack)entry.getKey(), (Float)entry.getValue(), y, speed * modeSpeed);
                y += 18;
            }
            y += 12;
        }
        if (!(products = genome.getPrimary().getSpecialtyChances()).isEmpty()) {
            new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.produce.speciality")).setColor(this.getColor());
            y += 12;
            for (Map.Entry entry : products.entrySet()) {
                refinedProducts.addAll(this.getAllProducts((ItemStack)entry.getKey()));
                this.createProductEntry((ItemStack)entry.getKey(), (Float)entry.getValue(), y, speed * modeSpeed);
                y += 18;
            }
            y += 12;
        }
        new ControlTextCentered((IWidget)this, y, I18N.localise("genetics.gui.analyst.produce.refined")).setColor(this.getColor());
        y += 12;
        UniqueItemStackSet level2Products = new UniqueItemStackSet();
        for (Object stack : refinedProducts) {
            level2Products.addAll(this.getAllProducts((ItemStack)stack));
        }
        refinedProducts.addAll(level2Products);
        level2Products = new UniqueItemStackSet();
        for (Object stack : refinedProducts) {
            level2Products.addAll(this.getAllProducts((ItemStack)stack));
        }
        refinedProducts.addAll(level2Products);
        ArrayList<FluidStack> allFluids = new ArrayList<FluidStack>();
        for (ItemStack stack2 : refinedProducts) {
            for (FluidStack addition : this.getAllFluids(stack2)) {
                boolean alreadyIn = false;
                for (FluidStack existing : allFluids) {
                    if (!existing.isFluidEqual(addition)) continue;
                    alreadyIn = true;
                }
                if (alreadyIn) continue;
                allFluids.add(addition);
            }
        }
        int maxBiomePerLine = (int)((this.w() + 2.0f - 16.0f) / 18.0f);
        float biomeListX = (this.w() - (float)(Math.min(maxBiomePerLine, allFluids.size() + refinedProducts.size()) * 18 - 2)) / 2.0f;
        int dx = 0;
        int dy = 0;
        for (ItemStack soilStack : refinedProducts) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            ControlItemDisplay display = new ControlItemDisplay(this, biomeListX + (float)dx, y + dy);
            display.setItemStack(soilStack);
            display.setTooltip();
            dx += 18;
        }
        for (FluidStack soilStack2 : allFluids) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            ItemStack container = null;
            for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (data.emptyContainer.func_77969_a(new ItemStack(Items.field_151069_bo)) && data.fluid.isFluidEqual(soilStack2)) {
                    container = data.filledContainer;
                    break;
                }
                if (data.emptyContainer.func_77969_a(new ItemStack(Items.field_151133_ar)) && data.fluid.isFluidEqual(soilStack2)) {
                    container = data.filledContainer;
                    break;
                }
                if (!data.fluid.isFluidEqual(soilStack2)) continue;
                container = data.filledContainer;
                break;
            }
            if (container == null) {
                ControlFluidDisplay display2 = new ControlFluidDisplay(this, biomeListX + (float)dx, y + dy);
                display2.setItemStack(soilStack2);
                display2.setTooltip();
            } else {
                ControlItemDisplay display3 = new ControlItemDisplay(this, biomeListX + (float)dx, y + dy);
                display3.setItemStack(container);
                display3.setTooltip();
            }
            dx += 18;
        }
        this.setSize(new IPoint(this.w(), y + dy + 18 + 8));
    }

    private void createProductEntry(final ItemStack key, Float value, int y, float speed) {
        ControlItemDisplay item = new ControlItemDisplay(this, 16.0f, (float)y){

            @Override
            public void getTooltip(Tooltip tooltip) {
                Collection<ItemStack> liquids;
                super.getTooltip(tooltip);
                Collection<ItemStack> products = AnalystPageProducts.this.getCentrifuge(key);
                if (!products.isEmpty()) {
                    tooltip.add(I18N.localise("genetics.gui.analyst.produce.centrifuge") + " ");
                    for (ItemStack prod : products) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        prod.func_77955_b(nbt);
                        tooltip.add(prod, prod.func_82833_r());
                    }
                }
                if (!(liquids = AnalystPageProducts.this.getSqueezer(key)).isEmpty()) {
                    tooltip.add(I18N.localise("genetics.gui.analyst.produce.squeezes") + " ");
                    for (ItemStack prod2 : liquids) {
                        NBTTagCompound nbt2 = new NBTTagCompound();
                        prod2.func_77955_b(nbt2);
                        tooltip.add(prod2, prod2.func_82833_r());
                    }
                }
            }
        };
        item.setTooltip();
        ControlTextCentered textWidget = new ControlTextCentered((IWidget)this, y + 4, "");
        textWidget.setColor(this.getColor());
        CraftGUIUtil.moveWidget(textWidget, new IPoint(12.0f, 0.0f));
        item.setItemStack(key);
        float time = (int)(550.0f / (speed * value.floatValue()));
        textWidget.setValue(I18N.localise("genetics.gui.analyst.produce.everyTime", this.getTimeString(time)));
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.produce");
    }
}

