/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.utils;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;

public class GSONUtils {
    private static final ExclusionStrategy GSONStrategy = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(SkipGSON.class) != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };
    private static final JsonSerializer<NBTTagCompound> NBTTagCompoundSerializer = (src, typeOfSrc, context) -> {
        try {
            JsonArray array = new JsonArray();
            for (byte b : CompressedStreamTools.func_74798_a((NBTTagCompound)src)) {
                array.add((JsonElement)new JsonPrimitive((Number)b));
            }
            return array;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    private static final JsonDeserializer<NBTTagCompound> NBTTagCompoundDeserializer = (json, typeOfT, context) -> {
        try {
            if (!(json instanceof JsonArray)) {
                return null;
            }
            byte[] bytes = new byte[((JsonArray)json).size()];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = ((JsonArray)json).get(i).getAsByte();
            }
            return CompressedStreamTools.func_152457_a((byte[])bytes, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    };
    public static final GsonBuilder GSON_BUILDER = new GsonBuilder().addSerializationExclusionStrategy(GSONStrategy).addDeserializationExclusionStrategy(GSONStrategy).registerTypeAdapter(NBTTagCompound.class, NBTTagCompoundDeserializer).registerTypeAdapter(NBTTagCompound.class, NBTTagCompoundSerializer).serializeNulls();
    public static final GsonBuilder GSON_BUILDER_PRETTY = new GsonBuilder().addSerializationExclusionStrategy(GSONStrategy).addDeserializationExclusionStrategy(GSONStrategy).registerTypeAdapter(NBTTagCompound.class, NBTTagCompoundDeserializer).registerTypeAdapter(NBTTagCompound.class, NBTTagCompoundSerializer).serializeNulls().setPrettyPrinting();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SkipGSON {
    }
}

