/*
 * Decompiled with CFR 0.152.
 */
package kubatech.commands;

import com.google.common.io.Files;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class CommandBees
extends CommandBase {
    public String func_71517_b() {
        return "bees";
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return "bees";
    }

    public int func_82362_a() {
        return 4;
    }

    public void func_71515_b(ICommandSender p_71515_1_, String[] p_71515_2_) {
        if (!Minecraft.func_71410_x().func_71356_B()) {
            p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "This command is single-player only!"));
            return;
        }
        try {
            File f = new File("bees.txt");
            BufferedWriter writer = Files.newWriter((File)f, (Charset)StandardCharsets.UTF_8);
            String delimer = ",";
            writer.write("Bee,CHANCE,OLD_0.6S_0UP,OLD_0.6S_8UP,OLD_1.7S_0UP,OLD_1.7S_8UP,NEW_0.6S_0UP_1T,NEW_0.6S_8UP_1T,NEW_1.7S_0UP_1T,NEW_1.7S_8UP_1T,NEW_1.7S_0UP_8T,NEW_1.7S_8UP_8T\n");
            ArrayList bees = BeeManager.beeRoot.getIndividualTemplates();
            for (IBee bee : bees) {
                StringBuilder b = new StringBuilder(bee.getDisplayName());
                b.append(",-,-,-,-,-,-,-,-,-,-\n");
                IBeeGenome genome = bee.getGenome();
                IAlleleBeeSpecies primary = genome.getPrimary();
                IAlleleBeeSpecies secondary = genome.getSecondary();
                primary.getProductChances().forEach((k, v) -> this.printData("[PRIMARY]", (ItemStack)k, v.floatValue(), delimer, b));
                secondary.getProductChances().forEach((k, v) -> this.printData("[SECONDARY]", (ItemStack)k, v.floatValue() / 2.0f, delimer, b));
                primary.getSpecialtyChances().forEach((k, v) -> this.printData("[SPECIALITY]", (ItemStack)k, v.floatValue(), delimer, b));
                writer.write(b.toString());
            }
            writer.flush();
            writer.close();
            p_71515_1_.func_145747_a((IChatComponent)new ChatComponentText(f.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void printData(String nameOfData, ItemStack k, float v, String delimer, StringBuilder b) {
        b.append(nameOfData);
        b.append(k.func_82833_r());
        b.append(delimer);
        b.append(this.format(v));
        b.append(delimer);
        b.append(this.format(this.productChanceOld(0, 0.6, v)));
        b.append(delimer);
        b.append(this.format(this.productChanceOld(8, 0.6, v)));
        b.append(delimer);
        b.append(this.format(this.productChanceOld(0, 1.7, v)));
        b.append(delimer);
        b.append(this.format(this.productChanceOld(8, 1.7, v)));
        b.append(delimer);
        b.append(this.format(this.productChanceNew(0, 0.6, v, 1)));
        b.append(delimer);
        b.append(this.format(this.productChanceNew(8, 0.6, v, 1)));
        b.append(delimer);
        b.append(this.format(this.productChanceNew(0, 1.7, v, 1)));
        b.append(delimer);
        b.append(this.format(this.productChanceNew(8, 1.7, v, 1)));
        b.append(delimer);
        b.append(this.format(this.productChanceNew(0, 1.7, v, 8)));
        b.append(delimer);
        b.append(this.format(this.productChanceNew(8, 1.7, v, 8)));
        b.append("\n");
    }

    private String format(double chance) {
        return String.format("%.2f%%", chance * 100.0);
    }

    private double productChanceNew(int upgradeCount, double beeSpeed, double chance, int t) {
        float productionModifier = (float)upgradeCount * 0.25f;
        return (float)(((double)(1.0f + (float)t / 6.0f) * Math.sqrt(chance *= 100.0) * 2.0 * (1.0 + beeSpeed) + Math.pow(productionModifier, Math.cbrt(chance)) - 3.0) / 100.0);
    }

    private double productChanceOld(int upgradeCount, double beeSpeed, double chance) {
        return chance * beeSpeed * Math.pow(1.2, upgradeCount);
    }
}

