/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import net.glease.tc4tweak.ConfigurationVersion;
import net.glease.tc4tweak.TC4Tweak;
import net.glease.tc4tweak.modules.FlushableCache;
import net.glease.tc4tweak.modules.researchBrowser.BrowserPaging;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;

public enum ConfigurationHandler {
    INSTANCE;

    private Configuration config;
    private boolean inverted;
    private int updateInterval;
    private boolean checkWorkbenchRecipes;
    private int arcaneCraftingHistorySize;
    private boolean addTooltip;
    private boolean mappingThreadNice;
    private float browserScale;
    private boolean limitBookSearchToCategory;
    private float nodeVisualSizeLimit;
    private boolean inferBrowserScale;
    private float inferBrowserScaleUpperBound;
    private float inferBrowserScaleLowerBound;
    private boolean inferBrowserScaleConsiderSearch;
    private boolean smallerJars;
    private boolean moreRandomizedLoot;
    private int browserHeight = 230;
    private int browserWidth = 256;
    private InfusionOreDictMode infusionOreDictMode = InfusionOreDictMode.Default;

    private ConfigurationHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    void init(File f) {
        this.config = new Configuration(f, ConfigurationVersion.latest().getVersionMarker());
        ConfigurationVersion.migrateToLatest(this.config);
        this.loadConfig(false);
        this.setLanguageKeys();
    }

    private void setLanguageKeys() {
        for (String categoryName : this.config.getCategoryNames()) {
            ConfigCategory category = this.config.getCategory(categoryName);
            category.setLanguageKey("tc4tweaks.config." + categoryName);
            for (Map.Entry entry : category.entrySet()) {
                ((Property)entry.getValue()).setLanguageKey(String.format("%s.%s", category.getLanguagekey(), entry.getKey()));
            }
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.modID.equals("tc4tweak")) {
            this.loadConfig(true);
            FlushableCache.enableAll(false);
        }
    }

    private void loadConfig(boolean send) {
        this.checkWorkbenchRecipes = this.config.getBoolean("checkWorkbenchRecipes", "general", true, "When false, Arcane Workbench will not perform vanilla crafting bench recipes. Arcane Workbench GUI will behave slightly awkwardly if the client has it false but not on server, but nothing would be broken.");
        this.arcaneCraftingHistorySize = this.config.getInt("arcaneCraftingHistorySize", "general", 16, 0, 256, "The maximum size of arcane crafting cache. 0 will effectively turn off the cache. It is suggested to keep a size of at least 1 to ensure shift crafting does not lag the server.");
        this.inverted = this.config.getBoolean("inverted", "client", false, "Flip it if you find the scrolling unintuitive");
        this.updateInterval = this.config.getInt("updateInterval", "client", 4, 0, 40, "How often should Arcane Workbench update displayed crafting result. Unit is in game ticks.");
        this.addTooltip = this.config.getBoolean("addTooltip", "client", true, "If false, no tooltip will be added.");
        int mappingThreadNiceType = this.config.getInt("mappingThreadNiceType", "client", 0, 0, 2, "Whether to adjust mapping thread priority. 0 means auto. 1 means force enable. 2 means force disable.");
        switch (mappingThreadNiceType) {
            case 1: {
                this.mappingThreadNice = true;
                break;
            }
            case 2: {
                this.mappingThreadNice = false;
                break;
            }
            default: {
                this.mappingThreadNice = Runtime.getRuntime().availableProcessors() < 3;
            }
        }
        this.browserScale = this.config.getFloat("scale", "client.browser_scale", 1.0f, 1.0f, 4.0f, "Tweak the size of the book gui. No longer works if inferBrowserScale is set to true.");
        this.limitBookSearchToCategory = this.config.getBoolean("limitBookSearchToCategory", "client", false, "Whether the book gui search should search current tab only.");
        this.nodeVisualSizeLimit = this.config.getFloat("limitOversizedNodeRender", "client", 1.0f, 0.5f, 1.0E10f, "The upper limit on how big nodes can be rendered. This is purely a visual thing and will not affect how big your node can actually grow. Setting a value like 10000.0 will effectively turn off this functionality, i.e. not limit the rendered size.");
        this.inferBrowserScale = this.config.getBoolean("infer", "client.browser_scale", true, "Tweak the size of the book gui based on screen size automatically. The value of browserScale set manually will not function any more.");
        this.inferBrowserScaleUpperBound = this.config.getFloat("maximum", "client.browser_scale", 4.0f, 1.0f, 16.0f, "The minimum inferred scale. Cannot be smaller than the value of inferBrowserScaleLowerBound. This shouldn't be too high as a huge browser would be rendered with really poor image quality.");
        this.inferBrowserScaleLowerBound = this.config.getFloat("minimum", "client.browser_scale", 1.0f, 1.0f, 16.0f, "The maximum inferred scale. Cannot be bigger than the value of inferBrowserScaleUpperBound.");
        this.inferBrowserScaleConsiderSearch = this.config.getBoolean("considerSearchArea", "client.browser_scale", true, "The search result area, even if it's not disabled, will be considered while inferring browserScale.");
        this.smallerJars = this.config.getBoolean("smallerJars", "general", FMLLaunchHandler.side().isServer(), "If true, jars (brain in jar, essentia jars, etc) will have a collision box the same as block outline. Otherwise it will have a collision box of 1x1x1, which is the vanilla tc4 behavior.");
        this.moreRandomizedLoot = this.config.getBoolean("moreRandomizedLoot", "general", true, "If true, enchanted books will have randomized enchantment and vis stone will have different vis stored even without server restart.");
        this.infusionOreDictMode = InfusionOreDictMode.get(this.config.getString("infusionOreDictMode", "general", this.infusionOreDictMode.name(), "Select the infusion oredict mode. Default: vanilla TC4 behavior. Strict: all oredict names must match to count as oredict substitute. Relaxed: oredict names needs only overlaps to count as oredict substitute. None: no oredict substitute at all.", (String[])Arrays.stream(InfusionOreDictMode.values()).map(Enum::name).toArray(String[]::new)));
        if (this.inferBrowserScaleLowerBound > this.inferBrowserScaleUpperBound) {
            this.config.getCategory("client").get("inferBrowserScaleLowerBound").set((double)this.inferBrowserScaleUpperBound);
        }
        this.browserWidth = (int)(this.browserScale * 256.0f);
        this.browserHeight = (int)(this.browserScale * 230.0f);
        TC4Tweak.INSTANCE.setAllowAll(true);
        if (send) {
            TC4Tweak.INSTANCE.detectAndSendConfigChanges();
            BrowserPaging.flushCache();
        }
        this.config.save();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean isCheckWorkbenchRecipes() {
        return this.checkWorkbenchRecipes;
    }

    public int getArcaneCraftingHistorySize() {
        return this.arcaneCraftingHistorySize;
    }

    public boolean isAddTooltip() {
        return this.addTooltip;
    }

    public boolean isMappingThreadNice() {
        return this.mappingThreadNice;
    }

    public float getBrowserScale() {
        return this.browserScale;
    }

    public void setBrowserScale(float browserScale) {
        this.browserScale = Math.max(Math.min(browserScale, this.inferBrowserScaleUpperBound), this.inferBrowserScaleLowerBound);
        this.browserWidth = (int)(browserScale * 256.0f);
        this.browserHeight = (int)(browserScale * 230.0f);
    }

    public int getBrowserHeight() {
        return this.browserHeight;
    }

    public int getBrowserWidth() {
        return this.browserWidth;
    }

    public boolean isLimitBookSearchToCategory() {
        return this.limitBookSearchToCategory;
    }

    public float getNodeVisualSizeLimit() {
        return this.nodeVisualSizeLimit;
    }

    public boolean isInferBrowserScale() {
        return this.inferBrowserScale;
    }

    public boolean isInferBrowserScaleConsiderSearch() {
        return this.inferBrowserScaleConsiderSearch;
    }

    public boolean isSmallerJars() {
        return this.smallerJars;
    }

    public boolean isMoreRandomizedLoot() {
        return this.moreRandomizedLoot;
    }

    public InfusionOreDictMode getInfusionOreDictMode() {
        return InfusionOreDictMode.Default;
    }

    public static enum InfusionOreDictMode {
        Default{

            @Override
            public boolean test(ItemStack playerInput, ItemStack recipeSpec) {
                int od = OreDictionary.getOreID((ItemStack)playerInput);
                if (od == -1) {
                    return false;
                }
                ItemStack[] ores = OreDictionary.getOres((Integer)od).toArray(new ItemStack[0]);
                return ThaumcraftApiHelper.containsMatch((boolean)false, (ItemStack[])new ItemStack[]{recipeSpec}, (ItemStack[])ores);
            }
        }
        ,
        Strict{

            @Override
            public boolean test(ItemStack playerInput, ItemStack recipeSpec) {
                return new TIntHashSet(OreDictionary.getOreIDs((ItemStack)playerInput)).equals((Object)new TIntHashSet(OreDictionary.getOreIDs((ItemStack)recipeSpec)));
            }
        }
        ,
        Relaxed{

            @Override
            public boolean test(ItemStack playerInput, ItemStack recipeSpec) {
                TIntHashSet set = new TIntHashSet(OreDictionary.getOreIDs((ItemStack)playerInput));
                for (int i : OreDictionary.getOreIDs((ItemStack)recipeSpec)) {
                    if (!set.contains(i)) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        None{

            @Override
            public boolean test(ItemStack playerInput, ItemStack recipeSpec) {
                return false;
            }
        };


        public abstract boolean test(ItemStack var1, ItemStack var2);

        public static InfusionOreDictMode get(String name) {
            for (InfusionOreDictMode value : InfusionOreDictMode.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            return Default;
        }
    }
}

