/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.glease.tc4tweak.asm.AIItemPickupVisitor;
import net.glease.tc4tweak.asm.AddHandleMouseInputVisitor;
import net.glease.tc4tweak.asm.AddOnDataPacketMarkBlockForRenderUpdateVisitor;
import net.glease.tc4tweak.asm.BlockFluxGasVisitor;
import net.glease.tc4tweak.asm.BlockJarVisitor;
import net.glease.tc4tweak.asm.BlockMetalDeviceVisitor;
import net.glease.tc4tweak.asm.CellLocVisitor;
import net.glease.tc4tweak.asm.ContainerArcaneWorkbenchVisitor;
import net.glease.tc4tweak.asm.FXSonicVisitor;
import net.glease.tc4tweak.asm.GuiResearchBrowserVisitor;
import net.glease.tc4tweak.asm.GuiResearchRecipeVisitor;
import net.glease.tc4tweak.asm.InfusionRecipeVisitor;
import net.glease.tc4tweak.asm.ItemElementalShovelVisitor;
import net.glease.tc4tweak.asm.ItemNodeRendererVisitor;
import net.glease.tc4tweak.asm.ItemWandCastingVisitor;
import net.glease.tc4tweak.asm.LoadingPlugin;
import net.glease.tc4tweak.asm.MappingThreadVisitor;
import net.glease.tc4tweak.asm.MazeHandlerVisitor;
import net.glease.tc4tweak.asm.NodeLikeRendererVisitor;
import net.glease.tc4tweak.asm.PacketAspectCombinationToServerVisitor;
import net.glease.tc4tweak.asm.PacketPlayerCompleteToServerVisitor;
import net.glease.tc4tweak.asm.ResearchCategoriesVisitor;
import net.glease.tc4tweak.asm.ScanManagerVisitor;
import net.glease.tc4tweak.asm.TESRGetBlockTypeNullSafetyVisitor;
import net.glease.tc4tweak.asm.ThaumcraftApiVisitor;
import net.glease.tc4tweak.asm.ThaumcraftCraftingManagerVisitor;
import net.glease.tc4tweak.asm.ThaumcraftVisitor;
import net.glease.tc4tweak.asm.TileHoleVisitor;
import net.glease.tc4tweak.asm.TileInfusionMatrixVisitor;
import net.glease.tc4tweak.asm.TileMagicWorkbenchVisitor;
import net.glease.tc4tweak.asm.TransformerFactory;
import net.glease.tc4tweak.asm.UtilsFXVisitor;
import net.glease.tc4tweak.asm.UtilsVisitor;
import net.glease.tc4tweak.asm.VisNetHandlerVisitor;
import net.minecraft.crash.CrashReport;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.ReportedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.TraceClassVisitor;

public class TC4Transformer
implements IClassTransformer {
    static final Logger log = LogManager.getLogger((String)"TC4TweakTransformer");
    private static final boolean DEBUG = Boolean.getBoolean("glease.debugasm");
    private static final ConcurrentMap<String, Integer> transformCounts = new ConcurrentHashMap<String, Integer>();
    private final Map<String, TransformerFactory> transformers = ImmutableMap.builder().put((Object)"com.kentington.thaumichorizons.client.renderer.tile.TileEtherealShardRender", (Object)NodeLikeRendererVisitor.createFactory(LoadingPlugin.dev ? "func_147500_a" : "renderTileEntityAt")).put((Object)"makeo.gadomancy.client.renderers.tile", (Object)NodeLikeRendererVisitor.createFactory("renderNode")).put((Object)"thaumcraft.api.visnet.VisNetHandler", (Object)new TransformerFactory(VisNetHandlerVisitor::new)).put((Object)"thaumcraft.api.crafting.InfusionRecipe", (Object)new TransformerFactory(InfusionRecipeVisitor::new)).put((Object)"thaumcraft.client.gui.GuiResearchBrowser", (Object)new TransformerFactory(GuiResearchBrowserVisitor::new, Side.CLIENT)).put((Object)"thaumcraft.client.gui.GuiResearchRecipe", (Object)new TransformerFactory(GuiResearchRecipeVisitor::new, Side.CLIENT)).put((Object)"thaumcraft.client.gui.GuiResearchTable", (Object)new TransformerFactory(AddHandleMouseInputVisitor::new, Side.CLIENT)).put((Object)"thaumcraft.client.gui.MappingThread", (Object)new TransformerFactory(MappingThreadVisitor::new, Side.CLIENT)).put((Object)"thaumcraft.client.lib.UtilsFX", (Object)new TransformerFactory(UtilsFXVisitor::new, Side.CLIENT)).put((Object)"thaumcraft.client.renderers.tile.TileAlchemyFurnaceAdvancedRenderer", (Object)TESRGetBlockTypeNullSafetyVisitor.FACTORY).put((Object)"thaumcraft.client.renderers.tile.TileChestHungryRenderer", (Object)TESRGetBlockTypeNullSafetyVisitor.FACTORY).put((Object)"thaumcraft.client.renderers.tile.TileEldritchCapRenderer", (Object)TESRGetBlockTypeNullSafetyVisitor.FACTORY).put((Object)"thaumcraft.client.renderers.tile.TileEldritchObeliskRenderer", (Object)TESRGetBlockTypeNullSafetyVisitor.FACTORY).put((Object)"thaumcraft.client.renderers.tile.TileManaPodRenderer", (Object)TESRGetBlockTypeNullSafetyVisitor.FACTORY).put((Object)"thaumcraft.client.renderers.tile.TileNodeConverterRenderer", (Object)TESRGetBlockTypeNullSafetyVisitor.FACTORY).put((Object)"thaumcraft.client.renderers.tile.TileNodeStabilizerRenderer", (Object)TESRGetBlockTypeNullSafetyVisitor.FACTORY).put((Object)"thaumcraft.client.renderers.tile.TileNodeRenderer", (Object)NodeLikeRendererVisitor.createFactory("renderNode")).put((Object)"thaumcraft.client.renderers.tile.ItemNodeRenderer", (Object)new TransformerFactory(ItemNodeRendererVisitor::new, Side.CLIENT)).put((Object)"thaumcraft.common.tiles.TileMagicWorkbench", (Object)new TransformerFactory(TileMagicWorkbenchVisitor::new, Side.CLIENT)).put((Object)"thaumcraft.client.fx.other.FXSonic", (Object)new TransformerFactory(FXSonicVisitor::new, Side.CLIENT)).put((Object)"thaumcraft.api.research.ResearchCategories", (Object)new TransformerFactory(ResearchCategoriesVisitor::new)).put((Object)"thaumcraft.api.ThaumcraftApi", (Object)new TransformerFactory(ThaumcraftApiVisitor::new)).put((Object)"thaumcraft.common.blocks.BlockFluxGas", (Object)new TransformerFactory(BlockFluxGasVisitor::new)).put((Object)"thaumcraft.common.blocks.BlockJar", (Object)new TransformerFactory(BlockJarVisitor::new)).put((Object)"thaumcraft.common.blocks.BlockMetalDevice", (Object)new TransformerFactory(BlockMetalDeviceVisitor::new)).put((Object)"thaumcraft.common.container.ContainerArcaneWorkbench", (Object)new TransformerFactory(ContainerArcaneWorkbenchVisitor::new)).put((Object)"thaumcraft.common.entities.ai.inventory.AIItemPickup", (Object)new TransformerFactory(AIItemPickupVisitor::new)).put((Object)"thaumcraft.common.items.equipment.ItemElementalShovel", (Object)new TransformerFactory(ItemElementalShovelVisitor::new, true)).put((Object)"thaumcraft.common.items.wands.ItemWandCasting", (Object)new TransformerFactory(ItemWandCastingVisitor::new, true)).put((Object)"thaumcraft.common.lib.crafting.ThaumcraftCraftingManager", (Object)new TransformerFactory(ThaumcraftCraftingManagerVisitor::new)).put((Object)"thaumcraft.common.lib.network.playerdata.PacketAspectCombinationToServer", (Object)new TransformerFactory(PacketAspectCombinationToServerVisitor::new)).put((Object)"thaumcraft.common.lib.network.playerdata.PacketPlayerCompleteToServer", (Object)new TransformerFactory(PacketPlayerCompleteToServerVisitor::new)).put((Object)"thaumcraft.common.lib.research.ScanManager", (Object)new TransformerFactory(ScanManagerVisitor::new){

        @Override
        public boolean isInactive() {
            return super.isInactive() || LoadingPlugin.gt6;
        }
    }).put((Object)"thaumcraft.common.lib.utils.Utils", (Object)new TransformerFactory(UtilsVisitor::new)).put((Object)"thaumcraft.common.lib.world.dim.CellLoc", (Object)new TransformerFactory(CellLocVisitor::new)).put((Object)"thaumcraft.common.lib.world.dim.MazeHandler", (Object)new TransformerFactory(MazeHandlerVisitor::new)).put((Object)"thaumcraft.common.tiles.TileInfusionMatrix", (Object)new TransformerFactory(TileInfusionMatrixVisitor::new)).put((Object)"thaumcraft.common.tiles.TileHole", (Object)new TransformerFactory(TileHoleVisitor::new)).put((Object)"thaumcraft.common.tiles.TileTube", (Object)new TransformerFactory(AddOnDataPacketMarkBlockForRenderUpdateVisitor::new)).put((Object)"thaumcraft.common.tiles.TileJarFillable", (Object)new TransformerFactory(AddOnDataPacketMarkBlockForRenderUpdateVisitor::new)).put((Object)"thaumcraft.common.Thaumcraft", (Object)new TransformerFactory(ThaumcraftVisitor::new)).build();

    static void catching(Exception e) {
        Object exception;
        log.fatal("Something went very wrong with class transforming! Aborting!!!", (Throwable)e);
        try {
            exception = new ReportedException(CrashReport.func_85055_a((Throwable)e, (String)"Transforming class"));
        }
        catch (Throwable e2) {
            exception = new RuntimeException("Transforming class", e);
        }
        throw exception;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        TransformerFactory factory = this.transformers.get(name);
        if (factory == null || factory.isInactive()) {
            return basicClass;
        }
        log.info("Transforming class {}", new Object[]{name});
        ClassReader cr = new ClassReader(basicClass);
        ClassWriter cw = new ClassWriter(factory.isExpandFrames() ? 2 : 0);
        byte[] transformedBytes = null;
        if (DEBUG) {
            int curCount = transformCounts.compute(transformedName, (k, v) -> v == null ? 0 : v + 1);
            String infix = curCount == 0 ? "" : "_" + curCount;
            try (PrintWriter origOut = new PrintWriter(new File(LoadingPlugin.debugOutputDir, name + infix + "_orig.txt"), "UTF-8");
                 PrintWriter tranOut = new PrintWriter(new File(LoadingPlugin.debugOutputDir, name + infix + "_tran.txt"), "UTF-8");){
                cr.accept((ClassVisitor)new TraceClassVisitor(factory.apply(327680, (ClassVisitor)new TraceClassVisitor((ClassVisitor)cw, tranOut)), origOut), factory.isExpandFrames() ? 4 : 0);
                transformedBytes = cw.toByteArray();
            }
            catch (Exception e) {
                log.warn("Unable to transform with debug output on. Now retrying without debug output.", (Throwable)e);
            }
        }
        if (transformedBytes == null || transformedBytes.length == 0) {
            try {
                cr.accept(factory.apply(327680, (ClassVisitor)cw), factory.isExpandFrames() ? 4 : 0);
                transformedBytes = cw.toByteArray();
            }
            catch (Exception e) {
                TC4Transformer.catching(e);
            }
        }
        if (transformedBytes == null || transformedBytes.length == 0) {
            if (DEBUG) {
                TC4Transformer.catching(new RuntimeException("Null or empty byte array created. This will not work well!"));
            } else {
                log.fatal("Null or empty byte array created. Transforming will rollback as a last effort attempt to make things work! However features will not function!");
                return basicClass;
            }
        }
        return transformedBytes;
    }
}

