/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.world.schematic;

import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.reference.Reference;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public final class SchematicUtil {
    public static NBTTagCompound readTagCompoundFromFile(File file) throws IOException {
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        }
        catch (Exception ex) {
            Reference.logger.warn("Failed compressed read, trying normal read...", (Throwable)ex);
            return CompressedStreamTools.func_74797_a((File)file);
        }
    }

    public static ItemStack getIconFromName(String iconName) {
        ItemStack icon;
        String name = "";
        int damage = 0;
        String[] parts = iconName.split(",");
        if (parts.length >= 1) {
            name = parts[0];
            if (parts.length >= 2) {
                try {
                    damage = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((icon = new ItemStack((Block)GameData.getBlockRegistry().func_82594_a(name), 1, damage)).func_77973_b() != null) {
            return icon;
        }
        icon = new ItemStack((Item)GameData.getItemRegistry().func_82594_a(name), 1, damage);
        if (icon.func_77973_b() != null) {
            return icon;
        }
        return SchematicWorld.DEFAULT_ICON.func_77946_l();
    }

    public static ItemStack getIconFromNBT(NBTTagCompound tagCompound) {
        ItemStack icon = SchematicWorld.DEFAULT_ICON.func_77946_l();
        if (tagCompound != null && tagCompound.func_74764_b("Icon")) {
            icon.func_77963_c(tagCompound.func_74775_l("Icon"));
            if (icon.func_77973_b() == null) {
                icon = SchematicWorld.DEFAULT_ICON.func_77946_l();
            }
        }
        return icon;
    }

    public static ItemStack getIconFromFile(File file) {
        try {
            return SchematicUtil.getIconFromNBT(SchematicUtil.readTagCompoundFromFile(file));
        }
        catch (Exception e) {
            Reference.logger.error("Failed to read schematic icon!", (Throwable)e);
            return SchematicWorld.DEFAULT_ICON.func_77946_l();
        }
    }
}

