/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import twilightforest.TFGenericPacketHandler;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.block.TFBlocks;
import twilightforest.item.ItemTFOreMagnet;
import twilightforest.item.TFItems;

public class BlockTFMagicLogSpecial
extends BlockTFMagicLog {
    protected BlockTFMagicLogSpecial() {
        this.func_149647_a(TFItems.creativeTab);
    }

    public int func_149738_a(World world) {
        return 20;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    @Override
    public Item func_149650_a(int par1, Random rand, int par3) {
        return Item.func_150898_a((Block)TFBlocks.magicLog);
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        IIcon iIcon;
        int orient = meta & 0xC;
        int woodType = meta & 3;
        if (orient == 12) {
            IIcon iIcon2;
            switch (woodType) {
                default: {
                    if (side == 1 || side == 0) {
                        iIcon2 = SPR_TIMETOP;
                        break;
                    }
                    iIcon2 = SPR_TIMECLOCKOFF;
                    break;
                }
                case 1: {
                    if (side == 1 || side == 0) {
                        iIcon2 = SPR_TRANSTOP;
                        break;
                    }
                    iIcon2 = SPR_TRANSHEARTOFF;
                    break;
                }
                case 2: {
                    if (side == 1 || side == 0) {
                        iIcon2 = SPR_MINETOP;
                        break;
                    }
                    iIcon2 = SPR_MINEGEMOFF;
                    break;
                }
                case 3: {
                    iIcon2 = side == 1 || side == 0 ? SPR_SORTTOP : SPR_SORTEYEOFF;
                }
            }
            return iIcon2;
        }
        switch (woodType) {
            default: {
                if (orient == 0 && (side == 1 || side == 0)) {
                    iIcon = SPR_TIMETOP;
                    break;
                }
                if (orient == 4 && (side == 5 || side == 4)) {
                    iIcon = SPR_TIMETOP;
                    break;
                }
                if (orient == 8 && (side == 2 || side == 3)) {
                    iIcon = SPR_TIMETOP;
                    break;
                }
                iIcon = SPR_TIMECLOCK;
                break;
            }
            case 1: {
                if (orient == 0 && (side == 1 || side == 0)) {
                    iIcon = SPR_TRANSTOP;
                    break;
                }
                if (orient == 4 && (side == 5 || side == 4)) {
                    iIcon = SPR_TRANSTOP;
                    break;
                }
                if (orient == 8 && (side == 2 || side == 3)) {
                    iIcon = SPR_TRANSTOP;
                    break;
                }
                iIcon = SPR_TRANSHEART;
                break;
            }
            case 2: {
                if (orient == 0 && (side == 1 || side == 0)) {
                    iIcon = SPR_MINETOP;
                    break;
                }
                if (orient == 4 && (side == 5 || side == 4)) {
                    iIcon = SPR_MINETOP;
                    break;
                }
                if (orient == 8 && (side == 2 || side == 3)) {
                    iIcon = SPR_MINETOP;
                    break;
                }
                iIcon = SPR_MINEGEM;
                break;
            }
            case 3: {
                iIcon = orient == 0 && (side == 1 || side == 0) ? SPR_SORTTOP : (orient == 4 && (side == 5 || side == 4) ? SPR_SORTTOP : (orient == 8 && (side == 2 || side == 3) ? SPR_SORTTOP : SPR_SORTEYE));
            }
        }
        return iIcon;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta = world.func_72805_g(x, y, z);
        if ((meta & 0xC) == 12) {
            return;
        }
        if (!world.field_72995_K) {
            switch (meta & 3) {
                case 0: {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.click", 0.1f, 0.5f);
                    this.doTreeOfTimeEffect(world, x, y, z, rand);
                    break;
                }
                case 1: {
                    this.doTreeOfTransformationEffect(world, x, y, z, rand);
                    break;
                }
                case 2: {
                    this.doMinersTreeEffect(world, x, y, z, rand);
                    break;
                }
                case 3: {
                    this.doSortingTreeEffect(world, x, y, z, rand);
                }
            }
        }
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int meta = world.func_72805_g(x, y, z);
        int orient = meta & 0xC;
        int woodType = meta & 3;
        if (orient == 0) {
            world.func_72921_c(x, y, z, woodType | 0xC, 3);
            return true;
        }
        if (orient == 12) {
            world.func_72921_c(x, y, z, woodType | 0, 3);
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
            return true;
        }
        return false;
    }

    private void doTreeOfTimeEffect(World world, int x, int y, int z, Random rand) {
        int numticks = 24 * this.func_149738_a(world);
        int successes = 0;
        for (int i = 0; i < numticks; ++i) {
            int dz;
            int dy;
            int dx = rand.nextInt(32) - 16;
            Block thereID = world.func_147439_a(x + dx, y + (dy = rand.nextInt(32) - 16), z + (dz = rand.nextInt(32) - 16));
            if (thereID == Blocks.field_150350_a || !thereID.func_149653_t()) continue;
            world.func_147464_a(x + dx, y + dy, z + dz, thereID, 20);
            thereID.func_149674_a(world, x + dx, y + dy, z + dz, rand);
            ++successes;
        }
    }

    private void doTreeOfTransformationEffect(World world, int x, int y, int z, Random rand) {
        for (int i = 0; i < 1; ++i) {
            BiomeGenBase biomeAt;
            int dx = rand.nextInt(32) - 16;
            int dz = rand.nextInt(32) - 16;
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "note.harp", 0.1f, rand.nextFloat() * 2.0f);
            if (!(Math.sqrt(dx * dx + dz * dz) < 16.0) || (biomeAt = world.func_72807_a(x + dx, z + dz)) == TFBiomeBase.enchantedForest) continue;
            Chunk chunkAt = world.func_72938_d(x + dx, z + dz);
            chunkAt.func_76605_m()[(z + dz & 0xF) << 4 | x + dx & 0xF] = (byte)TFBiomeBase.enchantedForest.field_76756_M;
            world.func_147471_g(x + dx, y, z + dz);
            if (!(world instanceof WorldServer)) continue;
            this.sendChangedBiome(world, x + dx, z + dz, chunkAt);
        }
    }

    private void sendChangedBiome(World world, int x, int z, Chunk chunkAt) {
        FMLProxyPacket message = TFGenericPacketHandler.makeBiomeChangePacket(x, z, (byte)TFBiomeBase.enchantedForest.field_76756_M);
        NetworkRegistry.TargetPoint targetPoint = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, 128.0, (double)z, 128.0);
        TwilightForestMod.genericChannel.sendToAllAround(message, targetPoint);
    }

    private void doMinersTreeEffect(World world, int x, int y, int z, Random rand) {
        int dz;
        int dy;
        int dx = rand.nextInt(64) - 32;
        int moved = ItemTFOreMagnet.doMagnet(world, x, y, z, x + dx, y + (dy = rand.nextInt(64) - 32), z + (dz = rand.nextInt(64) - 32));
        if (moved > 0) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.endermen.portal", 0.1f, 1.0f);
        }
    }

    private void doSortingTreeEffect(World world, int x, int y, int z, Random rand) {
        int slotNum;
        IInventory chest2;
        int i;
        int XSEARCH = 16;
        int YSEARCH = 16;
        int ZSEARCH = 16;
        ArrayList<IInventory> chests = new ArrayList<IInventory>();
        int itemCount = 0;
        for (int sx = x - XSEARCH; sx < x + XSEARCH; ++sx) {
            for (int sy = y - YSEARCH; sy < y + YSEARCH; ++sy) {
                for (int sz = z - ZSEARCH; sz < z + ZSEARCH; ++sz) {
                    IInventory thisChest;
                    if (world.func_147439_a(sx, sy, sz) != Blocks.field_150486_ae || (thisChest = Blocks.field_150486_ae.func_149951_m(world, sx, sy, sz)) == null || this.checkIfChestsContains(chests, (IInventory)world.func_147438_o(sx, sy, sz))) continue;
                    int itemsInChest = 0;
                    for (i = 0; i < thisChest.func_70302_i_(); ++i) {
                        if (thisChest.func_70301_a(i) == null) continue;
                        ++itemsInChest;
                        ++itemCount;
                    }
                    if (itemsInChest <= 0) continue;
                    chests.add(thisChest);
                }
            }
        }
        ItemStack beingSorted = null;
        int sortedChestNum = -1;
        int sortedSlotNum = -1;
        if (itemCount > 0) {
            int itemNumber = rand.nextInt(itemCount);
            int currentNumber = 0;
            for (i = 0; i < chests.size(); ++i) {
                chest2 = (IInventory)chests.get(i);
                for (slotNum = 0; slotNum < chest2.func_70302_i_(); ++slotNum) {
                    ItemStack currentItem = chest2.func_70301_a(slotNum);
                    if (currentItem == null || currentNumber++ != itemNumber) continue;
                    beingSorted = currentItem;
                    sortedChestNum = i;
                    sortedSlotNum = slotNum;
                }
            }
        }
        if (beingSorted != null) {
            int matchChestNum = -1;
            int matchCount = 0;
            for (int chestNum = 0; chestNum < chests.size(); ++chestNum) {
                chest2 = (IInventory)chests.get(chestNum);
                int currentChestMatches = 0;
                for (int slotNum2 = 0; slotNum2 < chest2.func_70302_i_(); ++slotNum2) {
                    ItemStack currentItem = chest2.func_70301_a(slotNum2);
                    if (currentItem == null || !this.isSortingMatch(beingSorted, currentItem)) continue;
                    currentChestMatches += currentItem.field_77994_a;
                }
                if (currentChestMatches <= matchCount) continue;
                matchCount = currentChestMatches;
                matchChestNum = chestNum;
            }
            if (matchChestNum >= 0 && matchChestNum != sortedChestNum) {
                IInventory moveChest = (IInventory)chests.get(matchChestNum);
                IInventory oldChest = (IInventory)chests.get(sortedChestNum);
                int moveSlot = this.getEmptySlotIn(moveChest);
                if (moveSlot >= 0) {
                    oldChest.func_70299_a(sortedSlotNum, null);
                    moveChest.func_70299_a(moveSlot, beingSorted);
                }
            }
            if (beingSorted.field_77994_a < beingSorted.func_77976_d()) {
                for (IInventory chest2 : chests) {
                    for (slotNum = 0; slotNum < chest2.func_70302_i_(); ++slotNum) {
                        ItemStack currentItem = chest2.func_70301_a(slotNum);
                        if (currentItem == null || currentItem == beingSorted || !beingSorted.func_77969_a(currentItem) || currentItem.field_77994_a > beingSorted.func_77976_d() - beingSorted.field_77994_a) continue;
                        chest2.func_70299_a(slotNum, null);
                        beingSorted.field_77994_a += currentItem.field_77994_a;
                        currentItem.field_77994_a = 0;
                    }
                }
            }
        }
    }

    private boolean isSortingMatch(ItemStack beingSorted, ItemStack currentItem) {
        return this.getCreativeTab(currentItem.func_77973_b()).equals(this.getCreativeTab(beingSorted.func_77973_b()));
    }

    private Object getCreativeTab(Item item) {
        try {
            return ObfuscationReflectionHelper.getPrivateValue(Item.class, (Object)item, (int)0);
        }
        catch (IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean checkIfChestsContains(ArrayList<IInventory> chests, IInventory testChest) {
        for (IInventory chest : chests) {
            if (chest.equals(testChest)) {
                return true;
            }
            if (!(chest instanceof InventoryLargeChest) || !((InventoryLargeChest)chest).func_90010_a(testChest)) continue;
            return true;
        }
        return false;
    }

    private int getEmptySlotIn(IInventory chest) {
        for (int i = 0; i < chest.func_70302_i_(); ++i) {
            if (chest.func_70301_a(i) != null) continue;
            return i;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return 15;
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        itemList.add(new ItemStack(item, 1, 0));
        itemList.add(new ItemStack(item, 1, 1));
        itemList.add(new ItemStack(item, 1, 2));
        itemList.add(new ItemStack(item, 1, 3));
    }
}

