/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.architecture.BaseBlock;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.EnumWorldBlockLayer;
import gcewing.architecture.IBlockState;
import gcewing.architecture.IProperty;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseBlockUtils {
    public static String getNameForBlock(Block block) {
        if (block != null) {
            return Block.field_149771_c.func_148750_c((Object)block).toString();
        }
        return "";
    }

    public static boolean blockIsGettingExternallyPowered(World world, BlockPos pos) {
        for (EnumFacing side : BaseUtils.facings) {
            if (!BaseBlockUtils.isPoweringSide(world, pos.offset(side), side)) continue;
            return true;
        }
        return false;
    }

    static boolean isPoweringSide(World world, BlockPos pos, EnumFacing side) {
        Block block = world.func_147439_a(pos.x, pos.y, pos.z);
        if (block.func_149709_b((IBlockAccess)world, pos.x, pos.y, pos.z, side.ordinal()) > 0) {
            return true;
        }
        if (block.shouldCheckWeakPower((IBlockAccess)world, pos.x, pos.y, pos.z, side.ordinal())) {
            for (EnumFacing side2 : BaseUtils.facings) {
                if (side2 == BaseUtils.oppositeFacing(side)) continue;
                BlockPos pos2 = pos.offset(side2);
                Block block2 = world.func_147439_a(pos2.x, pos2.y, pos2.z);
                if (block2.func_149748_c((IBlockAccess)world, pos2.x, pos2.y, pos2.z, side2.ordinal()) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        int meta = 0;
        if (stack.func_77973_b().func_77614_k()) {
            meta = stack.func_77973_b().func_77647_b(stack.func_77960_j());
        }
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int meta) {
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static int getMetaFromBlockState(IBlockState state) {
        if (state instanceof MetaBlockState) {
            return ((MetaBlockState)state).meta;
        }
        return ((BaseBlock)state.getBlock()).getMetaFromState(state);
    }

    public static Block getWorldBlock(IBlockAccess world, BlockPos pos) {
        return world.func_147439_a(pos.x, pos.y, pos.z);
    }

    public static IBlockState getWorldBlockState(IBlockAccess world, BlockPos pos) {
        Block block = world.func_147439_a(pos.x, pos.y, pos.z);
        int meta = world.func_72805_g(pos.x, pos.y, pos.z);
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static boolean setWorldBlockState(World world, BlockPos pos, IBlockState state, int flags) {
        Block block = state.getBlock();
        int meta = BaseBlockUtils.getMetaFromBlockState(state);
        return world.func_147465_d(pos.x, pos.y, pos.z, block, meta, flags);
    }

    public static void markWorldBlockForUpdate(World world, BlockPos pos) {
        world.func_147471_g(pos.x, pos.y, pos.z);
    }

    public static void notifyWorldNeighborsOfStateChange(World world, BlockPos pos, Block block) {
        world.func_147459_d(pos.x, pos.y, pos.z, block);
    }

    public static TileEntity getWorldTileEntity(IBlockAccess world, BlockPos pos) {
        return world.func_147438_o(pos.x, pos.y, pos.z);
    }

    public static World getTileEntityWorld(TileEntity te) {
        return te.func_145831_w();
    }

    public static BlockPos getTileEntityPos(TileEntity te) {
        return new BlockPos(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static boolean blockCanRenderInLayer(Block block, EnumWorldBlockLayer layer) {
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).canRenderInLayer(layer);
        }
        switch (layer) {
            case SOLID: {
                return block.canRenderInPass(0);
            }
            case TRANSLUCENT: {
                return block.canRenderInPass(1);
            }
        }
        return false;
    }

    public static IBlockState getDefaultBlockState(Block block) {
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getDefaultState();
        }
        return new MetaBlockState(block, 0);
    }

    public static void playWorldAuxSFX(World world, int fxId, BlockPos pos, IBlockState state) {
        Block block = state.getBlock();
        int meta = BaseBlockUtils.getMetaFromBlockState(state);
        int stateId = meta << 12 | Block.func_149682_b((Block)block);
        world.func_72926_e(fxId, pos.getX(), pos.getY(), pos.getZ(), stateId);
    }

    public static float getBlockHardness(Block block, World world, BlockPos pos) {
        return block.func_149712_f(world, pos.x, pos.y, pos.z);
    }

    public static String getBlockHarvestTool(IBlockState state) {
        Block block = state.getBlock();
        int meta = BaseBlockUtils.getMetaFromBlockState(state);
        return block.getHarvestTool(meta);
    }

    public static int getBlockHarvestLevel(IBlockState state) {
        Block block = state.getBlock();
        int meta = BaseBlockUtils.getMetaFromBlockState(state);
        return block.getHarvestLevel(meta);
    }

    public static float getPlayerBreakSpeed(EntityPlayer player, IBlockState state, BlockPos pos) {
        Block block = state.getBlock();
        int meta = BaseBlockUtils.getMetaFromBlockState(state);
        return player.getBreakSpeed(block, false, meta, pos.x, pos.y, pos.z);
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getSpriteForBlockState(IBlockState state) {
        if (state != null) {
            Block block = state.getBlock();
            int meta = BaseBlockUtils.getMetaFromBlockState(state);
            return block.func_149691_a(2, meta);
        }
        return null;
    }

    public static void spawnBlockStackAsEntity(World world, BlockPos pos, ItemStack stack) {
        float var6 = 0.7f;
        double var7 = (double)(world.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
        double var9 = (double)(world.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
        double var11 = (double)(world.field_73012_v.nextFloat() * var6) + (double)(1.0f - var6) * 0.5;
        EntityItem var13 = new EntityItem(world, (double)pos.x + var7, (double)pos.y + var9, (double)pos.z + var11, stack);
        var13.field_145804_b = 10;
        world.func_72838_d((Entity)var13);
    }

    public static ItemStack blockStackWithState(IBlockState state, int size) {
        Block block = state.getBlock();
        int meta = BaseBlockUtils.getMetaFromBlockState(state);
        return new ItemStack(block, size, meta);
    }

    protected static class MetaBlockState
    implements IBlockState {
        protected Block block;
        public int meta;

        public MetaBlockState(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }

        @Override
        public Collection<IProperty> getPropertyNames() {
            return null;
        }

        @Override
        public <T extends Comparable<T>> T getValue(IProperty<T> property) {
            return null;
        }

        @Override
        public <T extends Comparable<T>, V extends T> IBlockState withProperty(IProperty<T> property, V value) {
            return null;
        }

        @Override
        public <T extends Comparable<T>> IBlockState cycleProperty(IProperty<T> property) {
            return null;
        }

        @Override
        public ImmutableMap<IProperty, Comparable> getProperties() {
            return null;
        }

        @Override
        public Block getBlock() {
            return this.block;
        }
    }
}

