/*
 * Decompiled with CFR 0.152.
 */
package remoteio.client.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import remoteio.client.render.TessellatorCapture;
import remoteio.common.block.BlockRemoteInterface;
import remoteio.common.block.core.BlockIOCore;
import remoteio.common.lib.VisualState;
import remoteio.common.tile.TileRemoteInterface;

public class RenderBlockRemoteInterface
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        IIcon inactive = BlockIOCore.icons[0];
        Tessellator tessellator = Tessellator.field_78398_a;
        int oldUV = renderer.field_147867_u;
        renderer.field_147867_u = 3;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, -0.5, -0.5, -0.5, inactive);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, -0.5, -0.5, -0.5, inactive);
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, -0.5, -0.5, -0.5, inactive);
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, -0.5, -0.5, -0.5, inactive);
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, -0.5, -0.5, -0.5, inactive);
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, -0.5, -0.5, -0.5, inactive);
        tessellator.func_78381_a();
        renderer.field_147867_u = oldUV;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile.remotePosition == null || !tile.remotePosition.inWorld(tile.func_145831_w()) || tile.visualState != VisualState.CAMOUFLAGE_REMOTE) {
                renderer.func_147784_q(block, x, y, z);
            } else if (tile.remotePosition != null && tile.remotePosition.inWorld(tile.func_145831_w())) {
                Block remoteBlock = tile.remotePosition.getBlock();
                int rx = tile.remotePosition.x - x;
                int ry = tile.remotePosition.y - y;
                int rz = tile.remotePosition.z - z;
                Tessellator tessellator = Tessellator.field_78398_a;
                if (remoteBlock.func_149645_b() == 0) {
                    renderer.func_147784_q(block, x, y, z);
                } else if (remoteBlock.canRenderInPass(ForgeHooksClient.getWorldRenderPass())) {
                    TessellatorCapture.startCapturing();
                    TessellatorCapture.rotationAngle = 90 * tile.rotationY;
                    TessellatorCapture.offsetX = -(x + rx) - 1;
                    TessellatorCapture.offsetZ = -(z + rz) - 1;
                    tessellator.func_78372_c((float)(-rx), (float)(-ry), (float)(-rz));
                    renderer.func_147805_b(remoteBlock, tile.remotePosition.x, tile.remotePosition.y, tile.remotePosition.z);
                    tessellator.func_78372_c((float)rx, (float)ry, (float)rz);
                    TessellatorCapture.reset();
                }
            }
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockRemoteInterface.renderID;
    }
}

