/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.block;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import remoteio.common.RemoteIO;
import remoteio.common.block.core.BlockIOCore;
import remoteio.common.core.helper.RotationHelper;
import remoteio.common.lib.DimensionalCoords;
import remoteio.common.lib.VisualState;
import remoteio.common.tile.TileRemoteInterface;
import remoteio.common.tile.core.TileIOCore;

public class BlockRemoteInterface
extends BlockIOCore {
    public static int renderID;

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fx, float fy, float fz) {
        boolean result = super.func_149727_a(world, x, y, z, player, side, fx, fy, fz);
        if (result) {
            return true;
        }
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile.remotePosition != null && !player.func_70093_af() && tile.hasUpgradeChip(1)) {
            DimensionalCoords there = tile.remotePosition;
            RemoteIO.proxy.activateBlock(world, there.x, there.y, there.z, player, RotationHelper.getRotatedSide(0, tile.rotationY, 0, side), fx, fy, fz);
        }
        return true;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.remotePosition != null && tile.hasUpgradeChip(0)) {
            return tile.remotePosition.getBlock().func_149712_f(tile.remotePosition.getWorld(), tile.remotePosition.x, tile.remotePosition.y, tile.remotePosition.z);
        }
        return super.func_149712_f(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.remotePosition != null && tile.hasTransferChip(21)) {
            tile.remotePosition.getBlock().func_149695_a(tile.remotePosition.getWorld(), tile.remotePosition.x, tile.remotePosition.y, tile.remotePosition.z, block);
            tile.markForUpdate();
        } else {
            super.func_149695_a(world, x, y, z, block);
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.remotePosition != null && tile.hasUpgradeChip(0)) {
            return new ItemStack(tile.remotePosition.getBlock());
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.remotePosition != null && tile.hasUpgradeChip(0)) {
            return tile.remotePosition.getMeta();
        }
        return super.func_149643_k(world, x, y, z);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        DimensionalCoords there;
        Block remote;
        TileRemoteInterface tile;
        if (!world.field_72995_K && (tile = (TileRemoteInterface)world.func_147438_o(x, y, z)) != null && tile.hasTransferChip(21) && tile.remotePosition != null && (remote = (there = tile.remotePosition).getBlock()).func_149740_M()) {
            return remote.func_149736_g(there.getWorld(), there.x, there.y, there.z, RotationHelper.getRotatedSide(0, tile.rotationY, 0, side));
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        DimensionalCoords there;
        Block remote;
        TileRemoteInterface tile;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (tile = (TileRemoteInterface)world.func_147438_o(x, y, z)) != null && tile.hasTransferChip(21) && tile.remotePosition != null && (remote = (there = tile.remotePosition).getBlock()).func_149744_f()) {
            return remote.func_149709_b((IBlockAccess)there.getWorld(), there.x, there.y, there.z, RotationHelper.getRotatedSide(0, tile.rotationY, 0, side));
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        DimensionalCoords there;
        Block remote;
        TileRemoteInterface tile;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (tile = (TileRemoteInterface)world.func_147438_o(x, y, z)) != null && tile.hasTransferChip(21) && tile.remotePosition != null && (remote = (there = tile.remotePosition).getBlock()).func_149744_f()) {
            return remote.func_149748_c((IBlockAccess)there.getWorld(), there.x, there.y, there.z, RotationHelper.getRotatedSide(0, tile.rotationY, 0, side));
        }
        return 0;
    }

    @Override
    public int getGuiID() {
        return 0;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.visualState == VisualState.CAMOUFLAGE_REMOTE && tile.remotePosition != null) {
            Vec3 offsetEnd;
            int offsetZ;
            int offsetY;
            int offsetX;
            Vec3 offsetStart;
            DimensionalCoords there = tile.remotePosition;
            Block remote = there.getBlock(world);
            MovingObjectPosition mob = remote.func_149731_a(world, there.x, there.y, there.z, offsetStart = Vec3.func_72443_a((double)(start.field_72450_a + (double)(offsetX = there.x - x)), (double)(start.field_72448_b + (double)(offsetY = there.y - y)), (double)(start.field_72449_c + (double)(offsetZ = there.z - z))), offsetEnd = Vec3.func_72443_a((double)(end.field_72450_a + (double)offsetX), (double)(end.field_72448_b + (double)offsetY), (double)(end.field_72449_c + (double)offsetZ)));
            if (mob != null) {
                mob.field_72311_b -= offsetX;
                mob.field_72312_c -= offsetY;
                mob.field_72309_d -= offsetZ;
                mob.field_72307_f.field_72450_a -= (double)offsetX;
                mob.field_72307_f.field_72448_b -= (double)offsetY;
                mob.field_72307_f.field_72449_c -= (double)offsetZ;
            }
            return mob;
        }
        return super.func_149731_a(world, x, y, z, start, end);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.visualState == VisualState.CAMOUFLAGE_REMOTE && tile.remotePosition != null) {
            DimensionalCoords there = tile.remotePosition;
            Block remote = there.getBlock(world);
            int offsetX = there.x - x;
            int offsetY = there.y - y;
            int offsetZ = there.z - z;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            player.field_70169_q += (double)offsetX;
            player.field_70167_r += (double)offsetY;
            player.field_70166_s += (double)offsetZ;
            player.field_70165_t += (double)offsetX;
            player.field_70163_u += (double)offsetY;
            player.field_70161_v += (double)offsetZ;
            AxisAlignedBB aabb = remote.func_149633_g(world, there.x, there.y, there.z);
            player.field_70169_q -= (double)offsetX;
            player.field_70167_r -= (double)offsetY;
            player.field_70166_s -= (double)offsetZ;
            player.field_70165_t -= (double)offsetX;
            player.field_70163_u -= (double)offsetY;
            player.field_70161_v -= (double)offsetZ;
            if (aabb != null) {
                aabb.func_72317_d((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
            }
            return aabb;
        }
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.visualState == VisualState.CAMOUFLAGE_REMOTE && tile.remotePosition != null) {
            DimensionalCoords there = tile.remotePosition;
            Block remote = there.getBlock(world);
            int offsetX = there.x - x;
            int offsetY = there.y - y;
            int offsetZ = there.z - z;
            AxisAlignedBB newAABB = AxisAlignedBB.func_72330_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f).func_72317_d((double)offsetX, (double)offsetY, (double)offsetZ);
            ArrayList newList = new ArrayList();
            remote.func_149743_a(world, there.x, there.y, there.z, newAABB, newList, entity);
            for (Object o : newList) {
                AxisAlignedBB aabb1 = (AxisAlignedBB)o;
                aabb1.func_72317_d((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
                if (!aabb.func_72326_a(aabb1)) continue;
                list.add(aabb1);
            }
            return;
        }
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public int func_149645_b() {
        return renderID;
    }

    public boolean canRenderInPass(int pass) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        Block block;
        TileRemoteInterface tileRemoteInterface = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tileRemoteInterface.remotePosition != null && tileRemoteInterface.remotePosition.inWorld((World)FMLClientHandler.instance().getWorldClient()) && tileRemoteInterface.hasUpgradeChip(0) && (block = tileRemoteInterface.remotePosition.getBlock()).func_149645_b() == 0) {
            return block.func_149673_e(world, tileRemoteInterface.remotePosition.x, tileRemoteInterface.remotePosition.y, tileRemoteInterface.remotePosition.z, RotationHelper.getRotatedSide(0, tileRemoteInterface.rotationY, 0, side));
        }
        return super.func_149673_e(world, x, y, z, side);
    }

    @Override
    public TileIOCore getTileEntity() {
        return new TileRemoteInterface();
    }
}

