/*
 * Decompiled with CFR 0.152.
 */
package emt.item.focus;

import emt.entity.EntityLaser;
import emt.item.focus.ItemBaseFocus;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemExplosionFocus
extends ItemBaseFocus {
    private static final AspectList visCost = new AspectList().add(Aspect.FIRE, 200).add(Aspect.ENTROPY, 200);

    public ItemExplosionFocus() {
        super("explosion");
    }

    @Override
    public int getFocusColor(ItemStack stack) {
        return 0x8B0000;
    }

    @Override
    public AspectList getVisCost(ItemStack focusstack) {
        return visCost;
    }

    @Override
    public String getSortingHelper(ItemStack itemstack) {
        return "EXPLOSION";
    }

    @Override
    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer player, MovingObjectPosition movingobjectposition) {
        ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
        if ((player.field_71075_bZ.field_75098_d || wand.consumeAllVis(itemstack, player, this.getVisCost(itemstack), true, true)) && !world.field_72995_K) {
            EntityLaser laser = new EntityLaser(world, (EntityLivingBase)player, 1.0f);
            laser.setExplosionStrengthModifier((float)this.getUpgradeLevel(itemstack, FocusUpgradeType.potency) * 0.5f + 1.0f);
            world.func_72838_d((Entity)laser);
        }
        return itemstack;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        return new FocusUpgradeType[]{FocusUpgradeType.potency, FocusUpgradeType.frugal};
    }

    public boolean canApplyUpgrade(ItemStack focusstack, EntityPlayer player, FocusUpgradeType type, int rank) {
        return true;
    }
}

