/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.screen;

import com.google.common.collect.ImmutableMap;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.screen.IWindowCreator;
import com.gtnewhorizons.modularui.api.widget.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;

public class UIBuildContext {
    protected final EntityPlayer player;
    private final Map<String, Widget> jsonWidgets = new HashMap<String, Widget>();
    protected final ImmutableMap.Builder<Integer, IWindowCreator> syncedWindows = new ImmutableMap.Builder();
    protected final List<Runnable> closeListeners = new ArrayList<Runnable>();
    protected Supplier<Boolean> validator;
    protected boolean showNEI = true;

    public UIBuildContext(EntityPlayer player) {
        this.player = player;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public void setValidator(Supplier<Boolean> validator) {
        this.validator = validator;
    }

    public void addJsonWidgets(String name, Widget widget) {
        if (this.jsonWidgets.containsKey(name)) {
            ModularUI.logger.warn("Widget {} is already registered from json", new Object[]{name});
        }
        this.jsonWidgets.put(name, widget);
    }

    public void addCloseListener(Runnable runnable) {
        this.closeListeners.add(runnable);
    }

    @Nullable
    public Widget getJsonWidget(String name) {
        return this.jsonWidgets.get(name);
    }

    @Nullable
    public <T extends Widget> T getJsonWidget(String name, Class<T> clazz) {
        Widget widget = this.getJsonWidget(name);
        if (widget != null && widget.getClass().isAssignableFrom(clazz)) {
            return (T)widget;
        }
        return null;
    }

    public <T extends Widget> void applyToWidget(String name, Class<T> clazz, Consumer<T> consumer) {
        T t = this.getJsonWidget(name, clazz);
        if (t != null) {
            consumer.accept(t);
        } else {
            ModularUI.logger.error("Expected Widget with name {}, of class {}, but was not found!", new Object[]{name, clazz.getName()});
        }
    }

    public void addSyncedWindow(int id, IWindowCreator windowCreator) {
        if (id <= 0) {
            ModularUI.logger.error("Window id must be > 0");
            return;
        }
        this.syncedWindows.put((Object)id, (Object)Objects.requireNonNull(windowCreator));
    }

    public void setShowNEI(boolean showNEI) {
        this.showNEI = showNEI;
    }
}

