/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mariculture.handlers;

import java.util.HashMap;
import java.util.Map;
import mariculture.api.core.IAnvilHandler;
import mariculture.api.core.MaricultureHandlers;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mariculture.MaricultureHelper;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mariculture.Anvil")
public class Anvil {
    public static final String name = "Mariculture Anvil";

    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int hits) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new IAnvilHandler.RecipeAnvil(InputHelper.toStack(input), InputHelper.toStack(output), hits)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient input) {
        HashMap<String, IAnvilHandler.RecipeAnvil> recipes = new HashMap<String, IAnvilHandler.RecipeAnvil>();
        for (Map.Entry recipe : MaricultureHandlers.anvil.getRecipes().entrySet()) {
            if (recipe == null || recipe.getValue() == null || ((IAnvilHandler.RecipeAnvil)recipe.getValue()).input == null || !StackHelper.matches(input, InputHelper.toIItemStack(((IAnvilHandler.RecipeAnvil)recipe.getValue()).input))) continue;
            recipes.put((String)recipe.getKey(), (IAnvilHandler.RecipeAnvil)recipe.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, input.toString()));
        }
    }

    private static class Remove
    extends BaseMapRemoval<String, IAnvilHandler.RecipeAnvil> {
        public Remove(Map<String, IAnvilHandler.RecipeAnvil> recipes) {
            super(Anvil.name, MaricultureHandlers.anvil.getRecipes(), recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<String, IAnvilHandler.RecipeAnvil> recipe) {
            return LogHelper.getStackDescription(recipe.getValue().output);
        }
    }

    private static class Add
    extends BaseMapAddition<String, IAnvilHandler.RecipeAnvil> {
        public Add(IAnvilHandler.RecipeAnvil recipe) {
            super(Anvil.name, MaricultureHandlers.anvil.getRecipes());
            this.recipes.put(MaricultureHelper.getKey(recipe.input), recipe);
        }

        @Override
        public String getRecipeInfo(Map.Entry<String, IAnvilHandler.RecipeAnvil> recipe) {
            return LogHelper.getStackDescription(recipe.getValue().output);
        }
    }
}

