/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mantle.utils.ItemMetaWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.library.crafting.AlloyMix;
import tconstruct.library.crafting.FluidType;

public class Smeltery {
    public static Smeltery instance = new Smeltery();
    private final Map<ItemMetaWrapper, FluidStack> smeltingList = new HashMap<ItemMetaWrapper, FluidStack>();
    private final Map<ItemMetaWrapper, Integer> temperatureList = new HashMap<ItemMetaWrapper, Integer>();
    private final Map<ItemMetaWrapper, ItemStack> renderIndex = new HashMap<ItemMetaWrapper, ItemStack>();
    private final List<AlloyMix> alloys = new ArrayList<AlloyMix>();
    private final Map<Fluid, Integer[]> smelteryFuels = new HashMap<Fluid, Integer[]>();

    public static void addSmelteryFuel(Fluid fluid, int power, int duration) {
        Smeltery.instance.smelteryFuels.put(fluid, new Integer[]{power, duration});
    }

    public static boolean isSmelteryFuel(Fluid fluid) {
        return Smeltery.instance.smelteryFuels.containsKey(fluid);
    }

    public static int getFuelPower(Fluid fluid) {
        Integer[] power = Smeltery.instance.smelteryFuels.get(fluid);
        return power == null ? 0 : power[0];
    }

    public static int getFuelDuration(Fluid fluid) {
        Integer[] power = Smeltery.instance.smelteryFuels.get(fluid);
        return power == null ? 0 : power[1];
    }

    public static void addMelting(ItemStack stack, int temperature, FluidStack output) {
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            throw new IllegalArgumentException("ItemStack must house a block.");
        }
        Smeltery.addMelting(stack, ((ItemBlock)stack.func_77973_b()).field_150939_a, stack.func_77960_j(), temperature, output);
    }

    public static void addMelting(Block block, int metadata, int temperature, FluidStack output) {
        Smeltery.addMelting(new ItemStack(block, 1, metadata), block, metadata, temperature, output);
    }

    public static void addMelting(ItemStack input, Block block, int metadata, int temperature, FluidStack liquid) {
        ItemMetaWrapper in = new ItemMetaWrapper(input);
        Smeltery.instance.smeltingList.put(in, liquid);
        Smeltery.instance.temperatureList.put(in, temperature);
        Smeltery.instance.renderIndex.put(in, new ItemStack(block, input.field_77994_a, metadata));
    }

    public static void addAlloyMixing(FluidStack result, FluidStack ... mixers) {
        ArrayList<FluidStack> inputs = new ArrayList<FluidStack>(Arrays.asList(mixers));
        Smeltery.instance.alloys.add(new AlloyMix(result, inputs));
    }

    public static Integer getLiquifyTemperature(ItemStack item) {
        if (item == null) {
            return 20;
        }
        Integer temp = Smeltery.instance.temperatureList.get(new ItemMetaWrapper(item));
        if (temp == null) {
            return 20;
        }
        return temp;
    }

    public static Integer getLiquifyTemperature(Block block, int metadata) {
        return Smeltery.getLiquifyTemperature(new ItemStack(block, 1, metadata));
    }

    public static FluidStack getSmelteryResult(ItemStack item) {
        if (item == null) {
            return null;
        }
        FluidStack stack = Smeltery.instance.smeltingList.get(new ItemMetaWrapper(item));
        if (stack == null) {
            return null;
        }
        return stack.copy();
    }

    public static FluidStack getSmelteryResult(Block block, int metadata) {
        return Smeltery.getSmelteryResult(new ItemStack(block, 1, metadata));
    }

    public static ItemStack getRenderIndex(ItemStack input) {
        return Smeltery.instance.renderIndex.get(new ItemMetaWrapper(input));
    }

    public static ArrayList<FluidStack> mixMetals(ArrayList<FluidStack> moltenMetal) {
        ArrayList<FluidStack> liquids = new ArrayList<FluidStack>();
        for (AlloyMix alloy : Smeltery.instance.alloys) {
            FluidStack liquid = alloy.mix(moltenMetal);
            if (liquid == null) continue;
            liquids.add(liquid);
        }
        return liquids;
    }

    public static Map<ItemMetaWrapper, FluidStack> getSmeltingList() {
        return Smeltery.instance.smeltingList;
    }

    public static Map<ItemMetaWrapper, Integer> getTemperatureList() {
        return Smeltery.instance.temperatureList;
    }

    public static Map<ItemMetaWrapper, ItemStack> getRenderIndex() {
        return Smeltery.instance.renderIndex;
    }

    public static List<AlloyMix> getAlloyList() {
        return Smeltery.instance.alloys;
    }

    public static void addMelting(FluidType type, ItemStack input, int temperatureDifference, int fluidAmount) {
        int temp = type.baseTemperature + temperatureDifference;
        if (temp <= 20) {
            temp = type.baseTemperature;
        }
        if (input.func_77973_b() instanceof ItemBlock) {
            Smeltery.addMelting(input, ((ItemBlock)input.func_77973_b()).field_150939_a, input.func_77960_j(), type.baseTemperature + temperatureDifference, new FluidStack(type.fluid, fluidAmount));
        } else {
            Smeltery.addMelting(input, type.renderBlock, type.renderMeta, type.baseTemperature + temperatureDifference, new FluidStack(type.fluid, fluidAmount));
        }
    }

    public static void addDictionaryMelting(String oreName, FluidType type, int temperatureDifference, int fluidAmount) {
        for (ItemStack is : OreDictionary.getOres((String)oreName)) {
            Smeltery.addMelting(type, is, temperatureDifference, fluidAmount);
        }
    }
}

