/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.storage;

import betterquesting.api2.storage.IUuidDatabase;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class UuidDatabase<T>
implements IUuidDatabase<T> {
    private final HashBiMap<UUID, T> database = HashBiMap.create();

    @Override
    public UUID generateKey() {
        UUID newKey;
        while (this.containsKey(newKey = UUID.randomUUID())) {
        }
        return newKey;
    }

    @Override
    @Nullable
    public UUID lookupKey(T value) {
        return (UUID)this.inverse().get(value);
    }

    @Override
    public Stream<Map.Entry<UUID, T>> orderedEntries() {
        return this.entrySet().stream().sorted(Map.Entry.comparingByKey());
    }

    @Override
    public Stream<T> getAll(Collection<UUID> keys) {
        return keys.stream().distinct().filter(arg_0 -> this.database.containsKey(arg_0)).map(arg_0 -> this.database.get(arg_0));
    }

    @Override
    public Map<UUID, T> filterKeys(Collection<UUID> keys) {
        return keys.stream().distinct().filter(arg_0 -> this.database.containsKey(arg_0)).collect(Collectors.toMap(Function.identity(), arg_0 -> this.database.get(arg_0)));
    }

    @Override
    public BiMap<UUID, T> filterValues(Collection<T> values) {
        return Maps.filterValues(this.database, values::contains);
    }

    @Override
    public BiMap<UUID, T> filterEntries(BiPredicate<UUID, T> filter) {
        return Maps.filterEntries(this.database, entry -> filter.test((UUID)entry.getKey(), (Object)entry.getValue()));
    }

    @Override
    @Nullable
    public UUID removeValue(T value) {
        return (UUID)this.inverse().remove(value);
    }

    public int size() {
        return this.database.size();
    }

    public boolean isEmpty() {
        return this.database.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.database.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.database.containsValue(value);
    }

    @Nullable
    public T get(Object key) {
        return (T)this.database.get(key);
    }

    @Nullable
    public T put(@Nullable UUID key, @Nullable T value) {
        return (T)this.database.put((Object)key, value);
    }

    @Nullable
    public T remove(Object key) {
        return (T)this.database.remove(key);
    }

    @Nullable
    public T forcePut(@Nullable UUID key, @Nullable T value) {
        return (T)this.database.forcePut((Object)key, value);
    }

    public void putAll(Map<? extends UUID, ? extends T> map) {
        this.database.putAll(map);
    }

    public void clear() {
        this.database.clear();
    }

    public Set<UUID> keySet() {
        return this.database.keySet();
    }

    public Set<T> values() {
        return this.database.values();
    }

    public Set<Map.Entry<UUID, T>> entrySet() {
        return this.database.entrySet();
    }

    public BiMap<T, UUID> inverse() {
        return this.database.inverse();
    }
}

