/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.util;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEFluidStack;
import goodgenerator.items.MyMaterial;
import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class StackUtils {
    public static List<ItemStack> multiplyAndSplitIntoStacks(ItemStack stack, int multiplier) {
        int totalItems = stack.field_77994_a * multiplier;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (totalItems >= 64) {
            for (int i = 0; i < totalItems / 64; ++i) {
                stacks.add(GT_Utility.copyAmount((long)64L, (Object[])new Object[]{stack}));
            }
        }
        if (totalItems % 64 > 0) {
            stacks.add(GT_Utility.copyAmount((long)(totalItems % 64), (Object[])new Object[]{stack}));
        }
        return stacks;
    }

    public static ArrayList<ItemStack> mergeStacks(List<ItemStack> stacks) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (int index = 0; index < stacks.size(); ++index) {
            ItemStack i = stacks.get(index);
            boolean hasDupe = false;
            int newSize = i.field_77994_a;
            for (int j = index + 1; j < stacks.size(); ++j) {
                ItemStack is2 = stacks.get(j);
                if (!GT_Utility.areStacksEqual((ItemStack)i, (ItemStack)is2)) continue;
                hasDupe = true;
                newSize += is2.field_77994_a;
                stacks.remove(j);
                --j;
            }
            if (hasDupe) {
                if (newSize >= 64) {
                    for (int k = 0; k < newSize / 64; ++k) {
                        output.add(GT_Utility.copyAmount((long)64L, (Object[])new Object[]{i}));
                    }
                }
                if (newSize % 64 <= 0) continue;
                output.add(GT_Utility.copyAmount((long)(newSize > 64 ? (long)(newSize % 64) : (long)newSize), (Object[])new Object[]{i}));
                continue;
            }
            output.add(i);
        }
        return output;
    }

    public static HashMap<ItemStack, Integer> getTotalItems(List<ItemStack> items) {
        HashMap<ItemStack, Integer> totals = new HashMap<ItemStack, Integer>();
        block0: for (ItemStack item : items) {
            int t = items.stream().filter(i2 -> GT_Utility.areStacksEqual((ItemStack)item, (ItemStack)i2)).mapToInt(i -> i.field_77994_a).sum();
            for (ItemStack i22 : totals.keySet()) {
                if (!GT_Utility.areStacksEqual((ItemStack)item, (ItemStack)i22)) continue;
                continue block0;
            }
            totals.put(GT_Utility.copyAmount((long)1L, (Object[])new Object[]{item}), t);
        }
        return totals;
    }

    public static HashMap<ItemStack, Integer> getTotalItems(ItemStack[] items) {
        return StackUtils.getTotalItems(Arrays.asList(items));
    }

    public static FluidStack getTieredFluid(int aTier, int aAmount) {
        switch (aTier) {
            case 0: {
                return Materials.RedAlloy.getMolten((long)aAmount);
            }
            case 1: {
                return Materials.TinAlloy.getMolten((long)aAmount);
            }
            case 2: {
                return Materials.RoseGold.getMolten((long)aAmount);
            }
            case 3: {
                return MyMaterial.zircaloy4.getMolten(aAmount);
            }
            case 4: {
                return MyMaterial.incoloy903.getMolten(aAmount);
            }
            case 5: {
                return MyMaterial.titaniumBetaC.getMolten(aAmount);
            }
            case 6: {
                return MyMaterial.artheriumSn.getMolten(aAmount);
            }
            case 7: {
                return MyMaterial.dalisenite.getMolten(aAmount);
            }
            case 8: {
                return MyMaterial.tairitsu.getMolten(aAmount);
            }
            case 9: {
                return MyMaterial.preciousMetalAlloy.getMolten(aAmount);
            }
            case 10: {
                return MyMaterial.enrichedNaquadahAlloy.getMolten(aAmount);
            }
            case 11: {
                return MyMaterial.metastableOganesson.getMolten(aAmount);
            }
            case 12: {
                return MaterialsUEVplus.SpaceTime.getMolten((long)aAmount);
            }
        }
        return MyMaterial.shirabon.getMolten(aAmount);
    }

    public static IAEFluidStack createAEFluidStack(Fluid fluid) {
        return StackUtils.createAEFluidStack(new FluidStack(fluid, 1000));
    }

    public static IAEFluidStack createAEFluidStack(Fluid fluid, long amount) {
        return StackUtils.createAEFluidStack(fluid.getID(), amount);
    }

    public static IAEFluidStack createAEFluidStack(FluidStack fluid) {
        return AEApi.instance().storage().createFluidStack(fluid);
    }

    public static IAEFluidStack createAEFluidStack(int fluidId, long amount) {
        return (IAEFluidStack)StackUtils.createAEFluidStack(new FluidStack(FluidRegistry.getFluid((int)fluidId), 1)).setStackSize(amount);
    }
}

