/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Handler.Bloodmoon;

import lumien.randomthings.Configuration.Settings;
import lumien.randomthings.Handler.Bloodmoon.BloodmoonSpawner;
import lumien.randomthings.Network.Messages.MessageBloodmoon;
import lumien.randomthings.Network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class ServerBloodmoonHandler
extends WorldSavedData {
    public static ServerBloodmoonHandler INSTANCE;
    private final BloodmoonSpawner bloodMoonSpawner = new BloodmoonSpawner();
    boolean bloodMoon = false;
    boolean forceBloodMoon = false;

    public ServerBloodmoonHandler() {
        super("Bloodmoon");
    }

    public ServerBloodmoonHandler(String name) {
        super("Bloodmoon");
    }

    public void playerJoinedWorld(EntityPlayer player) {
        if (this.bloodMoon) {
            PacketHandler.INSTANCE.sendTo(new MessageBloodmoon(this.bloodMoon), (EntityPlayerMP)player);
        }
    }

    public void endWorldTick(World world) {
        if (world.field_73011_w.field_76574_g == 0) {
            int time = (int)(world.func_72820_D() % 24000L);
            if (this.bloodMoon) {
                if (!Settings.BLOODMOON_RESPECT_GAMERULE || world.func_82736_K().func_82766_b("doMobSpawning")) {
                    for (int i = 0; i < Settings.BLOODMOON_SPAWNSPEED; ++i) {
                        this.bloodMoonSpawner.findChunksForSpawning((WorldServer)world, true, false, world.func_82737_E() % 20L == 0L);
                    }
                }
                if (time >= 0 && time < 12000) {
                    this.setBloodmoon(false);
                }
            } else if (time == 12000 && (this.forceBloodMoon || Math.random() < (double)Settings.BLOODMOON_CHANCE)) {
                this.forceBloodMoon = false;
                this.setBloodmoon(true);
                if (Settings.BLOODMOON_MESSAGE) {
                    for (EntityPlayer player : world.field_73010_i) {
                        player.func_145747_a(new ChatComponentTranslation("text.bloodmoon.notify", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                    }
                }
            }
        }
    }

    private void setBloodmoon(boolean bloodMoon) {
        if (this.bloodMoon != bloodMoon) {
            PacketHandler.INSTANCE.sendToDimension(new MessageBloodmoon(bloodMoon), 0);
            this.func_76185_a();
        }
        this.bloodMoon = bloodMoon;
    }

    public void force() {
        this.forceBloodMoon = true;
        this.func_76185_a();
    }

    public boolean isBloodmoonActive() {
        return this.bloodMoon;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.bloodMoon = nbt.func_74767_n("bloodMoon");
        this.forceBloodMoon = nbt.func_74767_n("forceBloodMoon");
    }

    public void func_76187_b(NBTTagCompound nbt) {
        nbt.func_74757_a("bloodMoon", this.bloodMoon);
        nbt.func_74757_a("forceBloodMoon", this.forceBloodMoon);
    }

    public boolean isBloodmoonScheduled() {
        return this.forceBloodMoon;
    }
}

