/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.MultiBlock;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.door.block.Door;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.malisis.doors.door.tileentity.ForcefieldTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ForcefieldDoor
extends Block
implements ITileEntityProvider {
    public static int renderId = -1;

    public ForcefieldDoor() {
        super(Material.field_151574_g);
        this.func_149752_b(6.0E7f);
        this.func_149722_s();
        this.func_149672_a(field_149780_i);
        this.func_149663_c("forcefieldDoor");
        this.func_149658_d("malisisdoors:forcefield");
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (side != 1) {
            return false;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side).getOpposite();
        return world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).isSideSolid((IBlockAccess)world, x, y, z, dir);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        ForgeDirection side = EntityUtils.getEntityFacing((Entity)player);
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)1.0);
        MultiBlock mb = new MultiBlock(world, x, y, z);
        mb.setDirection(side);
        mb.setBounds(aabb);
        if (!mb.placeBlocks()) {
            ++itemStack.field_77994_a;
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!EntityUtils.isEquipped((EntityPlayer)player, (Item)MalisisDoors.Items.forcefieldItem)) {
            return true;
        }
        ForcefieldTileEntity te = (ForcefieldTileEntity)((Object)TileEntityUtils.getTileEntity(ForcefieldTileEntity.class, (IBlockAccess)world, (int)x, (int)y, (int)z));
        if (te == null) {
            return true;
        }
        if (player.func_70093_af()) {
            MultiBlock.destroy((World)world, (int)x, (int)y, (int)z);
            MalisisDoors.Items.forcefieldItem.setEnergy(player.func_71045_bC(), 0);
        } else {
            te.openOrCloseDoor();
        }
        return true;
    }

    protected AxisAlignedBB setBlockBounds(AxisAlignedBB aabb) {
        if (aabb == null) {
            return null;
        }
        this.func_149676_a((float)aabb.field_72340_a, (float)aabb.field_72338_b, (float)aabb.field_72339_c, (float)aabb.field_72336_d, (float)aabb.field_72337_e, (float)aabb.field_72334_f);
        return aabb;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        DoorTileEntity te = Door.getDoor(world, x, y, z);
        if (te == null || te.getMovement() == null) {
            this.setBlockBounds(AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
            return;
        }
        if (te.isMoving()) {
            return;
        }
        AxisAlignedBB aabb = te.getMovement().getBoundingBox(te, false, BoundingBoxType.RAYTRACE);
        if (aabb == null) {
            aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        aabb.func_72317_d((double)(-x), (double)(-y), (double)(-z));
        this.setBlockBounds(aabb);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null || te.getMovement() == null) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        if (te.isMoving()) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        AxisAlignedBB aabb = te.getMovement().getBoundingBox(te, false, BoundingBoxType.SELECTION);
        if (aabb == null) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return aabb;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        DoorTileEntity te = Door.getDoor((IBlockAccess)world, x, y, z);
        if (te == null || te.getMovement() == null) {
            return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        }
        if (te.isMoving()) {
            return null;
        }
        AxisAlignedBB aabb = te.getMovement().getBoundingBox(te, false, BoundingBoxType.COLLISION);
        if (aabb == null) {
            return null;
        }
        return this.setBlockBounds(aabb);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        MultiBlock.destroy((World)world, (int)x, (int)y, (int)z);
        world.func_147468_f(x, y, z);
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new ForcefieldTileEntity();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return new ItemStack((Item)MalisisDoors.Items.forcefieldItem);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }
}

