/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.door.item;

import net.malisis.core.util.MultiBlock;
import net.malisis.doors.MalisisDoors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ForcefieldItem
extends Item {
    protected IIcon yellowIcon;
    protected IIcon redIcon;
    protected IIcon greenIcon;
    protected IIcon disabledIcon;

    public ForcefieldItem() {
        this.func_77655_b("forcefieldItem");
        this.func_77637_a(MalisisDoors.tab);
        this.func_77656_e(0);
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("malisisdoors:forcefielditem");
        this.yellowIcon = register.func_94245_a("malisisdoors:forcefielditem_yellow");
        this.redIcon = register.func_94245_a("malisisdoors:forcefielditem_red");
        this.greenIcon = register.func_94245_a("malisisdoors:forcefielditem_green");
        this.disabledIcon = register.func_94245_a("malisisdoors:forcefielditem_disabled");
    }

    public IIcon getIcon(ItemStack itemStack, int pass) {
        if (this.getEnergy(itemStack) < this.getMaxEnergy()) {
            return this.disabledIcon;
        }
        if (!this.isStartSet(itemStack)) {
            return this.field_77791_bV;
        }
        MovingObjectPosition mop = Minecraft.func_71410_x().field_71476_x;
        if (mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return this.yellowIcon;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
        ChunkPosition pos = new ChunkPosition(mop.field_72311_b + dir.offsetX, mop.field_72312_c + dir.offsetY, mop.field_72309_d + dir.offsetZ);
        ChunkPosition start = this.getStartPosition(itemStack);
        if (start.field_151327_b > pos.field_151327_b) {
            ChunkPosition tmp = start;
            start = pos;
            pos = tmp;
        }
        AxisAlignedBB aabb = this.getBoundingBox(start, pos);
        if (aabb.field_72340_a < aabb.field_72336_d - 1.0 && aabb.field_72338_b < aabb.field_72337_e - 1.0 && aabb.field_72339_c < aabb.field_72334_f - 1.0) {
            return this.redIcon;
        }
        int size = this.getDoorSize(aabb);
        if (size <= 0 || this.getEnergy(itemStack) < size * 20) {
            return this.redIcon;
        }
        return this.greenIcon;
    }

    public IIcon func_77650_f(ItemStack itemStack) {
        return this.getIcon(itemStack, 0);
    }

    public int getEnergy(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74762_e("energy");
    }

    public void setEnergy(ItemStack itemStack, int energy) {
        if (energy < 0) {
            energy = 0;
        } else if (energy > this.getMaxEnergy()) {
            energy = this.func_77612_l();
        }
        this.getNBT(itemStack).func_74768_a("energy", energy);
    }

    public void drainEnergy(ItemStack itemStack, int energy, long time) {
        this.setEnergy(itemStack, this.getEnergy(itemStack) - energy);
    }

    protected int getMaxEnergy() {
        return 2000;
    }

    protected NBTTagCompound getNBT(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.getEnergy(itemStack) < this.getMaxEnergy()) {
            return true;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        ChunkPosition pos = new ChunkPosition(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        if (!this.isStartSet(itemStack)) {
            this.setStartPosition(itemStack, pos, world.func_82737_E());
            return true;
        }
        ChunkPosition start = this.getStartPosition(itemStack);
        if (start.field_151327_b > pos.field_151327_b) {
            ChunkPosition tmp = start;
            start = pos;
            pos = tmp;
        }
        AxisAlignedBB aabb = this.getBoundingBox(start, pos);
        if (aabb.field_72340_a < aabb.field_72336_d - 1.0 && aabb.field_72338_b < aabb.field_72337_e - 1.0 && aabb.field_72339_c < aabb.field_72334_f - 1.0) {
            this.clearStartPosition(itemStack);
            return true;
        }
        int size = this.getDoorSize(aabb);
        if (size <= 0 || this.getEnergy(itemStack) < size * 20) {
            this.clearStartPosition(itemStack);
            return true;
        }
        MultiBlock multiBlock = new MultiBlock(world, (int)aabb.field_72340_a, (int)aabb.field_72338_b, (int)aabb.field_72339_c);
        multiBlock.setBlock((Block)MalisisDoors.Blocks.forcefieldDoor);
        multiBlock.setBounds(aabb.func_72317_d(-aabb.field_72340_a, -aabb.field_72338_b, -aabb.field_72339_c));
        multiBlock.setDirection(ForgeDirection.UNKNOWN);
        if (multiBlock.placeBlocks(true)) {
            this.drainEnergy(itemStack, size * 20, world.func_82737_E());
        }
        this.clearStartPosition(itemStack);
        return true;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    protected boolean isStartSet(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74764_b("x");
    }

    protected void setStartPosition(ItemStack itemStack, ChunkPosition position, long time) {
        this.getNBT(itemStack).func_74768_a("x", position.field_151329_a);
        this.getNBT(itemStack).func_74768_a("y", position.field_151327_b);
        this.getNBT(itemStack).func_74768_a("z", position.field_151328_c);
        this.getNBT(itemStack).func_74772_a("time", time);
    }

    protected ChunkPosition getStartPosition(ItemStack itemStack) {
        return new ChunkPosition(this.getNBT(itemStack).func_74762_e("x"), this.getNBT(itemStack).func_74762_e("y"), this.getNBT(itemStack).func_74762_e("z"));
    }

    protected void clearStartPosition(ItemStack itemStack) {
        this.getNBT(itemStack).func_82580_o("x");
        this.getNBT(itemStack).func_82580_o("y");
        this.getNBT(itemStack).func_82580_o("z");
        this.getNBT(itemStack).func_82580_o("time");
    }

    protected AxisAlignedBB getBoundingBox(ChunkPosition start, ChunkPosition end) {
        int minX = Math.min(start.field_151329_a, end.field_151329_a);
        int maxX = Math.max(start.field_151329_a, end.field_151329_a);
        int minY = Math.min(start.field_151327_b, end.field_151327_b);
        int maxY = Math.max(start.field_151327_b, end.field_151327_b);
        int minZ = Math.min(start.field_151328_c, end.field_151328_c);
        int maxZ = Math.max(start.field_151328_c, end.field_151328_c);
        return AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    protected int getDoorSize(AxisAlignedBB aabb) {
        int diffX = (int)(aabb.field_72336_d - aabb.field_72340_a);
        int diffY = (int)(aabb.field_72337_e - aabb.field_72338_b);
        int diffZ = (int)(aabb.field_72334_f - aabb.field_72339_c);
        if (diffY != 1 && diffX == 1 && diffZ == 1) {
            return -1;
        }
        return diffX * diffY * diffZ;
    }

    protected ForgeDirection getOrientation(ChunkPosition start, ChunkPosition end) {
        if (start.field_151329_a == end.field_151329_a) {
            return start.field_151328_c < end.field_151328_c ? ForgeDirection.EAST : ForgeDirection.WEST;
        }
        if (start.field_151328_c == end.field_151328_c) {
            return start.field_151329_a < end.field_151329_a ? ForgeDirection.NORTH : ForgeDirection.SOUTH;
        }
        return ForgeDirection.UNKNOWN;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (world.field_72995_K) {
            return;
        }
        if (this.isStartSet(itemStack) && world.func_82737_E() - this.getNBT(itemStack).func_74763_f("time") > 100L) {
            this.clearStartPosition(itemStack);
        }
        if (this.getEnergy(itemStack) >= this.getMaxEnergy()) {
            return;
        }
        int energy = this.getEnergy(itemStack) + 20;
        if (((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            energy += 20;
        }
        this.setEnergy(itemStack, energy);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - (double)this.getEnergy(itemStack) / (double)this.getMaxEnergy();
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 1;
    }
}

