/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.item.block.GSItemBlockDesc;
import galaxyspace.core.tile.machine.TileEntityGeothermalGenerator;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGeothermalGenerator
extends BlockTileGC
implements GSItemBlockDesc.IBlockShiftDesc {
    public static final int GEOTHERMAL_GENERATOR_METADATA = 0;
    private IIcon iconMachineSide;
    private IIcon iconOutput;
    private IIcon iconLavaOutput;
    private IIcon[] iconGeothermalGenerator = new IIcon[2];
    private int level = 0;

    public BlockGeothermalGenerator(String assetName) {
        super(GCBlocks.machine);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityGeothermalGenerator) {
            TileEntityGeothermalGenerator tileEntity = (TileEntityGeothermalGenerator)tile;
            if (tileEntity.lavaTank.getFluidAmount() > 0) {
                return 8;
            }
        }
        return 0;
    }

    public void func_149749_a(World var1, int var2, int var3, int var4, Block var5, int var6) {
        TileEntity var7 = var1.func_147438_o(var2, var3, var4);
        if (var7 instanceof IMultiBlock) {
            ((IMultiBlock)var7).onDestroy(var7);
        }
        super.func_149749_a(var1, var2, var3, var4, var5, var6);
    }

    public CreativeTabs func_149708_J() {
        return GalaxySpace.tabBlocks;
    }

    public int func_149645_b() {
        return GalaxySpace.proxy.getBlockRender((Block)this);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine");
        this.iconOutput = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_output");
        this.iconMachineSide = iconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_side");
        this.iconLavaOutput = iconRegister.func_94245_a("galaxyspace:overworld/geothermalGenerator_lava_input");
        for (int i = 0; i < this.iconGeothermalGenerator.length; ++i) {
            this.iconGeothermalGenerator[i] = iconRegister.func_94245_a("galaxyspace:overworld/geothermalGenerator_" + i);
        }
    }

    public void func_149734_b(World par1World, int x, int y, int z, Random par5Random) {
        TileEntity tile = par1World.func_147438_o(x, y, z);
        if (tile instanceof TileEntityGeothermalGenerator) {
            TileEntityGeothermalGenerator tileEntity = (TileEntityGeothermalGenerator)tile;
            if (tileEntity.heatGJperTick > 0.0f) {
                int metadata = par1World.func_72805_g(x, y, z);
                float var7 = (float)x + 0.5f;
                float var8 = (float)y + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
                float var9 = (float)z + 0.5f;
                float var10 = 0.52f;
                float var11 = par5Random.nextFloat() * 0.6f - 0.3f;
                if (metadata == 0) {
                    par1World.func_72869_a("smoke", (double)(var7 - 0.52f), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 - 0.52f), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 1) {
                    par1World.func_72869_a("smoke", (double)(var7 + 0.52f), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + 0.52f), (double)var8, (double)(var9 + var11), 0.0, 0.0, 0.0);
                } else if (metadata == 2) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 + 0.52f), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 + 0.52f), 0.0, 0.0, 0.0);
                } else if (metadata == 3) {
                    par1World.func_72869_a("smoke", (double)(var7 + var11), (double)var8, (double)(var9 - 0.52f), 0.0, 0.0, 0.0);
                    par1World.func_72869_a("flame", (double)(var7 + var11), (double)var8, (double)(var9 - 0.52f), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        int type = metadata & 4;
        int metaside = (metadata & 3) + 2;
        TileEntity tile = world.func_147438_o(x, y, z);
        if ((metadata == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) && tile instanceof TileEntityGeothermalGenerator) {
            TileEntityGeothermalGenerator tileEntity = (TileEntityGeothermalGenerator)tile;
            this.level = tileEntity.lavaTank.getFluidAmount() == 0 ? 0 : 1;
            return this.iconGeothermalGenerator[this.level];
        }
        return this.func_149691_a(side, world.func_72805_g(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.field_149761_L;
        }
        if (metadata >= 0) {
            if (side == metadata + 2) {
                return this.iconOutput;
            }
            if (side == ForgeDirection.getOrientation((int)(metadata + 2)).getOpposite().ordinal()) {
                return this.iconLavaOutput;
            }
            if (metadata == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) {
                return this.iconGeothermalGenerator[this.level];
            }
        }
        return this.iconMachineSide;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        int metadata = world.func_72805_g(x, y, z);
        int angle = MathHelper.func_76128_c((double)((double)(entityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 3;
                break;
            }
            case 1: {
                change = 1;
                break;
            }
            case 2: {
                change = 2;
                break;
            }
            case 3: {
                change = 0;
            }
        }
        world.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
    }

    public boolean onUseWrench(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        int metadata = par1World.func_72805_g(x, y, z);
        int original = metadata & 3;
        int change = 0;
        switch (original) {
            case 0: {
                change = 3;
                break;
            }
            case 3: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
            }
        }
        if (metadata < 0 && (te = par1World.func_147438_o(x, y, z)) instanceof TileBaseUniversalElectrical) {
            ((TileBaseUniversalElectrical)te).updateFacing();
        }
        par1World.func_72921_c(x, y, z, (metadata & 0xC) + change, 3);
        return true;
    }

    public boolean onMachineActivated(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int side, float hitX, float hitY, float hitZ) {
        int metadata = par1World.func_72805_g(x, y, z);
        if (!par1World.field_72995_K) {
            par5EntityPlayer.openGui((Object)GalaxySpace.instance, -1, par1World, x, y, z);
            return true;
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if ((metadata &= 0xC) == 0) {
            return new TileEntityGeothermalGenerator();
        }
        return null;
    }

    public ItemStack getGeothermalGenerator() {
        return new ItemStack((Block)this, 1, 0);
    }

    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getGeothermalGenerator());
    }

    public int func_149692_a(int metadata) {
        return metadata & 0xC;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        int metadata = this.func_149643_k(world, x, y, z);
        return new ItemStack((Block)this, 1, metadata);
    }

    @Override
    public String getDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.coefficient.desc") + ": x" + GSConfigCore.coefficientGeothermalGenerator;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.GeothermalGenerator.desc");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }
}

