/*
 * Decompiled with CFR 0.152.
 */
package external.org.slf4j.impl;

import external.org.slf4j.Marker;
import external.org.slf4j.MarkerFactory;
import external.org.slf4j.helpers.EventDataConverter;
import external.org.slf4j.spi.LocationAwareLogger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.spi.AbstractLoggerWrapper;

public class SLF4JLogger
implements LocationAwareLogger {
    private static final String FQCN = SLF4JLogger.class.getName();
    private static final Marker EVENT_MARKER = MarkerFactory.getMarker("EVENT");
    private final boolean eventLogger;
    private final AbstractLoggerWrapper logger;
    private final String name;
    private final EventDataConverter converter;

    public SLF4JLogger(AbstractLogger logger, String name) {
        this.logger = new AbstractLoggerWrapper(logger, name, null);
        this.eventLogger = "EventLogger".equals(name);
        this.name = name;
        this.converter = this.createConverter();
    }

    @Override
    public void trace(String format) {
        if (this.logger.isTraceEnabled()) {
            this.logger.log(null, FQCN, Level.TRACE, (Message)new SimpleMessage(format), null);
        }
    }

    @Override
    public void trace(String format, Object o) {
        if (this.logger.isTraceEnabled()) {
            this.logger.log(null, FQCN, Level.TRACE, (Message)new ParameterizedMessage(format, o), null);
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.logger.isTraceEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, arg1, arg2);
            this.logger.log(null, FQCN, Level.TRACE, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, args);
            this.logger.log(null, FQCN, Level.TRACE, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void trace(String format, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.log(null, FQCN, Level.TRACE, (Message)new SimpleMessage(format), t);
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled((org.apache.logging.log4j.Marker)marker);
    }

    @Override
    public void trace(Marker marker, String s) {
        if (this.isTraceEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.TRACE, (Message)new SimpleMessage(s), null);
        }
    }

    @Override
    public void trace(Marker marker, String s, Object o) {
        if (this.isTraceEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.TRACE, (Message)new ParameterizedMessage(s, o), null);
        }
    }

    @Override
    public void trace(Marker marker, String s, Object o, Object o1) {
        if (this.isTraceEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, o, o1);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.TRACE, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void trace(Marker marker, String s, Object ... objects) {
        if (this.isTraceEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, objects);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.TRACE, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void trace(Marker marker, String s, Throwable throwable) {
        if (this.isTraceEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.TRACE, (Message)new SimpleMessage(s), throwable);
        }
    }

    @Override
    public void debug(String format) {
        if (this.logger.isDebugEnabled()) {
            this.logger.log(null, FQCN, Level.DEBUG, (Message)new SimpleMessage(format), null);
        }
    }

    @Override
    public void debug(String format, Object o) {
        if (this.logger.isDebugEnabled()) {
            this.logger.log(null, FQCN, Level.DEBUG, (Message)new ParameterizedMessage(format, o), null);
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, arg1, arg2);
            this.logger.log(null, FQCN, Level.DEBUG, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, args);
            this.logger.log(null, FQCN, Level.DEBUG, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void debug(String format, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.log(null, FQCN, Level.DEBUG, (Message)new SimpleMessage(format), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled((org.apache.logging.log4j.Marker)marker);
    }

    @Override
    public void debug(Marker marker, String s) {
        if (this.isDebugEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.DEBUG, (Message)new SimpleMessage(s), null);
        }
    }

    @Override
    public void debug(Marker marker, String s, Object o) {
        if (this.isDebugEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.DEBUG, (Message)new ParameterizedMessage(s, o), null);
        }
    }

    @Override
    public void debug(Marker marker, String s, Object o, Object o1) {
        if (this.isDebugEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, o, o1);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.DEBUG, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void debug(Marker marker, String s, Object ... objects) {
        if (this.isDebugEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, objects);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.DEBUG, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void debug(Marker marker, String s, Throwable throwable) {
        if (this.isDebugEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.DEBUG, (Message)new SimpleMessage(s), throwable);
        }
    }

    @Override
    public void info(String format) {
        if (this.logger.isInfoEnabled()) {
            this.logger.log(null, FQCN, Level.INFO, (Message)new SimpleMessage(format), null);
        }
    }

    @Override
    public void info(String format, Object o) {
        if (this.logger.isInfoEnabled()) {
            this.logger.log(null, FQCN, Level.INFO, (Message)new ParameterizedMessage(format, o), null);
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, arg1, arg2);
            this.logger.log(null, FQCN, Level.INFO, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, args);
            this.logger.log(null, FQCN, Level.INFO, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void info(String format, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.log(null, FQCN, Level.INFO, (Message)new SimpleMessage(format), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled((org.apache.logging.log4j.Marker)marker);
    }

    @Override
    public void info(Marker marker, String s) {
        if (this.isInfoEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.INFO, (Message)new SimpleMessage(s), null);
        }
    }

    @Override
    public void info(Marker marker, String s, Object o) {
        if (this.isInfoEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.INFO, (Message)new ParameterizedMessage(s, o), null);
        }
    }

    @Override
    public void info(Marker marker, String s, Object o, Object o1) {
        if (this.isInfoEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, o, o1);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.INFO, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void info(Marker marker, String s, Object ... objects) {
        if (this.isInfoEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, objects);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.INFO, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void info(Marker marker, String s, Throwable throwable) {
        if (this.isInfoEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.INFO, (Message)new SimpleMessage(s), throwable);
        }
    }

    @Override
    public void warn(String format) {
        if (this.logger.isWarnEnabled()) {
            this.logger.log(null, FQCN, Level.WARN, (Message)new SimpleMessage(format), null);
        }
    }

    @Override
    public void warn(String format, Object o) {
        if (this.logger.isWarnEnabled()) {
            this.logger.log(null, FQCN, Level.WARN, (Message)new ParameterizedMessage(format, o), null);
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.logger.isWarnEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, arg1, arg2);
            this.logger.log(null, FQCN, Level.WARN, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, args);
            this.logger.log(null, FQCN, Level.WARN, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void warn(String format, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.log(null, FQCN, Level.WARN, (Message)new SimpleMessage(format), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled((org.apache.logging.log4j.Marker)marker);
    }

    @Override
    public void warn(Marker marker, String s) {
        if (this.isWarnEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.WARN, (Message)new SimpleMessage(s), null);
        }
    }

    @Override
    public void warn(Marker marker, String s, Object o) {
        if (this.isWarnEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.WARN, (Message)new ParameterizedMessage(s, o), null);
        }
    }

    @Override
    public void warn(Marker marker, String s, Object o, Object o1) {
        if (this.isWarnEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, o, o1);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.WARN, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void warn(Marker marker, String s, Object ... objects) {
        if (this.isWarnEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, objects);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.WARN, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void warn(Marker marker, String s, Throwable throwable) {
        if (this.isWarnEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.WARN, (Message)new SimpleMessage(s), throwable);
        }
    }

    @Override
    public void error(String format) {
        if (this.logger.isErrorEnabled()) {
            this.logger.log(null, FQCN, Level.ERROR, (Message)new SimpleMessage(format), null);
        }
    }

    @Override
    public void error(String format, Object o) {
        if (this.logger.isErrorEnabled()) {
            this.logger.log(null, FQCN, Level.ERROR, (Message)new ParameterizedMessage(format, o), null);
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.logger.isErrorEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, arg1, arg2);
            this.logger.log(null, FQCN, Level.ERROR, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            ParameterizedMessage msg = new ParameterizedMessage(format, args);
            this.logger.log(null, FQCN, Level.ERROR, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void error(String format, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.log(null, FQCN, Level.ERROR, (Message)new SimpleMessage(format), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled((org.apache.logging.log4j.Marker)marker);
    }

    @Override
    public void error(Marker marker, String s) {
        if (this.isErrorEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.ERROR, (Message)new SimpleMessage(s), null);
        }
    }

    @Override
    public void error(Marker marker, String s, Object o) {
        if (this.isErrorEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.ERROR, (Message)new ParameterizedMessage(s, o), null);
        }
    }

    @Override
    public void error(Marker marker, String s, Object o, Object o1) {
        if (this.isErrorEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, o, o1);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.ERROR, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void error(Marker marker, String s, Object ... objects) {
        if (this.isErrorEnabled(marker)) {
            ParameterizedMessage msg = new ParameterizedMessage(s, objects);
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.ERROR, (Message)msg, msg.getThrowable());
        }
    }

    @Override
    public void error(Marker marker, String s, Throwable throwable) {
        if (this.isErrorEnabled(marker)) {
            this.logger.log((org.apache.logging.log4j.Marker)marker, FQCN, Level.ERROR, (Message)new SimpleMessage(s), throwable);
        }
    }

    @Override
    public void log(Marker marker, String fqcn, int i, String s1, Object[] objects, Throwable throwable) {
        SimpleMessage msg;
        if (!this.logger.isEnabled(this.getLevel(i), (org.apache.logging.log4j.Marker)marker, s1)) {
            return;
        }
        if (this.eventLogger && marker != null && marker.contains(EVENT_MARKER) && this.converter != null) {
            msg = this.converter.convertEvent(s1, objects, throwable);
        } else if (objects == null) {
            msg = new SimpleMessage(s1);
        } else {
            msg = new ParameterizedMessage(s1, objects, throwable);
            if (throwable != null) {
                throwable = msg.getThrowable();
            }
        }
        this.logger.log((org.apache.logging.log4j.Marker)marker, fqcn, this.getLevel(i), (Message)msg, throwable);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private EventDataConverter createConverter() {
        try {
            Class.forName("external.org.slf4j.ext.EventData");
            return new EventDataConverter();
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    private Level getLevel(int i) {
        switch (i) {
            case 0: {
                return Level.TRACE;
            }
            case 10: {
                return Level.DEBUG;
            }
            case 20: {
                return Level.INFO;
            }
            case 30: {
                return Level.WARN;
            }
            case 40: {
                return Level.ERROR;
            }
        }
        return Level.ERROR;
    }
}

