/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations;

import fabric.com.gitlab.cdagaming.craftpresence.utils.MathUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.widgets.DynamicWidget;
import java.awt.Color;

public class ScrollPane
extends ExtendedScreen {
    private static final Color NONE = StringUtils.getColorFrom(0, 0, 0, 0);
    private static final int DEFAULT_PADDING = 4;
    private static final int DEFAULT_BAR_WIDTH = 6;
    private static final int DEFAULT_HEIGHT_PER_SCROLL = 8;
    private boolean clickedScrollbar;
    private int padding;
    private float amountScrolled;
    private int mousePrevX = 0;
    private int mousePrevY = 0;

    public ScrollPane(int startX, int startY, int width, int height, int padding) {
        this.setScreenX(startX);
        this.setScreenY(startY);
        this.setScreenWidth(width - startX);
        this.setScreenHeight(height - startY);
        this.setPadding(padding);
        this.setScroll(0.0f);
    }

    public ScrollPane(int startX, int startY, int width, int height) {
        this(startX, startY, width, height, 4);
    }

    public ScrollPane(int width, int height, int padding) {
        this(0, 0, width, height, padding);
    }

    public ScrollPane(int width, int height) {
        this(width, height, 4);
    }

    @Override
    public void resetMouseScroll() {
        super.resetMouseScroll();
        this.setScroll(this.getMouseScroll());
    }

    @Override
    public void refreshContentHeight() {
        super.refreshContentHeight();
        this.setContentHeight((int)((float)this.getContentHeight() + this.getAmountScrolled()));
    }

    @Override
    public double getOffset() {
        return this.getAmountScrolled();
    }

    @Override
    public float getTintFactor() {
        return 0.5f;
    }

    @Override
    public void postRender() {
        RenderUtils.drawGradient(this.getLeft(), this.getRight(), this.getTop(), this.getTop() + this.getPadding(), -100.0, Color.black, NONE);
        RenderUtils.drawGradient(this.getLeft(), this.getRight(), this.getBottom() - this.getPadding(), this.getBottom(), -100.0, NONE, Color.black);
        if (this.needsScrollbar()) {
            int scrollBarX = this.getScrollBarX();
            int scrollBarRight = scrollBarX + this.getScrollBarWidth();
            int bottom = this.getBottom();
            int top = this.getTop();
            int maxScroll = this.getMaxScroll();
            int screenHeight = this.getScreenHeight();
            int height = this.getBarHeight();
            float barTop = this.getAmountScrolled() * (float)(screenHeight - height) / (float)maxScroll + (float)top;
            if (barTop < (float)top) {
                barTop = top;
            }
            RenderUtils.drawGradient(scrollBarX, scrollBarRight, top, bottom, 0.0, Color.black, Color.black);
            RenderUtils.drawGradient(scrollBarX, scrollBarRight, barTop, barTop + (float)height, 0.0, Color.gray, Color.gray);
            RenderUtils.drawGradient(scrollBarX, scrollBarRight - 1, barTop, barTop + (float)height - 1.0f, 0.0, Color.lightGray, Color.lightGray);
        }
        super.postRender();
    }

    @Override
    protected void method_1026(int mouseX, int mouseY, int mouseButton) {
        if (this.isLoaded()) {
            this.checkScrollbarClick(mouseX, mouseY, mouseButton);
            this.mousePrevX = mouseX;
            this.mousePrevY = mouseY;
            super.method_1026(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    protected void method_4259(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick) {
        if (this.isLoaded()) {
            this.mouseDragged(mouseX, mouseY, mouseButton, mouseX - this.mousePrevX, mouseY - this.mousePrevY);
            this.mousePrevX = mouseX;
            this.mousePrevY = mouseY;
            super.method_4259(mouseX, mouseY, mouseButton, timeSinceLastClick);
        }
    }

    public void mouseDragged(int mouseX, int mouseY, int button, int deltaX, int deltaY) {
        if (button == 0 && this.needsScrollbar() && this.clickedScrollbar) {
            if (mouseY < this.getTop()) {
                this.setScroll(0.0f);
            } else if (mouseY > this.getBottom()) {
                this.setScroll(this.getMaxScroll());
            } else {
                int height = this.getBarHeight();
                int scrollLimit = Math.max(1, this.getMaxScroll());
                int heightPerScroll = Math.max(1, scrollLimit / (this.getScreenHeight() - height));
                this.scrollBy(deltaY * heightPerScroll);
            }
        }
    }

    @Override
    public void mouseScrolled(int mouseX, int mouseY, int wheelY) {
        this.scrollBy(-wheelY * this.getHeightPerScroll());
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int newPadding) {
        this.padding = newPadding;
    }

    public int getScrollBarX() {
        return this.getRight() - this.getScrollBarWidth();
    }

    public int getScrollBarWidth() {
        return 6;
    }

    public int getHeightPerScroll() {
        return 8;
    }

    public void scrollBy(float amount) {
        this.setScroll(this.getAmountScrolled() + amount);
    }

    public void setScroll(float amount) {
        float prevScrollAmount = this.getAmountScrolled();
        this.setAmountScrolled(amount);
        this.bindAmountScrolled();
        if (this.getAmountScrolled() != prevScrollAmount) {
            int scrollDiff = (int)(this.getAmountScrolled() - prevScrollAmount);
            for (DynamicWidget widget : this.getWidgets()) {
                widget.setControlPosY(widget.getControlPosY() - scrollDiff);
            }
        }
    }

    public void checkScrollbarClick(double mouseX, double mouseY, int button) {
        this.clickedScrollbar = button == 0 && MathUtils.isWithinValue(mouseX, this.getScrollBarX(), this.getScrollBarX() + this.getScrollBarWidth(), true, false);
    }

    public void bindAmountScrolled() {
        this.setAmountScrolled(MathUtils.clamp(this.getAmountScrolled(), 0.0f, (float)this.getMaxScroll()));
    }

    public float getAmountScrolled() {
        return this.amountScrolled;
    }

    public void setAmountScrolled(float scrolled) {
        this.amountScrolled = scrolled;
    }

    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.getBottom() - this.getPadding()));
    }

    public int getBarHeight() {
        if (!this.needsScrollbar()) {
            return 0;
        }
        int barHeight = this.getScreenHeight() * this.getScreenHeight() / this.getContentHeight();
        return MathUtils.clamp(barHeight, 32, this.getScreenHeight() - this.getPadding() * 2);
    }

    public boolean needsScrollbar() {
        return this.getMaxScroll() > 0;
    }

    @Override
    public int getMaxWidth() {
        return this.getScreenWidth() - this.getPadding() - this.getScrollBarWidth();
    }
}

